/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.cache.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.resources.IFile;
import org.mule.tooling.core.cache.internal.MuleConfigurationEntry;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public class MuleConfigurationsCacheMap {
    private final ConcurrentMap<IFile, MuleConfigurationEntry> fileToConfigMap;

    public MuleConfigurationsCacheMap() {
        this.fileToConfigMap = new ConcurrentHashMap<IFile, MuleConfigurationEntry>();
    }

    public MuleConfigurationsCacheMap(int initialCapacity) {
        this.fileToConfigMap = new ConcurrentHashMap<IFile, MuleConfigurationEntry>(Math.max(10, initialCapacity));
    }

    public MuleConfigurationsCacheMap(MuleConfigurationsCacheMap other) {
        this.fileToConfigMap = new ConcurrentHashMap<IFile, MuleConfigurationEntry>(other.fileToConfigMap.size());
        this.fileToConfigMap.putAll(other.fileToConfigMap);
    }

    public boolean isEmpty() {
        return this.fileToConfigMap.isEmpty();
    }

    public void clear() {
        this.fileToConfigMap.clear();
    }

    public boolean containsKey(IFile fileKey) {
        return this.fileToConfigMap.containsKey(fileKey);
    }

    public boolean containsKey(MuleConfiguration configKey) {
        if (configKey == null) {
            return false;
        }
        Collection values = this.fileToConfigMap.values();
        for (MuleConfigurationEntry muleConfigurationEntry : values) {
            if (!configKey.equals(muleConfigurationEntry.getMuleConfiguration())) continue;
            return true;
        }
        return false;
    }

    public MuleConfigurationEntry get(IFile fileKey) {
        if (fileKey == null) {
            return null;
        }
        return (MuleConfigurationEntry)this.fileToConfigMap.get(fileKey);
    }

    public MuleConfigurationEntry get(MuleConfiguration configKey) {
        if (configKey == null) {
            return null;
        }
        Collection values = this.fileToConfigMap.values();
        for (MuleConfigurationEntry muleConfigurationEntry : values) {
            if (!configKey.equals(muleConfigurationEntry.getMuleConfiguration())) continue;
            return muleConfigurationEntry;
        }
        return null;
    }

    public MuleConfigurationEntry put(MuleConfigurationEntry entry) {
        return this.fileToConfigMap.put(entry.getConfigurationFile(), entry);
    }

    public void putAll(MuleConfigurationsCacheMap map) {
        this.fileToConfigMap.putAll(map.fileToConfigMap);
    }

    public MuleConfigurationEntry remove(IFile key) {
        return (MuleConfigurationEntry)this.fileToConfigMap.remove(key);
    }

    public int size() {
        return this.fileToConfigMap.size();
    }

    public List<MuleConfigurationEntry> getValues() {
        return new ArrayList<MuleConfigurationEntry>(this.fileToConfigMap.values());
    }

    public List<IFile> getConfigurationFiles() {
        return new ArrayList<IFile>(this.fileToConfigMap.keySet());
    }

    public List<MuleConfiguration> getMuleConfigurations() {
        Collection values = this.fileToConfigMap.values();
        ArrayList<MuleConfiguration> muleConfigurations = new ArrayList<MuleConfiguration>(values.size());
        for (MuleConfigurationEntry muleConfigurationEntry : values) {
            MuleConfiguration muleConfiguration = muleConfigurationEntry.getMuleConfiguration();
            if (muleConfiguration == null) continue;
            muleConfigurations.add(muleConfiguration);
        }
        return muleConfigurations;
    }
}

