/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.cache.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.cache.IXmlConfigurationProvider;
import org.mule.tooling.core.cache.MuleConfigurationUtils;
import org.mule.tooling.core.cache.internal.DefaultXmlConfigurationProvider;
import org.mule.tooling.core.cache.internal.ExternalMuleContentHandler;
import org.mule.tooling.core.cache.internal.MuleConfigurationEntry;
import org.mule.tooling.core.cache.internal.MuleConfigurationsCacheMap;
import org.mule.tooling.core.cache.internal.StringXmlConfigurationProvider;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.MessageFlowEntityDeletedEvent;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.MuleProjectResourceVisitor;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.MuleConfigurationTraverser;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.ICanEvalGlobalRefs;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.InMemoryConfigurationFile;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleConfigurationsCache
implements IMuleConfigurationsCache {
    private static final String EXTERNAL_CONFIG_PREFIX = "__external_mule_config__";
    private final MuleConfigurationsCacheMap savedConfigsCache;
    private final MuleConfigurationsCacheMap notSavedConfigsCache;
    private final MuleConfigurationsCacheMap externalConfigsCache;
    private final Map<IFile, List<IFile>> oldRelatedConfigs = new ConcurrentHashMap<IFile, List<IFile>>();
    private final BaseMuleProject muleProject;
    private final Object lock = new Object();
    private volatile boolean isValidCache = false;
    private final EventBus eventBus;
    private EventBusHelper eventBusHelper;

    public MuleConfigurationsCache(MuleConfigurationsCache other) {
        this(other.muleProject);
        this.oldRelatedConfigs.putAll(other.oldRelatedConfigs);
        other.unregisterListener();
    }

    public MuleConfigurationsCache(BaseMuleProject muleProject) {
        this.muleProject = muleProject;
        this.eventBus = MuleCorePlugin.getEventBus();
        this.eventBusHelper = new EventBusHelper();
        this.savedConfigsCache = new MuleConfigurationsCacheMap();
        this.notSavedConfigsCache = new MuleConfigurationsCacheMap();
        this.externalConfigsCache = new MuleConfigurationsCacheMap();
    }

    public void initialize() {
        this.eventBusHelper.registerListener(this.eventBus, CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new IMuleProjectEventListener(){

            @Override
            public void onMuleProjectOpened(IProject project) {
            }

            @Override
            public void onMuleProjectPreClose(IMuleProject project) {
                MuleConfigurationsCache.this.onProjectDelete(project);
            }

            @Override
            public void onMuleProjectClosed(IProject project) {
            }
        });
        this.eventBusHelper.registerListener(this.eventBus, CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, event -> {
            IFile file = event.getFile();
            if (this.isValidCache() && this.isRelevantEvent(event) && file.getProject().equals((Object)this.getProject()) && !MuleResourceUtils.isLog4jRelatedFile((IResource)file)) {
                this.invalidate(file);
                if (event.isEventType(FileChangedEvent.ChangeType.DELETED) && MuleResourceUtils.isApplicationTypesFile((IResource)event.getFile())) {
                    this.eventBus.fireEvent((IEvent)FileChangedEvent.deleted(file));
                }
            }
        });
        IClasspathEventListener classpathListener = new IClasspathEventListener(){

            @Override
            public void onJarRemovedFromClasspath(File file, IMuleProject muleProject) {
                if (muleProject.getProject() == MuleConfigurationsCache.this.getProject()) {
                    MuleConfigurationsCache.this.isValidCache = false;
                }
            }

            @Override
            public void onJarAddedToClasspath(File file, IMuleProject muleProject) {
                if (muleProject.getProject() == MuleConfigurationsCache.this.getProject()) {
                    MuleConfigurationsCache.this.isValidCache = false;
                }
            }

            @Override
            public void onExtensionRemovedFromClasspath(MuleExtension removedExtension, IMuleProject muleProject) {
            }

            @Override
            public void onApiRemovedFromClasspath(MavenDependency removedExtension, IMuleProject muleProject) {
            }
        };
        this.eventBusHelper.registerListener(this.eventBus, CoreEventTypes.ON_JAR_ADDED, (IEventHandler)classpathListener);
        this.eventBusHelper.registerListener(this.eventBus, CoreEventTypes.ON_JAR_REMOVED, (IEventHandler)classpathListener);
    }

    private boolean isRelevantEvent(FileChangedEvent event) {
        return !event.isInOutputLocation() && !event.isEventType(FileChangedEvent.ChangeType.MARKERS);
    }

    private void unregisterListener() {
        this.eventBusHelper.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.isValidCache = false;
            if (this.getProject().isAccessible()) {
                this.cleanupDeletedEntries();
            }
        }
    }

    @Override
    public List<MuleConfiguration> getConfigurations() {
        return this.getUpdatedMergedCache().getMuleConfigurations();
    }

    @Override
    public List<MuleConfiguration> getNotSavedConfigurations() {
        return this.notSavedConfigsCache.getMuleConfigurations();
    }

    @Override
    public List<MuleConfiguration> getExternalConfigurations() {
        this.updateCacheIfNecessary();
        return this.externalConfigsCache.getMuleConfigurations();
    }

    @Override
    public Pair<MuleConfiguration, Container> searchMuleFlowByName(String flowName) {
        List<MuleConfiguration> configurations = this.getConfigurations();
        for (MuleConfiguration muleConfiguration : configurations) {
            List<Container> flows = muleConfiguration.getFlows();
            for (Container flow : flows) {
                if (!flow.getName().equals(flowName)) continue;
                return new Pair((Object)muleConfiguration, (Object)flow);
            }
        }
        return null;
    }

    @Override
    public List<IMessageFlowNode> getFlowReferencesByFlowName(final String flowName) {
        final ArrayList<IMessageFlowNode> references = new ArrayList<IMessageFlowNode>();
        for (MuleConfiguration muleConfiguration : this.getConfigurations()) {
            MuleConfigurationTraverser visitor = new MuleConfigurationTraverser(muleConfiguration){

                @Override
                public void visitPatternNode(PatternNode patternNode) {
                    Optional.ofNullable((IReadOnlyProperty)patternNode.getProperties().getProperty("name")).ifPresent(property -> {
                        if (ModelUtils.isFlowRef(patternNode) && flowName.equals(property.getValue())) {
                            references.add(patternNode);
                        }
                    });
                }
            };
            visitor.traverse();
        }
        return references;
    }

    @Override
    public List<IMessageFlowNode> getErrorHandlersReferencesByErrorHandlerName(final String errorHandlerName) {
        final ArrayList<IMessageFlowNode> references = new ArrayList<IMessageFlowNode>();
        for (MuleConfiguration muleConfiguration : this.getConfigurations()) {
            MessageFlowEntityVisitorAdapter visitor = new MessageFlowEntityVisitorAdapter(){

                @Override
                public void visitNestedContainer(NestedContainer nestedContainer) {
                    if (ModelUtils.isErrorHandler(nestedContainer.getDefinition())) {
                        Optional.ofNullable((IReadOnlyProperty)nestedContainer.getProperties().getProperty("ref")).ifPresent(property -> {
                            if (errorHandlerName.equals(property.getValue())) {
                                references.add(nestedContainer);
                            }
                        });
                    }
                }

                @Override
                public void visitContainer(Container container) {
                    container.getNestedContainers().forEach(nc -> nc.accept(this));
                }

                @Override
                public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                    muleConfiguration.getFlows().forEach(f -> f.accept(this));
                }
            };
            muleConfiguration.accept(visitor);
        }
        return references;
    }

    @Override
    public List<IMessageFlowNode> getAllFlowReferences() {
        final ArrayList<IMessageFlowNode> references = new ArrayList<IMessageFlowNode>();
        for (MuleConfiguration muleConfiguration : this.getConfigurations()) {
            MuleConfigurationTraverser visitor = new MuleConfigurationTraverser(muleConfiguration){

                @Override
                public void visitPatternNode(PatternNode patternNode) {
                    if (ModelUtils.isFlowRef(patternNode)) {
                        references.add(patternNode);
                    }
                }
            };
            visitor.traverse();
        }
        return references;
    }

    private MuleConfigurationsCacheMap getUpdatedMergedCache() {
        this.updateCacheIfNecessary();
        return this.getMergedCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheIfNecessary() {
        block6: {
            try {
                if (this.isValidCache || !this.checkProjectAccessible()) break block6;
                IProject project = this.getProject();
                CacheUpdaterVisitor visitor = new CacheUpdaterVisitor(this);
                List externalMuleConfigurations = StudioDesignContextRunner.runWithMuleProjectThrowingCoreException(() -> this.lambda$1((IResource)project, visitor), (IMuleProject)this.muleProject);
                Object object = this.lock;
                synchronized (object) {
                    if (!this.isValidCache && this.checkProjectAccessible()) {
                        this.cleanupDeletedEntries();
                        visitor.getNewEntries().forEach(this::addSavedMuleConfiguration);
                        this.externalConfigsCache.clear();
                        externalMuleConfigurations.forEach(this.externalConfigsCache::put);
                        this.isValidCache = true;
                    }
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError(e.getMessage(), e);
            }
        }
    }

    private List<MuleConfigurationEntry> getExternalConfigurations(Collection<MuleConfigurationEntry> cacheEntries) {
        Collection newConfigurations = cacheEntries.stream().map(entry -> {
            if (this.notSavedConfigsCache.containsKey(entry.getConfigurationFile())) {
                return this.notSavedConfigsCache.get(entry.getConfigurationFile()).getMuleConfiguration();
            }
            return entry.getMuleConfiguration();
        }).collect(Collectors.toSet());
        Map<File, Set<String>> referencedExternalConfigurations = this.muleProject.getReferencedExternalConfigurations(newConfigurations);
        return MuleConfigurationsCache.loadReferencedExternalConfigurations(this.muleProject, referencedExternalConfigurations);
    }

    private boolean checkProjectAccessible() {
        IProject myProject = this.getProject();
        boolean isAccessible = myProject.isAccessible();
        if (!isAccessible) {
            MuleCorePlugin.logWarning("Attempting to refresh the Configurations Cache for a non-accessible project: " + myProject.getName());
        }
        return isAccessible;
    }

    private MuleConfigurationsCacheMap getMergedCache() {
        int initialCapacity = this.savedConfigsCache.size() + this.externalConfigsCache.size() + this.notSavedConfigsCache.size();
        MuleConfigurationsCacheMap map = new MuleConfigurationsCacheMap(initialCapacity);
        map.putAll(this.savedConfigsCache);
        map.putAll(this.externalConfigsCache);
        map.putAll(this.notSavedConfigsCache);
        return map;
    }

    private ICanEvalGlobalRefs getAbstractComponentMeta(NodeDefinition def) {
        return def.getService(ICanEvalGlobalRefs.class);
    }

    @Override
    public MuleConfiguration getConfiguration(IFile muleConfigurationFile) {
        MuleConfigurationEntry entry = this.getConfigurationEntry(muleConfigurationFile);
        return entry != null ? entry.getMuleConfiguration() : null;
    }

    @Override
    public IFile getConfigurationFile(MuleConfiguration muleConfiguration) {
        MuleConfigurationEntry entry = this.getConfigurationEntry(muleConfiguration);
        return entry != null ? entry.getConfigurationFile() : null;
    }

    @Override
    public IXmlConfigurationProvider getXmlConfigurationProvider(IFile muleConfigurationFile) {
        MuleConfigurationEntry entry = this.getConfigurationEntry(muleConfigurationFile);
        return entry != null ? entry.getXmlProvider() : null;
    }

    private MuleConfigurationEntry getConfigurationEntry(IFile muleConfigurationFile) {
        return this.getUpdatedMergedCache().get(muleConfigurationFile);
    }

    private MuleConfigurationEntry getConfigurationEntry(MuleConfiguration muleConfiguration) {
        return this.getUpdatedMergedCache().get(muleConfiguration);
    }

    @Override
    public Set<MuleConfiguration> getRelatedConfigs(MuleConfiguration config) {
        List<IFile> oldRelatedFiles;
        HashSet<MuleConfiguration> referencedConfigs = new HashSet<MuleConfiguration>();
        ArrayList<String> referenceableFlows = new ArrayList<String>();
        List<IMessageFlowEntity> globalEntries = config.getGlobalEntries();
        referenceableFlows.addAll(config.getFlows().stream().map(MessageFlowNode::getName).collect(Collectors.toList()));
        for (MuleConfiguration muleConfiguration : this.getUpdatedMergedCache().getMuleConfigurations()) {
            if (muleConfiguration.equals(config)) continue;
            List<MuleConfiguration> configurationsImportedInConfig = CoreUtils.collectMuleConfigurationsImportedInConfig(this.muleProject, muleConfiguration);
            if (configurationsImportedInConfig.contains(config)) {
                referencedConfigs.add(muleConfiguration);
                continue;
            }
            MuleConfigurationDependenciesTraverser muleConfigurationDependenciesTraverser = new MuleConfigurationDependenciesTraverser(muleConfiguration, globalEntries, referenceableFlows);
            muleConfigurationDependenciesTraverser.traverse();
            referencedConfigs.addAll(muleConfigurationDependenciesTraverser.getDependantConfigs());
        }
        IFile configurationFile = this.getConfigurationFile(config);
        if (configurationFile != null && (oldRelatedFiles = this.oldRelatedConfigs.remove(configurationFile)) != null) {
            referencedConfigs.addAll(oldRelatedFiles.stream().map(this::getConfiguration).collect(Collectors.toList()));
        }
        return referencedConfigs;
    }

    @Override
    public Set<MuleConfiguration> getRelatedConfigs(IFile file) {
        MuleConfiguration config = this.getConfiguration(file);
        return config != null ? this.getRelatedConfigs(config) : new HashSet();
    }

    @Override
    public void savePreviousRelatedConfigs(IFile file) {
        Set<MuleConfiguration> relatedConfigs = this.getRelatedConfigs(file);
        List relatedFiles = relatedConfigs.stream().map(this::getConfigurationFile).collect(Collectors.toList());
        if (!relatedFiles.isEmpty()) {
            this.oldRelatedConfigs.put(file, relatedFiles);
        }
    }

    private void cleanupDeletedEntries() {
        List<IFile> configurationFiles = this.savedConfigsCache.getConfigurationFiles();
        for (IFile file : configurationFiles) {
            if (file == null || file.isSynchronized(0) && file.exists()) continue;
            MuleConfigurationEntry removedEntry = this.savedConfigsCache.remove(file);
            removedEntry.getMuleConfiguration().getGlobalEntries().forEach(global -> this.notifiedEntityDeleted(removedEntry, (IMessageFlowEntity)global));
        }
    }

    private void notifiedEntityDeleted(MuleConfigurationEntry removedEntry, IMessageFlowEntity global) {
        this.eventBus.fireEvent((IEvent)new MessageFlowEntityDeletedEvent(this.muleProject, removedEntry.getConfigurationFile(), removedEntry.getMuleConfiguration(), global));
    }

    private void addSavedMuleConfiguration(MuleConfigurationEntry entry) {
        if (entry == null || entry.getMuleConfiguration() == null) {
            throw new IllegalArgumentException("Illegal argument. Cannot store a null MuleConfiguration in the cache.");
        }
        this.savedConfigsCache.put(entry);
    }

    @Override
    public IFile searchConfigurationFileByFlow(Container flow) {
        List<MuleConfigurationEntry> configurationEntries = this.getUpdatedMergedCache().getValues();
        for (MuleConfigurationEntry muleConfigurationEntry : configurationEntries) {
            MuleConfiguration muleConfiguration = muleConfigurationEntry.getMuleConfiguration();
            List<Container> flows = muleConfiguration.getFlows();
            for (Container currentFlow : flows) {
                if (!currentFlow.equals(flow)) continue;
                return muleConfigurationEntry.getConfigurationFile();
            }
        }
        return null;
    }

    @Override
    public void addNotSavedConfig(IFile xmlConfigFile, MuleConfiguration config, IXmlConfigurationProvider xmlProvider) {
        if (config == null) {
            throw new IllegalArgumentException("Illegal argument. Cannot store a null MuleConfiguration in the cache.");
        }
        if (!MuleResourceUtils.belongsToDefaultMulePaths(xmlConfigFile)) {
            MuleConfigurationUtils.setScopeAndVisibility(xmlConfigFile, config);
        }
        MuleConfigurationEntry entry = new MuleConfigurationEntry(xmlConfigFile, config, xmlProvider, xmlConfigFile.getModificationStamp());
        this.notSavedConfigsCache.put(entry);
    }

    private static MuleConfigurationEntry createExternalConfigurationEntry(IMuleProject muleProject, InputStream newInputStream, String fileName, java.nio.file.Path filePath, Charset charset) {
        MuleConfigurationEntry entry = null;
        try {
            String content = CoreUtils.inputStreamToString(newInputStream, charset.name());
            MuleConfiguration newMuleConfiguration = MuleConfigurationUtils.createTemporaryNewMuleConfiguration(muleProject, content, fileName, charset);
            newMuleConfiguration.setReadOnly(true);
            Path newPath = new Path(filePath.toString());
            InMemoryConfigurationFile inMemoryTempFile = InMemoryConfigurationFile.createInMemoryConfigurationFile((IPath)newPath, (String)fileName, (InMemoryFile.IContentHandler)new ExternalMuleContentHandler(content, newPath), (IProject)muleProject.getProject());
            entry = new MuleConfigurationEntry((IFile)inMemoryTempFile, newMuleConfiguration, new StringXmlConfigurationProvider(content), inMemoryTempFile.getModificationStamp());
        }
        catch (Exception e) {
            MuleCorePlugin.logError("Cannot create virtual config for configuration name " + fileName, e);
        }
        return entry;
    }

    @Override
    public void removeNotSavedConfig(IFile xmlConfigFile) {
        this.notSavedConfigsCache.remove(xmlConfigFile);
    }

    @Override
    public List<IFile> getConfigurationResources() throws CoreException {
        return new ArrayList<IFile>(this.getUpdatedMergedCache().getConfigurationFiles());
    }

    private BaseMuleProject getMuleProject() {
        return this.muleProject;
    }

    @Override
    public Map<IFile, MuleConfiguration> getResourceToConfigMap() {
        MuleConfigurationsCacheMap cache = this.getUpdatedMergedCache();
        HashMap<IFile, MuleConfiguration> result = new HashMap<IFile, MuleConfiguration>();
        for (MuleConfigurationEntry entry : cache.getValues()) {
            result.put(entry.getConfigurationFile(), entry.getMuleConfiguration());
        }
        return result;
    }

    private void invalidate(IFile file) {
        try {
            this.savePreviousRelatedConfigs(file);
        }
        finally {
            this.invalidate();
        }
    }

    private boolean isValidCache() {
        return this.isValidCache;
    }

    private IProject getProject() {
        return this.getMuleProject().getProject();
    }

    private void onProjectDelete(IMuleProject project) {
        try {
            if (project.getProject().equals((Object)this.getProject()) && CoreUtils.hasMuleNature(project.getProject())) {
                this.unregisterListener();
                this.savedConfigsCache.clear();
                this.notSavedConfigsCache.clear();
                this.externalConfigsCache.clear();
                this.oldRelatedConfigs.clear();
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError(e.getStatus() != null ? e.getStatus().getMessage() : "Error checking project nature", e);
        }
    }

    private static MuleConfiguration createMuleConfiguration(IMuleProject muleProject, IFile configFile) throws CoreException {
        InputStream configStream = configFile.getContents();
        try {
            EditingScope scope = ProjectStructureContributionManager.getDefault().getScope((IResource)configFile);
            MuleConfiguration muleConfiguration = StudioDesignContextRunner.runWithContextThrowingCoreException(() -> MuleConfigurationUtils.createTemporaryNewMuleConfiguration(muleProject, CoreUtils.inputStreamToString(configStream), MuleConfigurationUtils.getConfigurationNameFromFile(configFile), MuleResourceUtils.getCharset(configFile)), muleProject, scope);
            return muleConfiguration;
        }
        finally {
            IOUtils.closeQuietly((InputStream)configStream);
        }
    }

    private static List<MuleConfigurationEntry> loadReferencedExternalConfigurations(IMuleProject muleProject, Map<File, Set<String>> referencedExternalConfigurations) {
        int initialCapacity = (int)referencedExternalConfigurations.values().stream().flatMap(Collection::stream).count();
        ArrayList<MuleConfigurationEntry> entries = new ArrayList<MuleConfigurationEntry>(initialCapacity);
        for (Map.Entry<File, Set<String>> entry : referencedExternalConfigurations.entrySet()) {
            Set<String> referencedConfigsInFile = entry.getValue();
            for (String configInJar : referencedConfigsInFile) {
                Optional<MuleConfigurationEntry> configurationEntry = MuleConfigurationsCache.loadExternalConfiguration(muleProject, configInJar, entry.getKey());
                configurationEntry.ifPresent(entries::add);
            }
        }
        return entries;
    }

    private static Optional<MuleConfigurationEntry> loadExternalConfiguration(IMuleProject muleProject, String configInJar, File jar) {
        ObjectHolder entry = new ObjectHolder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileSystem fs = FileSystems.newFileSystem(jar.toPath());){
                java.nio.file.Path zipFilePath = fs.getPath(configInJar, new String[0]);
                StudioDesignContextRunner.runSilentWithMuleProject(() -> {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (InputStream newInputStream = Files.newInputStream(zipFilePath, new OpenOption[0]);){
                        String fileName = zipFilePath.getFileName().toString();
                        Charset charset = IMuleResources.DEFAULT_CHARSET;
                        entry.set((Object)MuleConfigurationsCache.createExternalConfigurationEntry(muleProject, newInputStream, fileName, jar.toPath(), charset));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }, muleProject);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error reading from " + jar.getAbsolutePath(), e);
        }
        return entry.getOptionalValue();
    }

    private /* synthetic */ List lambda$1(IResource iResource, CacheUpdaterVisitor cacheUpdaterVisitor) throws Exception {
        iResource.accept((IResourceVisitor)cacheUpdaterVisitor);
        return this.getExternalConfigurations(cacheUpdaterVisitor.getAllEntries());
    }

    private static final class CacheUpdaterVisitor
    extends MuleProjectResourceVisitor {
        private final String xmlRootNodeName;
        private final BaseMuleProject muleProject;
        private final List<MuleConfigurationEntry> newEntries;
        private final List<MuleConfigurationEntry> allEntries;
        private final MuleConfigurationsCacheMap savedConfigsCache;

        public CacheUpdaterVisitor(MuleConfigurationsCache cache) {
            this.muleProject = cache.getMuleProject();
            this.xmlRootNodeName = this.muleProject.getKind().getXmlRootNodeName();
            this.savedConfigsCache = new MuleConfigurationsCacheMap(cache.savedConfigsCache);
            int initialSize = this.savedConfigsCache.size();
            this.newEntries = new ArrayList<MuleConfigurationEntry>(initialSize);
            this.allEntries = new ArrayList<MuleConfigurationEntry>(initialSize);
        }

        @Override
        public void visitFile(IFile file) {
            if (!this.containsValidSavedConfiguration(file)) {
                if (MuleResourceUtils.isConfigFile((IResource)file, this.xmlRootNodeName)) {
                    try {
                        MuleConfiguration config = MuleConfigurationsCache.createMuleConfiguration(this.muleProject, file);
                        if (!MuleResourceUtils.belongsToDefaultMulePaths(file)) {
                            MuleConfigurationUtils.setScopeAndVisibility(file, config);
                        }
                        MuleConfigurationEntry newEntry = new MuleConfigurationEntry(file, config, new DefaultXmlConfigurationProvider(file), file.getModificationStamp());
                        this.addNewEntry(newEntry);
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError("Error found visiting config file " + file.getName() + ". The file might be corrupted.", e);
                    }
                }
            } else {
                this.allEntries.add(this.savedConfigsCache.get(file));
            }
        }

        private void addNewEntry(MuleConfigurationEntry newEntry) {
            this.allEntries.add(newEntry);
            this.newEntries.add(newEntry);
        }

        public List<MuleConfigurationEntry> getNewEntries() {
            return this.newEntries;
        }

        public Collection<MuleConfigurationEntry> getAllEntries() {
            return this.allEntries;
        }

        private boolean containsValidSavedConfiguration(IFile configurationFile) {
            MuleConfigurationEntry configurationEntry = this.savedConfigsCache.get(configurationFile);
            return configurationEntry != null && configurationFile.getModificationStamp() == configurationEntry.getTimeStamp();
        }
    }

    private final class MuleConfigurationDependenciesTraverser
    extends MuleConfigurationTraverser {
        private final List<IMessageFlowEntity> globalEntries;
        private final List<String> referenceableFlows;
        private final Set<MuleConfiguration> referencedConfigs;

        private MuleConfigurationDependenciesTraverser(MuleConfiguration muleConfig, List<IMessageFlowEntity> globalEntries, List<String> referenceableFlows) {
            super(muleConfig);
            this.referencedConfigs = new HashSet<MuleConfiguration>();
            this.globalEntries = globalEntries;
            this.referenceableFlows = referenceableFlows;
        }

        @Override
        protected boolean visitMessageFlowNode(IMessageFlowNode node) {
            String type = node.getType();
            NodeDefinition definition = node.getDefinition();
            if (definition == null) {
                if (node instanceof GlobalElement) {
                    definition = MuleCorePlugin.getModuleManager().getGlobalDefinition(type);
                } else if (MuleCorePlugin.getModuleManager().hasDefinition(type)) {
                    definition = MuleCorePlugin.getModuleManager().getDefinition(type);
                }
            }
            if (ModelUtils.isComment(node)) {
                return true;
            }
            if (definition == null) {
                throw new RuntimeException("Unknown node type in " + node.getClass().getName() + ": " + type);
            }
            ArrayList<String> containerRefs = new ArrayList<String>();
            ICanEvalGlobalRefs abstractComponentMeta = MuleConfigurationsCache.this.getAbstractComponentMeta(definition);
            boolean anyGlobalRefsFound = false;
            if (abstractComponentMeta != null) {
                containerRefs.addAll(abstractComponentMeta.getFlowRefsNames(node));
                boolean anyRefFlows = containerRefs.stream().anyMatch(this.referenceableFlows::contains);
                if (anyRefFlows) {
                    this.referencedConfigs.add(this.getConfiguration());
                    return false;
                }
                Map<String, String> globalRefsNames = abstractComponentMeta.getGlobalRefsNames(node);
                for (Map.Entry<String, String> entry : globalRefsNames.entrySet()) {
                    anyGlobalRefsFound = this.globalEntries.stream().anyMatch(input -> {
                        GlobalUnknown u;
                        String unknownName;
                        boolean result = false;
                        if (input instanceof GlobalElement) {
                            GlobalElement globalElement = (GlobalElement)input;
                            PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(globalElement.getProperties());
                            String property = propertyCollectionMap.getProperty((String)entry.getValue(), null);
                            String property2 = propertyCollectionMap.getProperty("id", null);
                            if (property2 != null) {
                                result = property2.equals(entry.getKey());
                            }
                            if (property == null) {
                                property = property2;
                            }
                            if (property == null) {
                                property = propertyCollectionMap.getProperty("name", null);
                            }
                            if (property != null) {
                                result = result || property.equals(entry.getKey());
                            }
                        } else if (input instanceof GlobalUnknown && (unknownName = (u = (GlobalUnknown)input).getUnknownName()) != null) {
                            result = result || unknownName.equals(entry.getKey());
                        }
                        return result;
                    });
                    if (anyGlobalRefsFound) break;
                }
            }
            if (anyGlobalRefsFound) {
                this.referencedConfigs.add(this.getConfiguration());
                return false;
            }
            return true;
        }

        public Set<MuleConfiguration> getDependantConfigs() {
            return this.referencedConfigs;
        }
    }
}

