/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.cache.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.cache.IXmlConfigurationProvider;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.utils.Pair;

public class CompositeConfigurationsCache
implements IMuleConfigurationsCache {
    private IMuleConfigurationsCache baseCache;
    private IMuleConfigurationsCache domainCache;

    public CompositeConfigurationsCache(IMuleConfigurationsCache baseCache, IMuleConfigurationsCache domainCache) {
        this.baseCache = baseCache;
        this.domainCache = domainCache;
    }

    @Override
    public List<MuleConfiguration> getConfigurations() {
        ArrayList<MuleConfiguration> configurations = new ArrayList<MuleConfiguration>(this.baseCache.getConfigurations());
        configurations.addAll(this.domainCache.getConfigurations());
        return configurations;
    }

    @Override
    public List<MuleConfiguration> getNotSavedConfigurations() {
        ArrayList<MuleConfiguration> configurations = new ArrayList<MuleConfiguration>(this.baseCache.getNotSavedConfigurations());
        configurations.addAll(this.domainCache.getNotSavedConfigurations());
        return configurations;
    }

    @Override
    public List<MuleConfiguration> getExternalConfigurations() {
        ArrayList<MuleConfiguration> externalConfigurations = new ArrayList<MuleConfiguration>(this.baseCache.getExternalConfigurations());
        externalConfigurations.addAll(this.domainCache.getExternalConfigurations());
        return externalConfigurations;
    }

    @Override
    public Pair<MuleConfiguration, Container> searchMuleFlowByName(String flowName) {
        return this.baseCache.searchMuleFlowByName(flowName);
    }

    @Override
    public MuleConfiguration getConfiguration(IFile muleConfigurationFile) {
        MuleConfiguration configuration = this.baseCache.getConfiguration(muleConfigurationFile);
        if (configuration == null) {
            configuration = this.domainCache.getConfiguration(muleConfigurationFile);
        }
        return configuration;
    }

    @Override
    public IXmlConfigurationProvider getXmlConfigurationProvider(IFile muleConfigurationFile) {
        IXmlConfigurationProvider provider = this.baseCache.getXmlConfigurationProvider(muleConfigurationFile);
        if (provider == null) {
            provider = this.domainCache.getXmlConfigurationProvider(muleConfigurationFile);
        }
        return provider;
    }

    @Override
    public IFile searchConfigurationFileByFlow(Container flow) {
        return this.baseCache.searchConfigurationFileByFlow(flow);
    }

    @Override
    public void addNotSavedConfig(IFile xmlConfigFile, MuleConfiguration config, IXmlConfigurationProvider xmlProvider) {
        this.baseCache.addNotSavedConfig(xmlConfigFile, config, xmlProvider);
    }

    @Override
    public void removeNotSavedConfig(IFile xmlConfigFile) {
        this.baseCache.removeNotSavedConfig(xmlConfigFile);
    }

    @Override
    public List<IFile> getConfigurationResources() throws CoreException {
        ArrayList<IFile> configResources = new ArrayList<IFile>(this.baseCache.getConfigurationResources());
        configResources.addAll(this.domainCache.getConfigurationResources());
        return configResources;
    }

    @Override
    public Map<IFile, MuleConfiguration> getResourceToConfigMap() {
        HashMap<IFile, MuleConfiguration> resourceToConfigMap = new HashMap<IFile, MuleConfiguration>(this.domainCache.getResourceToConfigMap());
        resourceToConfigMap.putAll(this.baseCache.getResourceToConfigMap());
        return resourceToConfigMap;
    }

    @Override
    public IFile getConfigurationFile(MuleConfiguration muleConfiguration) {
        IFile configurationFile = this.baseCache.getConfigurationFile(muleConfiguration);
        if (configurationFile == null) {
            configurationFile = this.domainCache.getConfigurationFile(muleConfiguration);
        }
        return configurationFile;
    }

    @Override
    public Set<MuleConfiguration> getRelatedConfigs(IFile config) {
        MuleConfiguration configuration = this.getConfiguration(config);
        return this.getRelatedConfigs(configuration);
    }

    @Override
    public Set<MuleConfiguration> getRelatedConfigs(MuleConfiguration config) {
        Set<MuleConfiguration> relatedConfigs = this.baseCache.getRelatedConfigs(config);
        relatedConfigs.addAll(this.domainCache.getRelatedConfigs(config));
        return relatedConfigs;
    }

    @Override
    public void savePreviousRelatedConfigs(IFile file) {
        this.baseCache.savePreviousRelatedConfigs(file);
        this.domainCache.savePreviousRelatedConfigs(file);
    }

    @Override
    public List<IMessageFlowNode> getFlowReferencesByFlowName(String flowName) {
        return this.baseCache.getFlowReferencesByFlowName(flowName);
    }

    @Override
    public List<IMessageFlowNode> getErrorHandlersReferencesByErrorHandlerName(String errorHandlerName) {
        return this.baseCache.getErrorHandlersReferencesByErrorHandlerName(errorHandlerName);
    }

    @Override
    public List<IMessageFlowNode> getAllFlowReferences() {
        return Collections.emptyList();
    }
}

