/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.util.BufferedLimitedStream;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.dom.DOMFactory;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.w3c.dom.Document;

public class MuleConfigurationUtils {
    public static final String MAX_CONFIG_FILESIZE = "max_config_filesize";

    public static MuleConfiguration createTemporaryNewMuleConfiguration(IMuleProject muleProject, String xmlContents, String configurationName, Charset charset) throws Exception {
        if (StringUtils.isBlank((CharSequence)xmlContents)) {
            throw new IllegalArgumentException("Mule configuration [" + configurationName + ".xml] cannot be empty");
        }
        IDOMModel structuredModel = MuleConfigurationUtils.getDomModel(xmlContents, configurationName, charset);
        if (structuredModel != null) {
            return MuleConfigurationUtils.createTemporaryNewMuleConfiguration(muleProject, configurationName, structuredModel);
        }
        throw new IllegalArgumentException("Could not retrieve DOM model for configuration name: " + configurationName);
    }

    public static MuleConfiguration createTemporaryNewMuleConfiguration(IMuleProject muleProject, String configurationName, IDOMModel structuredModel) throws CoreException {
        IDOMDocument document = structuredModel.getDocument();
        MuleToFlowTransformer xform = new MuleToFlowTransformer();
        MuleConfiguration flow = xform.transform(DOMFactory.from((Document)document, muleProject.getSchemaLocationLookup()), muleProject.getServerDefinition().getVersionWithEESign());
        flow.setName(configurationName);
        return flow;
    }

    public static IDOMModel getDomModel(String xmlContents, String configurationName, Charset charset) {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.mule.tooling.ui");
        int maxConfigFileSize = preferenceStore.getInt(MAX_CONFIG_FILESIZE);
        IDOMModel structuredModel = null;
        try {
            String filename = configurationName + ".xml";
            String randomId = UUID.randomUUID().toString().replace("-", "") + filename;
            byte[] contentInBytes = xmlContents.getBytes(charset);
            ByteArrayInputStream model = new ByteArrayInputStream(contentInBytes);
            if (contentInBytes.length > 8192) {
                if (contentInBytes.length > maxConfigFileSize) {
                    MuleCorePlugin.logError("Max file size exceeded when trying to obtain the model for " + configurationName + ". The value can be changed in the AnypointStudio preferences.", new IOException("The max supported file size is " + String.valueOf(maxConfigFileSize)));
                    return structuredModel;
                }
                model = new BufferedLimitedStream((InputStream)model, maxConfigFileSize);
            }
            structuredModel = MuleConfigurationUtils.buildUnmanagedModel(model, randomId);
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was a problem getting the DOM model for configuration name: " + configurationName, e);
        }
        return structuredModel;
    }

    private static IDOMModel buildUnmanagedModel(InputStream modelContents, String modelId) throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel baseModel = modelManager.getModelForRead(modelId, modelContents, null);
        try {
            IDOMModel newModel = (IDOMModel)baseModel.newInstance();
            newModel.setStructuredDocument(baseModel.getStructuredDocument());
            IDOMModel iDOMModel = newModel;
            return iDOMModel;
        }
        finally {
            baseModel.releaseFromRead();
        }
    }

    public static String getConfigurationNameFromFile(IFile configFile) {
        return configFile.getName().substring(0, configFile.getName().lastIndexOf(46));
    }

    public static MuleConfiguration createEmptyMuleConfiguration(IMuleProject project, IFile configFile) {
        MuleConfiguration result = new MuleConfiguration(DOMFactory.newW3CDocumentWrapper(project.getSchemaLocationLookup()));
        result.setName(MuleConfigurationUtils.getConfigurationNameFromFile(configFile));
        return result;
    }

    public static void setScopeAndVisibility(IFile file, MuleConfiguration config) {
        EditingScope editingScope = ProjectStructureContributionManager.getDefault().getScope((IResource)file);
        config.setScope(editingScope.getName());
        config.setVisibility(editingScope.getVisibility());
    }
}

