/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder.messageflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class WrappedInHelper {
    private static final int FIXED_PARAMETERS_SIZE = 3;
    private static final int INDEX_NAME = 0;
    private static final int INDEX_NAMESPACE = 2;
    private static final int INDEX_PREFIX = 1;
    private static final String SEPARATOR = "\"";
    private String wrappedInString;

    public WrappedInHelper(String wrappedInString) {
        this.wrappedInString = wrappedInString;
    }

    public WrappedInHelper(Element element) {
        this.initialize(element);
    }

    private void initialize(Element element) {
        Object[] wrappedInElements = new String[]{element.getName(), element.getNamespacePrefix(), element.getNamespaceURI()};
        this.wrappedInString = StringUtils.join((Object[])wrappedInElements, (String)SEPARATOR);
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            this.wrappedInString = String.valueOf(this.wrappedInString) + SEPARATOR + attribute.getName() + SEPARATOR + attribute.getValue();
        }
    }

    public static WrappedInHelper create(Element element) {
        return new WrappedInHelper(element);
    }

    public static WrappedInHelper create(String wrappedInString) {
        return new WrappedInHelper(wrappedInString);
    }

    public String getWrappedInString() {
        return this.wrappedInString;
    }

    public QName getWrapperQname() {
        String[] splittedWrapper = this.wrappedInString.split(SEPARATOR);
        Namespace namespace = new Namespace(splittedWrapper[1], splittedWrapper[2]);
        return new QName(splittedWrapper[0], namespace);
    }

    public Map<String, String> getAttributes() {
        String[] splittedWrapper = this.wrappedInString.split(SEPARATOR);
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 3;
        while (i < splittedWrapper.length) {
            attributes.put(splittedWrapper[i], splittedWrapper[i + 1]);
            i += 2;
        }
        return attributes;
    }
}

