/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder.messageflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.container.ContainerBehavior;
import org.mule.tooling.core.builder.container.ContainerBehaviorManager;
import org.mule.tooling.core.builder.messageflow.ICanMatchNested;
import org.mule.tooling.core.builder.messageflow.IMuleToFlowTransformer;
import org.mule.tooling.core.builder.messageflow.ModelGeneratorUtils;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.w3c.impl.CommentWrapperW3C;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.IMuleNamespaces;
import org.mule.tooling.core.generator.ISplitterModelGenerator;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.module.QNameMap;
import org.mule.tooling.core.sax.ElementUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.utils.ObjectHolder;

public class MuleToFlowTransformer
implements IMuleToFlowTransformer {
    @Override
    public MuleConfiguration transform(IDocumentWrapper document, String runtimeVersion) throws CoreException {
        MuleConfiguration muleConfiguration = new MuleConfiguration(document);
        GlobalsProcessor globals = new GlobalsProcessor(MuleCorePlugin.getModuleManager().getGlobalQNameMappings(runtimeVersion));
        globals.process(document, muleConfiguration, runtimeVersion);
        FlowProcessor flowProcessor = new FlowProcessor(muleConfiguration, runtimeVersion);
        GlobalFunctionsProcessor globalFunctionsProcessor = new GlobalFunctionsProcessor(muleConfiguration);
        List<ElementProcessor> processors = Arrays.asList(flowProcessor, globalFunctionsProcessor);
        INodeListWrapper<IElementWrapper> childNodes = document.getRootElement().getChildElements();
        for (IElementWrapper element : childNodes) {
            for (ElementProcessor processor : processors) {
                processor.process(element);
            }
        }
        return muleConfiguration;
    }

    protected boolean nodeMatches(IElementWrapper node, Namespace namespace, String name) {
        return node != null && node.getNamespaceURI().equals(namespace.getURI()) && name.equals(node.getName());
    }

    public void processCompartmentLaneEntry(CompartmentLane lane, MuleConfiguration muleConfiguration, IElementWrapper element, String runtimeVersion, NodeDefinition compartmentNodeDefinition) {
        ICanMatchNested service;
        NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinitionForElement(element, runtimeVersion);
        if (def == null && compartmentNodeDefinition != null && (service = compartmentNodeDefinition.getService(ICanMatchNested.class)) != null && service.allowed(element.getQName())) {
            return;
        }
        MessageFlowEntity entity = this.getPopulatedNode(element, muleConfiguration, def, runtimeVersion);
        if (entity != null) {
            lane.getCompartmentLaneEntries().add(entity);
        }
    }

    public MessageFlowEntity getPopulatedNode(final IElementWrapper element, final MuleConfiguration muleConfiguration, NodeDefinition def, final String runtimeVersion) {
        final ObjectHolder result = new ObjectHolder();
        if (def != null) {
            def.accept(new NodeDefinitionVisitorAdapter(){

                @Override
                public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                    result.set((Object)MuleToFlowTransformer.this.processEndpointNode(element, endpointDefinition));
                }

                @Override
                public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                    result.set((Object)MuleToFlowTransformer.this.processContainerNode(element, muleConfiguration, containerDefinition, runtimeVersion));
                }

                @Override
                public void visitPatternDefinition(PatternDefinition patternDefinition) {
                    result.set((Object)MuleToFlowTransformer.this.processPatternNode(element, muleConfiguration, patternDefinition, runtimeVersion));
                }

                @Override
                public void visitSplitterDefinition(SplitterDefinition splitterDefinition) {
                    result.set((Object)MuleToFlowTransformer.this.processSplitterNode(element, muleConfiguration, splitterDefinition, runtimeVersion));
                }
            });
        } else if (element instanceof CommentWrapperW3C) {
            CommentContainer node = this.processCommentContainerNode(element, muleConfiguration, false);
            result.set((Object)node);
        } else {
            UnknownNode unknown = this.processUnknownNode(element);
            boolean isDescription = ElementUtils.isDocumentationElement(element);
            unknown.setDescription(isDescription);
            result.set((Object)unknown);
        }
        return (MessageFlowEntity)result.get();
    }

    protected MessageFlowEntity processSplitterNode(IElementWrapper element, MuleConfiguration muleConfiguration, SplitterDefinition splitterDefinition, String runtime) {
        SplitterNode splitter = MessageFlowFactory.createSplitterNode(splitterDefinition, element);
        IModelGenerator generator = ModelGeneratorUtils.createModelGenerator(splitterDefinition);
        generator.generate(element, splitter);
        ModelGeneratorUtils.addDescription(element, splitter);
        if (generator instanceof ISplitterModelGenerator) {
            ISplitterModelGenerator sgen = (ISplitterModelGenerator)generator;
            List<CompartmentLane> routes = sgen.generateRoutes(element, splitter, runtime);
            for (CompartmentLane route : routes) {
                this.processOneRoute(splitterDefinition, muleConfiguration, runtime, splitter, route);
            }
        }
        return splitter;
    }

    protected CommentContainer processCommentContainerNode(IElementWrapper element, MuleConfiguration muleConfiguration, boolean standalone) {
        return MessageFlowFactory.createCommentContainer(muleConfiguration, element, standalone);
    }

    protected Container processContainerNode(IElementWrapper element, MuleConfiguration muleConfiguration, ContainerDefinition containerDefinition, String runtimeVersion) {
        Container container = MessageFlowFactory.createContainer(muleConfiguration, containerDefinition, element);
        IModelGenerator generator = ModelGeneratorUtils.createModelGenerator(containerDefinition);
        generator.generate(element, container);
        ModelGeneratorUtils.addDescription(element, container);
        INodeListWrapper<IElementWrapper> elements = element.getChildElements();
        this.handleContainerElements(elements, container, containerDefinition, muleConfiguration, runtimeVersion);
        return container;
    }

    private void handleContainerElements(INodeListWrapper<IElementWrapper> elements, Container container, ContainerDefinition containerDefinition, MuleConfiguration muleConfiguration, String runtimeVersion) {
        ArrayList<IElementWrapper> defaultElements = new ArrayList<IElementWrapper>();
        for (IElementWrapper childElement : elements) {
            String type = MuleToFlowTransformer.getDefinitionTypeFrom(childElement);
            NestedContainer nestedContainer = container.getNestedContainer(type);
            if (nestedContainer != null) {
                NestedContainerDefinition nestedContainerDefinition = containerDefinition.getNestedContainerDefinition(type);
                if (nestedContainerDefinition == null) continue;
                this.processNestedContainerNode(nestedContainer, muleConfiguration, childElement, runtimeVersion, nestedContainerDefinition);
                continue;
            }
            if (containerDefinition.getService(ICanMatchNested.class).allowed(childElement.getQName())) continue;
            defaultElements.add(childElement);
        }
        String containerBehaviorId = container.getContainerBehavior();
        ContainerBehavior containerBehavior = ContainerBehaviorManager.instance().getContainerBehavior(containerBehaviorId);
        containerBehavior.handleContainerElements(defaultElements, container, containerDefinition, muleConfiguration, runtimeVersion, this);
    }

    private static String getDefinitionTypeFrom(IElementWrapper childElement) {
        QName childElementQName = childElement.getQName();
        String name = childElementQName.getLocalPart();
        String type = childElementQName.getNamespaceURI() + "/" + name;
        return type;
    }

    private void processNestedContainerNode(NestedContainer nestedContainer, MuleConfiguration muleConfiguration, IElementWrapper childElement, String runtimeVersion, NestedContainerDefinition nestedContainerDefinition) {
        IModelGenerator generator = ModelGeneratorUtils.createModelGenerator(nestedContainerDefinition);
        generator.generate(childElement, nestedContainer);
        ModelGeneratorUtils.addDescription(childElement, nestedContainer);
        INodeListWrapper<IElementWrapper> elements = childElement.getChildElements();
        for (IElementWrapper element : elements) {
            this.processCompartmentLaneEntry(nestedContainer, muleConfiguration, element, runtimeVersion, nestedContainerDefinition);
        }
    }

    protected EndpointNode processEndpointNode(IElementWrapper element, EndpointDefinition epdef) {
        EndpointDirection direction = null;
        List<NodeDefinition> alternativeIds = epdef.getAlternativeIds();
        for (NodeDefinition d : alternativeIds) {
            EndpointDefinition ed = (EndpointDefinition)d;
            if (ed.getInboundMuleElement().equals(element.getQName())) {
                direction = EndpointDirection.INBOUND;
                break;
            }
            if (!ed.getOutboundMuleElement().equals(element.getQName())) continue;
            direction = EndpointDirection.OUTBOUND;
            break;
        }
        if (direction == null) {
            throw new RuntimeException("Element matches endpoint definition but not inbound or outbound elements:" + element.getTagName());
        }
        EndpointNode node = MessageFlowFactory.createEndpointNode(epdef, direction, element);
        IModelGenerator generator = ModelGeneratorUtils.createModelGenerator(epdef);
        generator.generate(element, node);
        ModelGeneratorUtils.addDescription(element, node);
        return node;
    }

    protected MessageFlowNode processPatternNode(IElementWrapper element, MuleConfiguration muleConfiguration, PatternDefinition pdef, String runtime) {
        if (pdef.isCausesSplit()) {
            SplitterNode splitter = MessageFlowFactory.createSplitterNode(pdef, element);
            IModelGenerator generator = ModelGeneratorUtils.createModelGenerator(pdef);
            generator.generate(element, splitter);
            ModelGeneratorUtils.addDescription(element, splitter);
            if (generator instanceof ISplitterModelGenerator) {
                ISplitterModelGenerator sgen = (ISplitterModelGenerator)generator;
                List<CompartmentLane> routes = sgen.generateRoutes(element, splitter, runtime);
                for (CompartmentLane route : routes) {
                    this.processOneRoute(pdef, muleConfiguration, runtime, splitter, route);
                }
            }
            return splitter;
        }
        PatternNode pattern = MessageFlowFactory.createPatternNode(pdef, element);
        IModelGenerator generator = ModelGeneratorUtils.createModelGenerator(pdef);
        generator.generate(element, pattern);
        ModelGeneratorUtils.addDescription(element, pattern);
        return pattern;
    }

    private void processOneRoute(NodeDefinition pdef, MuleConfiguration muleConfiguration, String runtime, SplitterNode splitter, CompartmentLane lane) {
        CompartmentDecorator decorator = new CompartmentDecorator(splitter.getCompartment(), true);
        decorator.addLane(lane);
        IElementWrapper laneElement = lane.getElement();
        for (IElementWrapper element : laneElement.getChildElements()) {
            this.processCompartmentLaneEntry(lane, muleConfiguration, element, runtime, pdef);
        }
    }

    protected UnknownNode processUnknownNode(IElementWrapper element) {
        UnknownNode unknown = MessageFlowFactory.createUnknownNode(element);
        unknown.setContent(element.asXML());
        return unknown;
    }

    protected static interface ElementProcessor {
        public void process(IElementWrapper var1);
    }

    protected class FlowProcessor
    implements ElementProcessor {
        private MuleConfiguration config;
        protected String runtimeVersion;

        public FlowProcessor(MuleConfiguration config, String runtime) {
            this.config = config;
            this.runtimeVersion = runtime;
        }

        @Override
        public void process(IElementWrapper node) {
            IElementWrapper parent = node.getParent();
            if (this.isMuleApplicationConfigurationNode(parent)) {
                NodeDefinition definitionForElement = MuleCorePlugin.getModuleManager().getDefinitionForElement(node, this.runtimeVersion);
                if (definitionForElement instanceof ContainerDefinition) {
                    this.config.getFlows().add(MuleToFlowTransformer.this.processContainerNode(node, this.config, (ContainerDefinition)definitionForElement, this.runtimeVersion));
                } else if (node instanceof CommentWrapperW3C) {
                    this.config.getFlows().add(MuleToFlowTransformer.this.processCommentContainerNode(node, this.config, true));
                }
            }
        }

        public boolean isMuleApplicationConfigurationNode(IElementWrapper parent) {
            return MuleToFlowTransformer.this.nodeMatches(parent, IMuleNamespaces.NS_CORE, "mule") && parent.getParent() == null;
        }
    }

    protected class GlobalFunctionsProcessor
    implements ElementProcessor {
        private static final String GLOBAL_FUNCTIONS = "global-functions";
        private MuleConfiguration config;

        public GlobalFunctionsProcessor(MuleConfiguration config) {
            this.config = config;
        }

        public void process(Element node) {
        }

        @Override
        public void process(IElementWrapper node) {
            if (GLOBAL_FUNCTIONS.equals(node.getQName().getLocalPart())) {
                this.config.setGlobalFunctionInline(node.getText().trim());
            }
        }
    }

    private static final class GlobalsProcessor {
        private static final List<String> IGNORED_GLOBALS = Arrays.asList("flow", "sub-flow");
        private QNameMap<GlobalDefinition> globalQnameToDef;

        public GlobalsProcessor(QNameMap<GlobalDefinition> globalQnameToDef) {
            this.globalQnameToDef = globalQnameToDef;
        }

        public void process(IDocumentWrapper document, MuleConfiguration muleConfiguration, String runtimeVersion) throws CoreException {
            block0: for (IElementWrapper element : document.getRootElement().getChildElements()) {
                if (this.mustIgnoreElement(element, runtimeVersion)) continue;
                GlobalDefinition globalDefinitionForElement = this.getDefinitionForGlobalElement(element, runtimeVersion);
                if (globalDefinitionForElement != null) {
                    GlobalElement globalElement = MessageFlowFactory.createGlobalElement(globalDefinitionForElement, element);
                    IModelGenerator modelGenerator = ModelGeneratorUtils.createModelGenerator(globalDefinitionForElement);
                    modelGenerator.generate(element, globalElement);
                    ModelGeneratorUtils.addDescription(element, globalElement);
                    muleConfiguration.getGlobalEntries().add(globalElement);
                    continue;
                }
                List<GlobalDefinition> globalDefinitions = MuleCorePlugin.getModuleManager().getGlobals(runtimeVersion);
                for (GlobalDefinition globalDefinition : globalDefinitions) {
                    if (globalDefinition.getWrapInLocal() == null || !element.getName().equals(globalDefinition.getWrapInLocal())) continue;
                    INodeListWrapper<IElementWrapper> childNodes = element.getChildElements();
                    for (IElementWrapper currentChild : childNodes) {
                        GlobalDefinition globalDefinitionForChild = this.getDefinitionForGlobalElement(currentChild, runtimeVersion);
                        if (globalDefinitionForChild != null) {
                            GlobalElement globalElement = MessageFlowFactory.createGlobalElement(globalDefinitionForChild, currentChild);
                            globalElement.setWrapInElement(element);
                            IModelGenerator modelGenerator = ModelGeneratorUtils.createModelGenerator(globalDefinitionForChild);
                            modelGenerator.generate(currentChild, globalElement);
                            ModelGeneratorUtils.addDescription(currentChild, globalElement);
                            muleConfiguration.getGlobalEntries().add(globalElement);
                            continue;
                        }
                        GlobalUnknown unknown = this.processGlobalUnknownNode(currentChild);
                        muleConfiguration.getGlobalEntries().add(unknown);
                    }
                    continue block0;
                }
                GlobalUnknown unknown = this.processGlobalUnknownNode(element);
                boolean isDescription = ElementUtils.isDocumentationElement(element);
                String unknownName = element.getAttributeValue("name");
                unknown.setDescription(isDescription);
                if (unknownName != null) {
                    unknown.setUnknownName(unknownName);
                }
                muleConfiguration.getGlobalEntries().add(unknown);
            }
        }

        private boolean mustIgnoreElement(IElementWrapper element, String runtimeVersion) {
            boolean knownFlows = IGNORED_GLOBALS.contains(element.getName());
            NodeDefinition definitionForElement = MuleCorePlugin.getModuleManager().getDefinitionForElement(element, runtimeVersion);
            return knownFlows || definitionForElement instanceof ContainerDefinition || element instanceof CommentWrapperW3C;
        }

        private GlobalDefinition getDefinitionForGlobalElement(IElementWrapper element, String runtimeVersion) {
            IKnowsVersionRange vv;
            GlobalDefinition globalDefinition = this.globalQnameToDef.get(element.getQName());
            if (globalDefinition != null && (vv = globalDefinition.getService(IKnowsVersionRange.class)) != null && !vv.supported(runtimeVersion)) {
                return null;
            }
            return globalDefinition;
        }

        private GlobalUnknown processGlobalUnknownNode(IElementWrapper element) {
            GlobalUnknown unknown = MessageFlowFactory.createGlobalUnknownNode(element);
            IElementWrapper parent = element.getParent();
            if (!MuleResourceUtils.isBegginingOfMuleConfigFile(parent.getName())) {
                IAttributeListWrapper attributes = parent.getAttributes();
                for (IAttributeWrapper attribute : attributes) {
                    unknown.addParentAttribute(attribute.getName(), attribute.getText());
                }
            }
            unknown.setContent(element.asXML());
            return unknown;
        }
    }
}

