/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder.messageflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MuleConfigSchemaLocation {
    private static final String SCHEMA_LOCATION_TOKEN = "\n";
    private static final Pattern SCHEMA_LOCATIONS_LINE_PATTERN = Pattern.compile("(\\s*)(\\S+)(\\s+)(\\S+)(\\s*)");
    private List<String> schemaLocations = new ArrayList<String>();

    public MuleConfigSchemaLocation(String schemaLocationAttributeValue) {
        this.parse(schemaLocationAttributeValue);
    }

    private void parse(String schemaLocationAttributeValue) {
        if (schemaLocationAttributeValue != null) {
            String[] tokens = schemaLocationAttributeValue.trim().split("\\s+");
            int i = 0;
            while (i < tokens.length) {
                String namespace = tokens[i];
                String namespaceLocation = i + 1 < tokens.length ? tokens[i + 1] : null;
                this.add(namespace, namespaceLocation);
                i += 2;
            }
        }
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public List<String> getNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>(this.getSchemaLocations().size());
        for (String schemaLocationPair : this.getSchemaLocations()) {
            Matcher matcher = SCHEMA_LOCATIONS_LINE_PATTERN.matcher(schemaLocationPair);
            if (!matcher.matches()) continue;
            namespaces.add(matcher.group(2));
        }
        return namespaces;
    }

    public boolean hasNamespace(String namespace) {
        for (String schemaLocationPair : this.getSchemaLocations()) {
            if (!schemaLocationPair.startsWith(namespace)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamespaceLocation(String location) {
        if (location != null && location.trim().length() > 0) {
            for (String schemaLocationPair : this.getSchemaLocations()) {
                if (!schemaLocationPair.endsWith(location)) continue;
                return true;
            }
        }
        return false;
    }

    public void add(String namespace, String namespaceLocation) {
        Object schemaLocationPair = null;
        if (namespace != null && namespaceLocation != null) {
            schemaLocationPair = namespace + " " + namespaceLocation;
        } else if (namespace != null) {
            schemaLocationPair = namespace;
        }
        if (schemaLocationPair != null) {
            this.getSchemaLocations().add(((String)schemaLocationPair).trim());
        }
    }

    public void remove(String namespace) {
        if (namespace != null && namespace.trim().length() > 0) {
            int indexToRemove = -1;
            int i = 0;
            while (i < this.getSchemaLocations().size()) {
                if (this.getSchemaLocations().get(i).startsWith(namespace)) {
                    indexToRemove = i;
                    break;
                }
                ++i;
            }
            if (indexToRemove > -1) {
                this.getSchemaLocations().remove(indexToRemove);
            }
        }
    }

    public String getSchemaLocationAttributeValue() {
        StringBuilder attrValue = new StringBuilder();
        Iterator<String> values = this.getSchemaLocations().iterator();
        while (values.hasNext()) {
            attrValue.append(values.next());
            if (!values.hasNext()) continue;
            attrValue.append(SCHEMA_LOCATION_TOKEN);
        }
        return attrValue.toString();
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (!(anotherObject instanceof MuleConfigSchemaLocation)) {
            return false;
        }
        MuleConfigSchemaLocation aSchemaLoc = (MuleConfigSchemaLocation)anotherObject;
        if (this.getSchemaLocations().size() == aSchemaLoc.getSchemaLocations().size()) {
            return this.getSchemaLocations().containsAll(aSchemaLoc.getSchemaLocations());
        }
        return false;
    }
}

