/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder.messageflow;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.IMuleNamespaces;
import org.mule.tooling.core.generator.MuleNamespaces;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.MuleConfigurationNamingSupport;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class ModelGeneratorUtils {
    private static final QName DOC_NAME = QNameUtils.get("name", IMuleNamespaces.NS_MULE_DOC);

    public static IModelGenerator createModelGenerator(NodeDefinition nodeDefinition) {
        try {
            Class<?> modelGenerator = nodeDefinition.getModelGenerator();
            if (modelGenerator != null) {
                return (IModelGenerator)modelGenerator.newInstance();
            }
            return nodeDefinition.getService(IModelGenerator.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Model generator is does not implement " + IModelGenerator.class.getName());
        }
    }

    public static void addDescription(IElementWrapper nodeElement, IMessageFlowNode node) {
        IAttributeWrapper descAttr = nodeElement.getAttribute(MuleNamespaces.getMuleDoc("description"));
        if (descAttr != null) {
            String desc = descAttr.getText();
            node.setDescription(desc);
        }
    }

    public static String getElementName(IElementWrapper element) {
        if (element == null) {
            return null;
        }
        String attrName = element.getAttributeValue("name");
        if (attrName != null) {
            return attrName;
        }
        IAttributeWrapper docNameAttr = element.getAttribute(DOC_NAME);
        if (docNameAttr != null) {
            return docNameAttr.getText();
        }
        return null;
    }

    public static String computeInitialName(NodeDefinition definition, IElementWrapper element) {
        IAttributeWrapper docNameAttribute = element != null ? element.getAttribute(MuleNamespaces.getMuleDoc("name")) : null;
        String currentName = docNameAttribute != null ? docNameAttribute.getText() : null;
        return currentName != null ? currentName : ModelGeneratorUtils.getDefaultName(definition);
    }

    public static String computeInitialName(MuleConfiguration muleConfiguration, ContainerDefinition containerDefinition, String initialName) {
        String name;
        if (muleConfiguration != null && !containerDefinition.isUseDocNameAsDisplayName()) {
            MuleConfigurationNamingSupport naming = new MuleConfigurationNamingSupport(muleConfiguration);
            Object prefix = containerDefinition.getDocName().replace(' ', '_');
            boolean hasNoDefaultDocName = StringUtils.isEmpty((String)containerDefinition.getDefaultDocName());
            if (hasNoDefaultDocName && muleConfiguration.getName() != null) {
                prefix = muleConfiguration.getName().replace(' ', '_') + (String)prefix;
            }
            name = naming.getAvailableName((String)prefix);
        } else {
            name = initialName != null ? initialName : containerDefinition.getName();
        }
        return name;
    }

    private static String getDefaultName(NodeDefinition definition) {
        String docName = null;
        if (definition instanceof GlobalDefinition) {
            docName = definition.getDocName();
        } else if (MuleCorePlugin.getModuleManager().hasDefinition(definition.getId())) {
            docName = definition.getDocName();
        }
        return docName;
    }
}

