/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder.container;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.builder.container.ContainerBehavior;

public class ContainerBehaviorManager {
    private static ContainerBehaviorManager instance;
    private Map<String, ContainerBehavior> idToBehaviorMap = new HashMap<String, ContainerBehavior>();

    public static ContainerBehaviorManager instance() {
        if (instance == null) {
            instance = new ContainerBehaviorManager();
        }
        return instance;
    }

    private ContainerBehaviorManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.core.containerBehavior");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String behaviorId = configurationElement.getAttribute("behaviorId");
                ContainerBehavior behaviorImpl = this.instantiateBehavior(configurationElement);
                this.idToBehaviorMap.put(behaviorId, behaviorImpl);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed loading container behaviors extension points", e);
        }
    }

    public ContainerBehavior getContainerBehavior(String containerBehaviorId) {
        return this.idToBehaviorMap.get(containerBehaviorId);
    }

    protected ContainerBehavior instantiateBehavior(IConfigurationElement configurationElement) throws CoreException {
        return (ContainerBehavior)ContainerBehavior.class.cast(configurationElement.createExecutableExtension("behaviorClass"));
    }
}

