/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.builder.TransformerUtils;
import org.mule.tooling.core.builder.ValidationVisitFileStrategy;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.MuleProjectResourceVisitor;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;

public class ValidationBuildVisitor
extends MuleProjectResourceVisitor {
    protected IProgressMonitor monitor;
    private IMuleProject muleProject;
    private ValidationVisitFileStrategy visitFileStrategy;

    public ValidationBuildVisitor(IProgressMonitor monitor, IMuleProject project, ValidationVisitFileStrategy validationStrategy) {
        this.monitor = monitor;
        this.muleProject = project;
        this.visitFileStrategy = validationStrategy;
    }

    @Override
    public void visitFile(IFile resource) throws CoreException {
        if (this.visitFileStrategy.shouldValidate(resource)) {
            this.validate(this.muleProject, resource);
        }
    }

    private void validate(IMuleProject muleProject, final IFile file) throws CoreException {
        EditingScope editingScope = ProjectStructureContributionManager.getDefault().getScope((IResource)file);
        StudioDesignContextRunner.runSilentWithContext(new Callable<IStatus>(){

            @Override
            public IStatus call() throws Exception {
                if (!ValidationBuildVisitor.this.monitor.isCanceled()) {
                    TransformerUtils.validateConfigFile(file);
                }
                return Status.OK_STATUS;
            }
        }, muleProject, editingScope, Status.CANCEL_STATUS);
    }
}

