/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.mule.tooling.core.builder.BaseErrorMarkerRule;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.model.project.IMuleProjectModel;

public class ValidateDomainLinks
extends BaseErrorMarkerRule {
    @Override
    public boolean evaluate(IProject project) {
        IMuleProjectModel model;
        IMuleApplicationProject applicationProject = MuleProjectKind.APPLICATION.adapt(project);
        if (!applicationProject.hasDefaultDomain() && (model = applicationProject.getMuleProjectModel()) instanceof PomMuleProjectModel) {
            ((PomMuleProjectModel)model).pomChanged();
        }
        return true;
    }

    @Override
    protected String getMarkerType() {
        return "org.mule.tooling.core.muleProjectError";
    }

    @Override
    protected String getMessage() {
        return "Domain project does not exist in the workspace";
    }

    @Override
    public IResource getTargetResource(IProject project) {
        return project.findMember("pom.xml");
    }
}

