/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultCDATA;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.builder.IMuleValidator;
import org.mule.tooling.core.builder.IMuleValidatorFactory;
import org.mule.tooling.core.builder.MuleMarkers;
import org.mule.tooling.core.builder.MuleValidationResult;
import org.mule.tooling.core.cache.IXmlConfigurationProvider;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.xml.sax.Attributes;

public class TransformerUtils {
    private static final String CLASS = "class";
    private static final String VALIDATOR_EXTENSION_POINT = "org.mule.tooling.core.muleValidatorFactory";

    public static void validateConfigFile(IFile configFile) throws CoreException {
        MuleConfiguration config;
        IServerDefinition server;
        Object muleProject = MuleRuntime.create(configFile.getProject());
        if (muleProject != null && (server = muleProject.getServerDefinition()) != null && (config = muleProject.getConfigurationsCache().getResourceToConfigMap().get(configFile)) != null) {
            TransformerUtils.addErrorsForFlow(configFile);
        }
    }

    private static void addErrorsForFlow(IFile xmlConfigFile) throws CoreException {
        MuleMarkers.cleanAllMuleMarkers(xmlConfigFile);
        List<MuleValidationResult> validationResults = TransformerUtils.getValidationResults(xmlConfigFile);
        validationResults.forEach(MuleValidationResult::reportInProblemsPane);
    }

    public static List<MuleValidationResult> getValidationResults(IFile xmlConfigFile) throws CoreException {
        ArrayList<MuleValidationResult> validationResults = new ArrayList<MuleValidationResult>();
        Object project = MuleRuntime.create(xmlConfigFile.getProject());
        IXmlConfigurationProvider xmlConfiguration = project.getConfigurationsCache().getXmlConfigurationProvider(xmlConfigFile);
        org.eclipse.jface.text.Document validatingDocument = null;
        MuleConfiguration config = project.getConfigurationsCache().getConfiguration(xmlConfigFile);
        try {
            validatingDocument = new org.eclipse.jface.text.Document(xmlConfiguration.getXml());
            for (IMuleValidatorFactory muleValidatorFactory : TransformerUtils.getMuleValidatorFactories()) {
                MuleValidationResult validationResult;
                IMuleValidator validator = muleValidatorFactory.getValidator(xmlConfigFile, config);
                try {
                    validator.connect((IDocument)validatingDocument);
                    validationResult = validator.validate(xmlConfigFile, config);
                }
                finally {
                    validator.disconnect((IDocument)validatingDocument);
                }
                validationResults.add(validationResult);
            }
        }
        catch (Exception e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, e.getMessage(), e));
        }
        return validationResults;
    }

    public static List<IMuleValidatorFactory> getMuleValidatorFactories() {
        return Singleton.validatorFactories;
    }

    private static List<IMuleValidatorFactory> doGetMuleValidatorFactories() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(VALIDATOR_EXTENSION_POINT);
        ArrayList<IMuleValidatorFactory> validatorFactories = new ArrayList<IMuleValidatorFactory>(configurationElements.length);
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contribution = iConfigurationElementArray[n2];
            try {
                validatorFactories.add((IMuleValidatorFactory)contribution.createExecutableExtension(CLASS));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return validatorFactories;
    }

    public static MessageFlowEntityError[] getMuleConfigurationErrorsFromSource(String xmlContent, MuleConfiguration config, IProject project, IFile xmlConfigFile) throws CoreException {
        ArrayList<MessageFlowEntityError> rs = new ArrayList<MessageFlowEntityError>();
        for (IMuleValidatorFactory muleValidatorFactory : TransformerUtils.getMuleValidatorFactories()) {
            IMuleValidator validator = muleValidatorFactory.getValidator(xmlConfigFile, config);
            org.eclipse.jface.text.Document document = new org.eclipse.jface.text.Document(xmlContent);
            try {
                try {
                    validator.connect((IDocument)document);
                    MuleValidationResult result = validator.validate(xmlConfigFile, config);
                    rs.addAll(result.getMuleConfigurationErrors());
                }
                catch (IOException e) {
                    MuleCorePlugin.logError("There was a problem validating file " + String.valueOf(xmlConfigFile.getLocation()), e);
                    validator.disconnect((IDocument)document);
                    continue;
                }
            }
            catch (Throwable throwable) {
                validator.disconnect((IDocument)document);
                throw throwable;
            }
            validator.disconnect((IDocument)document);
        }
        return rs.toArray(new MessageFlowEntityError[rs.size()]);
    }

    public static String getStringContent(Document document) throws CoreException {
        return new String(TransformerUtils.getByteArray(document), StandardCharsets.UTF_8);
    }

    public static byte[] getByteArray(Document document) throws CoreException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            format.setIndentSize(4);
            XMLWriter writer = new XMLWriter(out, format){

                protected void writeAttribute(Attribute attribute) throws IOException {
                    if (!attribute.getQualifiedName().startsWith(";")) {
                        super.writeAttribute(attribute);
                    }
                }

                protected void writeAttribute(Attributes attributes, int index) throws IOException {
                    if (!attributes.getQName(index).startsWith(";")) {
                        super.writeAttribute(attributes, index);
                    }
                }
            };
            writer.setEscapeText(false);
            writer.write(document);
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            string = string.replace("&amp;#13;", "&#13;");
            string = string.replace("&amp;#10;", "&#10;");
            return string.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, e.getMessage(), e));
        }
    }

    public static String getFormattedString(Element element, int indentation) throws CoreException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            format.setIndentSize(4);
            XMLWriter writer = new XMLWriter(out, format){

                protected void writeNamespace(Namespace namespace) throws IOException {
                }

                protected void writeNamespace(String prefix, String uri) throws IOException {
                }

                protected void writeNamespaces() throws IOException {
                }

                protected void writeNode(Node node) throws IOException {
                    if (node instanceof DefaultCDATA) {
                        DefaultCDATA m = (DefaultCDATA)node;
                        String text = m.getText();
                        text = StringEscapeUtils.unescapeXml((String)text);
                        m.setText(text);
                    }
                    super.writeNode(node);
                }

                protected void writeNodeText(Node node) throws IOException {
                    super.writeNodeText(node);
                }

                public void write(CDATA cdata) throws IOException {
                    super.write(cdata);
                }

                protected void writeEscapeAttributeEntities(String txt) throws IOException {
                    if (txt != null) {
                        this.writer.write(txt);
                    }
                }
            };
            writer.write(element);
            writer.setEscapeText(false);
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            if (indentation != 0) {
                string = new ExtraFormatter().format(string, indentation);
            }
            return string;
        }
        catch (Exception e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, e.getMessage(), e));
        }
    }

    public static ByteArrayInputStream getInputStream(Document document) throws CoreException {
        try {
            return new ByteArrayInputStream(TransformerUtils.getByteArray(document));
        }
        catch (Exception e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, e.getMessage(), e));
        }
    }

    public static class ExtraFormatter {
        String in;
        StringBuilder out;
        int index;

        private boolean matches(String pat) {
            if (this.in.startsWith(pat, this.index)) {
                this.index += pat.length();
                this.out.append(pat);
                return true;
            }
            return false;
        }

        public String format(String unformatted, int indentation) {
            boolean inValue = false;
            Runnable shift = indentation >= 0 ? this.positiveShift(indentation) : this.negativeShift(indentation);
            this.in = unformatted;
            this.out = new StringBuilder();
            this.index = 0;
            boolean skip = false;
            while (this.index < unformatted.length()) {
                if (unformatted.charAt(this.index) == '\"') {
                    boolean bl = inValue = !inValue;
                }
                if (this.matches("\r\n") || this.matches("\n") || this.matches("\r")) {
                    if (skip || inValue) continue;
                    shift.run();
                    continue;
                }
                if (this.matches("<![CDATA[")) {
                    skip = true;
                    continue;
                }
                if (this.matches("]]>")) {
                    skip = false;
                    continue;
                }
                this.out.append(unformatted.charAt(this.index++));
            }
            return this.out.toString();
        }

        private Runnable negativeShift(final int indentation) {
            return new Runnable(){

                @Override
                public void run() {
                    int reps = -indentation;
                    int i = 0;
                    while (i < reps && index < in.length()) {
                        if (in.charAt(index) != ' ') break;
                        ++i;
                        ++index;
                    }
                }
            };
        }

        private Runnable positiveShift(int indentation) {
            return new Runnable(indentation){
                final String indentationStr;
                {
                    this.indentationStr = StringUtils.repeat((String)" ", (int)n);
                }

                @Override
                public void run() {
                    out.append(this.indentationStr);
                }
            };
        }
    }

    private static class Singleton {
        private static final List<IMuleValidatorFactory> validatorFactories = TransformerUtils.doGetMuleValidatorFactories();

        private Singleton() {
        }
    }
}

