/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.generator.errors.messageflow.XMLMuleError;

public class MuleValidationResult {
    public static final MuleValidationResult EMPTY_RESULT = new MuleValidationResult();
    private List<XMLMuleError> xmlErrors;
    private List<MessageFlowEntityError> configurationErrors;

    private MuleValidationResult() {
        this.xmlErrors = new ArrayList<XMLMuleError>();
        this.configurationErrors = new ArrayList<MessageFlowEntityError>();
    }

    private MuleValidationResult(List<IMuleError> errors) {
        this.xmlErrors = new ArrayList<XMLMuleError>(errors.size());
        this.configurationErrors = new ArrayList<MessageFlowEntityError>(errors.size());
        for (IMuleError error : errors) {
            if (error instanceof XMLMuleError) {
                XMLMuleError xmlMuleError = (XMLMuleError)error;
                this.xmlErrors.add(xmlMuleError);
                continue;
            }
            if (!(error instanceof MessageFlowEntityError)) continue;
            MessageFlowEntityError messageFlowEntityError = (MessageFlowEntityError)error;
            this.configurationErrors.add(messageFlowEntityError);
        }
    }

    public static MuleValidationResult withErrors(List<IMuleError> errors) {
        return new MuleValidationResult(errors);
    }

    public static MuleValidationResult withErrors(IMuleError[] errors) {
        return new MuleValidationResult(Arrays.asList(errors));
    }

    public void reportInEditor(IReporter reporter, IValidator validator) throws CoreException {
        for (XMLMuleError muleError : this.xmlErrors) {
            reporter.addMessage(validator, muleError.getIMessage());
        }
    }

    public void reportInProblemsPane() {
        for (IMuleError iMuleError : this.configurationErrors) {
            try {
                iMuleError.createMarker();
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("There was a problem while creating and error marker...", e);
            }
        }
        for (XMLMuleError xMLMuleError : this.xmlErrors) {
            if (!xMLMuleError.isVisibleInProblemsPane()) continue;
            try {
                xMLMuleError.createMarker();
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("There was a problem while creating and error marker...", e);
            }
        }
    }

    public List<MessageFlowEntityError> getMuleConfigurationErrors() {
        return this.configurationErrors;
    }

    public List<XMLMuleError> getXmlErrors() {
        return this.xmlErrors;
    }

    public String toString() {
        return "MuleValidationResult [xmlErrors=" + String.valueOf(this.xmlErrors) + ", configurationErrors=" + String.valueOf(this.configurationErrors) + "]";
    }
}

