/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.IMuleValidator;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.utils.collection.ListView;

public class MuleMarkers {
    public static final String PROJECT_LIBS_MARKER = "org.mule.tooling.core.m2.project_libs_marker";
    public static final String PROJECT_EXTENSIONS_MARKER = "org.mule.tooling.core.m2.extensions_marker";
    public static final String MISSING_PROJECT_MODEL_FILE = "org.mule.tooling.core.missing_project_model_file";
    public static final String INVALID_PROJECT_MODEL_FILE = "org.mule.tooling.core.invalid_project_model_file";
    public static final String MULE_MARKER = "org.mule.tooling.core.muleError";
    public static final String MULE_MESSAGEFLOW_MARKER = "org.mule.tooling.core.messageFlowError";
    public static final String MULE_XML_MARKER = "org.mule.tooling.core.muleXMLError";
    public static final String XML_SYNTAX_MARKER = "org.mule.tooling.core.xmlSyntaxError";
    public static final String MULE_PROJECT_MARKER = "org.mule.tooling.core.muleProjectError";
    private static final IMarker[] EMPTY_MARKET = new IMarker[0];

    public static IMarker[] findMuleConfigurationMarkers(IFile file) throws CoreException {
        return file.exists() ? file.findMarkers(MULE_MESSAGEFLOW_MARKER, true, 0) : EMPTY_MARKET;
    }

    public static IMarker[] findMuleProjectMarkers(IResource resource) throws CoreException {
        return resource.exists() ? resource.findMarkers(MULE_PROJECT_MARKER, true, 0) : EMPTY_MARKET;
    }

    public static IMarker[] findMessageXMLMarkers(IFile file) throws CoreException {
        return file.exists() ? file.findMarkers(MULE_XML_MARKER, true, 0) : EMPTY_MARKET;
    }

    public static IMarker[] findXmlSyntaxMarkers(IFile file) throws CoreException {
        return file.exists() ? file.findMarkers(XML_SYNTAX_MARKER, true, 0) : EMPTY_MARKET;
    }

    public static List<IMarker> getAllMuleMarkers(IFile flowFile, IMuleValidator muleValidator) throws CoreException {
        ArrayList result = Lists.newArrayList();
        IMarker[] markers = flowFile.exists() ? flowFile.findMarkers(MULE_MARKER, true, 0) : EMPTY_MARKET;
        String targetValidatorId = muleValidator.getValidatorId();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String validatorId = marker.getAttribute("org.mule.tooling.validator.id", "");
            if (validatorId.equals(targetValidatorId)) {
                result.add(marker);
            }
            ++n2;
        }
        return result;
    }

    public static void cleanAllMuleMarkers(IFile xmlFile) {
        try {
            xmlFile.deleteMarkers(MULE_MARKER, true, 0);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while cleaning markers", e);
        }
    }

    public static void updateMuleConfigurationMarkers(IMuleError[] newErrors, IFile targetFile) throws CoreException {
        ICoreRunnable action = monitor -> {
            List markers = ListView.of(Arrays.asList(MuleMarkers.findMuleConfigurationMarkers(targetFile)), Arrays.asList(MuleMarkers.findMessageXMLMarkers(targetFile)));
            IMuleError[] iMuleErrorArray2 = newErrors;
            int n = newErrors.length;
            int n2 = 0;
            while (n2 < n) {
                IMuleError error = iMuleErrorArray2[n2];
                try {
                    error.createMarker();
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError("An error occurred while creating error markers", e);
                }
                ++n2;
            }
            for (IMarker marker : markers) {
                if (!marker.exists()) continue;
                marker.delete();
            }
        };
        ISchedulingRule rule = targetFile.getWorkspace().getRuleFactory().markerRule((IResource)targetFile);
        targetFile.getWorkspace().run(action, rule, 1, null);
    }
}

