/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.ICleanerDelegate;
import org.mule.tooling.core.builder.MuleBuilderExtensionProvider;
import org.mule.tooling.core.utils.CoreUtils;

public class MuleBuilderExtensionManager {
    private static MuleBuilderExtensionManager INSTANCE;
    private List<MuleBuilderExtensionProvider> builderExtensions;

    public static MuleBuilderExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MuleBuilderExtensionManager();
        }
        return INSTANCE;
    }

    public void cleanWithExtensions(final IProject project) {
        List<MuleBuilderExtensionProvider> builderExtensions = this.getBuilderExtensions();
        for (final MuleBuilderExtensionProvider builderExtensionProvider : builderExtensions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ICleanerDelegate cleanerDelegate = builderExtensionProvider.getCleanerDelegate();
                    if (cleanerDelegate != null) {
                        cleanerDelegate.clean(project);
                    }
                }

                public void handleException(Throwable exception) {
                    MuleCorePlugin.logError("Error while executing Mule builder cleaner delegate, skipping extension", exception);
                }
            });
        }
    }

    public void fullBuildWithExtensions(final IResource resource) {
        List<MuleBuilderExtensionProvider> builderExtensions = this.getBuilderExtensions();
        for (final MuleBuilderExtensionProvider builderExtensionProvider : builderExtensions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IResourceVisitor resourceVisitor = builderExtensionProvider.getResourceVisitor();
                    if (resourceVisitor != null) {
                        resource.accept(resourceVisitor);
                    }
                }

                public void handleException(Throwable exception) {
                    MuleCorePlugin.logError("Error while executing Mule builder extension full build visitor, skipping extension", exception);
                }
            });
        }
    }

    public void incrementalBuildWithExtensions(final IResourceDelta deltaResource) {
        List<MuleBuilderExtensionProvider> builderExtensions = this.getBuilderExtensions();
        for (final MuleBuilderExtensionProvider builderExtensionProvider : builderExtensions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IResourceDeltaVisitor resourceDeltaVisitor = builderExtensionProvider.getResourceDeltaVisitor();
                    if (resourceDeltaVisitor != null) {
                        deltaResource.accept(resourceDeltaVisitor);
                    }
                }

                public void handleException(Throwable exception) {
                    MuleCorePlugin.logError("Error while executing Mule builder extension incremental build visitor, skipping extension", exception);
                }
            });
        }
    }

    private List<MuleBuilderExtensionProvider> getBuilderExtensions() {
        if (this.builderExtensions == null) {
            this.builderExtensions = CoreUtils.getExtensionPointObjects("org.mule.tooling.core.builder", MuleBuilderExtensionProvider.class);
        }
        return this.builderExtensions;
    }
}

