/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.builder.DependenciesFileValidation;
import org.mule.tooling.core.builder.MuleBuilderExtensionManager;
import org.mule.tooling.core.builder.NormalFileValidation;
import org.mule.tooling.core.builder.ValidationBuildVisitor;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.utils.ObjectHolder;

public class MuleBuilder
extends IncrementalProjectBuilder {
    public static final String STUDIO_3X_BUILDER_ID = "org.mule.tooling.core.muleBuilder";
    private static final NormalFileValidation NORMAL_VALIDATION_STRATEGY = new NormalFileValidation();
    public static final String BUILDER_ID = "org.mule.tooling.core.muleStudioBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            IResource resource = delta.getResource();
            if (resource == null || !resource.exists()) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        try {
            Object muleProject = MuleRuntime.create(this.getProject());
            if (muleProject != null) {
                this.getProject().deleteMarkers("org.mule.tooling.core.muleError", true, 2);
                MuleBuilderExtensionManager.getInstance().cleanWithExtensions(this.getProject());
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.getLog().log(e.getStatus());
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            Object muleProject = MuleRuntime.create(this.getProject());
            if (muleProject != null) {
                this.getProject().accept((IResourceVisitor)new ValidationBuildVisitor(monitor, (IMuleProject)muleProject, NORMAL_VALIDATION_STRATEGY));
                MuleBuilderExtensionManager.getInstance().fullBuildWithExtensions((IResource)this.getProject());
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.getLog().log(e.getStatus());
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor outerMonitor) throws CoreException {
        ObjectHolder shouldValidate = new ObjectHolder((Object)false);
        IResource resource = delta.getResource();
        IProject project = resource.getProject();
        if (MuleRuntime.create(project) != null) {
            IPath projectSettingsPath = project.getFolder(".settings").getFullPath();
            IPath outputLocation = JavaCore.create((IProject)project).getOutputLocation();
            MuleProjectDeltaVisitor visitor = new MuleProjectDeltaVisitor(outputLocation, (ObjectHolder<Boolean>)shouldValidate, projectSettingsPath);
            delta.accept((IResourceDeltaVisitor)visitor);
            if (((Boolean)shouldValidate.get()).booleanValue()) {
                List<IResource> resourcesToValidate = visitor.getResourcesToValidate();
                HashMap<IProject, List<IResource>> resources = new HashMap<IProject, List<IResource>>();
                for (IResource iResource : resourcesToValidate) {
                    IProject muleProject = iResource.getProject();
                    ArrayList<IResource> resourcesInProject = (ArrayList<IResource>)resources.get(muleProject);
                    if (resourcesInProject == null) {
                        ArrayList<IResource> newResources;
                        resourcesInProject = newResources = new ArrayList<IResource>();
                        resources.put(muleProject, newResources);
                    }
                    resourcesInProject.add(iResource);
                }
                this.fullValidateInJob(resources, outerMonitor);
            }
            MuleBuilderExtensionManager.getInstance().incrementalBuildWithExtensions(delta);
        }
    }

    private void fullValidateInJob(Map<IProject, List<IResource>> projectsWithResources, IProgressMonitor outerMonitor) {
        for (final Map.Entry<IProject, List<IResource>> projectWithResources : projectsWithResources.entrySet()) {
            final IProject project = projectWithResources.getKey();
            Job buildJob = new Job("Validating " + project.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Object muleProject = MuleRuntime.create(project);
                        List resources = (List)projectWithResources.getValue();
                        ValidationBuildVisitor visitor = MuleBuilder.this.getValidationBuildVisitor((IMuleProject)muleProject, resources, monitor);
                        project.accept((IResourceVisitor)visitor);
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError("There was a problem running the full build of the project", e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            buildJob.setPriority(40);
            buildJob.setUser(false);
            buildJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            buildJob.schedule();
        }
    }

    protected ValidationBuildVisitor getValidationBuildVisitor(final IMuleProject muleProject, final List<IResource> resources, final IProgressMonitor monitor) {
        return StudioDesignContextRunner.runSilentWithMuleProject(new Callable<ValidationBuildVisitor>(){

            @Override
            public ValidationBuildVisitor call() throws Exception {
                ValidationBuildVisitor visitor;
                IMuleConfigurationsCache configurationsCache = muleProject.getConfigurationsCache();
                boolean isAnyNotAConfigFile = Iterables.any((Iterable)resources, (Predicate)new Predicate<IResource>(){

                    public boolean apply(IResource input) {
                        return !MuleResourceUtils.isConfigFile(input);
                    }
                });
                if (isAnyNotAConfigFile) {
                    visitor = new ValidationBuildVisitor(monitor, muleProject, NORMAL_VALIDATION_STRATEGY);
                } else {
                    HashSet<MuleConfiguration> relatedConfigs = new HashSet<MuleConfiguration>();
                    for (IResource resource : resources) {
                        MuleConfiguration configuration = configurationsCache.getConfiguration((IFile)resource);
                        if (configuration == null) continue;
                        relatedConfigs.addAll(configurationsCache.getRelatedConfigs(configuration));
                        relatedConfigs.add(configuration);
                    }
                    visitor = new ValidationBuildVisitor(monitor, muleProject, new DependenciesFileValidation(configurationsCache, relatedConfigs));
                }
                return visitor;
            }
        }, muleProject, null);
    }

    private final class MuleProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        private final IPath outputLocation;
        private final ObjectHolder<Boolean> shouldValidate;
        private final IPath projectSettingsPath;
        private List<IResource> resourcesToValidate = new ArrayList<IResource>();

        private MuleProjectDeltaVisitor(IPath outputLocation, ObjectHolder<Boolean> shouldValidate, IPath projectSettingsPath) {
            this.outputLocation = outputLocation;
            this.shouldValidate = shouldValidate;
            this.projectSettingsPath = projectSettingsPath;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getAffectedChildren().length > 0) {
                return true;
            }
            IResource resource = delta.getResource();
            IPath resourcePath = resource.getFullPath();
            boolean isMuleSettingsFile = this.projectSettingsPath.isPrefixOf(resourcePath) && resource.getName().startsWith("org.mule");
            boolean isInOutputLocation = this.outputLocation.isPrefixOf(resource.getFullPath());
            boolean validate = !isMuleSettingsFile && !isInOutputLocation;
            this.shouldValidate.set((Object)((Boolean)this.shouldValidate.get() != false || validate ? 1 : 0));
            if (validate) {
                this.resourcesToValidate.add(resource);
            }
            return true;
        }

        public List<IResource> getResourcesToValidate() {
            return this.resourcesToValidate;
        }
    }
}

