/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.builder.ICleanerDelegate;
import org.mule.tooling.core.builder.MuleBuilderExtensionProvider;
import org.mule.tooling.core.builder.ValidateDomainLinks;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.MuleProjectKind;

public class DomainBuilderExtensionProvider
implements MuleBuilderExtensionProvider {
    @Override
    public IResourceVisitor getResourceVisitor() {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (MuleProjectKind.APPLICATION.classifies(resource.getProject())) {
                    DomainBuilderExtensionProvider.this.validateDomainLinks(resource.getProject());
                }
                return false;
            }
        };
    }

    @Override
    public IResourceDeltaVisitor getResourceDeltaVisitor() {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getAffectedChildren().length != 0) {
                    return true;
                }
                IResource resource = delta.getResource();
                IProject project = resource.getProject();
                if (MuleProjectKind.APPLICATION.classifies(project)) {
                    if (resource.getName().equals("pom.xml")) {
                        DomainBuilderExtensionProvider.this.validateDomainLinks(project);
                        return false;
                    }
                    return true;
                }
                if (MuleProjectKind.DOMAIN.classifies(project)) {
                    IMuleDomainProject muleDomain = MuleProjectKind.DOMAIN.adapt(project);
                    for (IMuleApplicationProject childProject : muleDomain.getChildProjects()) {
                        DomainBuilderExtensionProvider.this.validateDomainLinks(childProject.getProject());
                    }
                    return false;
                }
                return false;
            }
        };
    }

    private void validateDomainLinks(IProject project) throws CoreException {
        new ValidateDomainLinks().apply(project);
    }

    @Override
    public ICleanerDelegate getCleanerDelegate() {
        return null;
    }
}

