/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.builder;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.builder.IErrorMarkerRule;

public abstract class BaseErrorMarkerRule
implements IErrorMarkerRule {
    @Override
    public void apply(IProject project) throws CoreException {
        if (project.isAccessible()) {
            boolean condition = this.evaluate(project);
            if (!condition) {
                this.createMarker(project);
            } else {
                this.removeMarker(project);
            }
        }
    }

    public void removeMarker(IProject project) throws CoreException {
        final IMarker marker = this.getMarker(project);
        if (marker != null) {
            if (!ResourcesPlugin.getWorkspace().isTreeLocked()) {
                marker.delete();
            } else {
                WorkspaceJob workspaceJob = new WorkspaceJob("Deleting error marker: \"" + this.getMessage() + "\""){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        marker.delete();
                        return Status.OK_STATUS;
                    }
                };
                workspaceJob.schedule();
            }
        }
    }

    protected void createMarker(final IProject project) throws CoreException {
        if (!ResourcesPlugin.getWorkspace().isTreeLocked()) {
            this.createOrUpdate(project);
        } else {
            WorkspaceJob workspaceJob = new WorkspaceJob("Creating error marker: \"" + this.getMessage() + "\""){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    BaseErrorMarkerRule.this.createOrUpdate(project);
                    return Status.OK_STATUS;
                }
            };
            workspaceJob.schedule();
        }
    }

    private synchronized void createOrUpdate(IProject project) throws CoreException {
        IMarker marker = this.getMarker(project);
        if (project.isAccessible()) {
            if (marker == null) {
                marker = this.getTargetResource(project).createMarker(this.getMarkerType());
                marker.setAttribute("message", (Object)this.getMessage());
                marker.setAttribute("priority", 2);
                marker.setAttribute("severity", 2);
                this.configure(marker);
            } else {
                this.updateMarker(project, marker);
            }
        }
    }

    protected void updateMarker(IProject project, IMarker marker) throws CoreException {
        marker.setAttribute("message", (Object)this.getMessage());
    }

    protected void configure(IMarker marker) throws CoreException {
    }

    @Override
    public IMarker getMarker(IProject project) throws CoreException {
        IMarker[] findMuleProjectMarkers;
        IResource targetResource = this.getTargetResource(project);
        if (targetResource == null) {
            return null;
        }
        IMarker[] iMarkerArray = findMuleProjectMarkers = targetResource.findMarkers(this.getMarkerType(), true, 0);
        int n = findMuleProjectMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (this.matches(iMarker)) {
                return iMarker;
            }
            ++n2;
        }
        return null;
    }

    protected boolean matches(IMarker marker) throws CoreException {
        return this.getMessage().equals(marker.getAttribute("message"));
    }

    protected abstract boolean evaluate(IProject var1) throws CoreException;

    protected IResource getTargetResource(IProject project) {
        return project;
    }

    protected abstract String getMarkerType();

    protected abstract String getMessage();
}

