/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BatchProcessor;

public class SimpleRequestProcessor<R extends BackgroundRequest>
implements BatchProcessor<R> {
    private RequestProcessor<R> requestProcessor;

    public SimpleRequestProcessor(RequestProcessor<R> requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    @Override
    public void processBatch(IProgressMonitor progress, List<R> batch) {
        for (BackgroundRequest request : batch) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            SafeRunner.run(() -> this.requestProcessor.processRequest((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progress, (int)1), request));
        }
    }

    @FunctionalInterface
    public static interface RequestProcessor<R> {
        public void processRequest(IProgressMonitor var1, R var2);
    }
}

