/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.Iterator;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.core.background.AbstractExecutionScheduler;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BatchProcessor;
import org.mule.tooling.core.background.BatchSupplier;
import org.mule.tooling.core.background.ExecutionScheduler;
import org.mule.tooling.core.background.ExecutionSchedulerConfiguration;
import org.mule.tooling.core.background.RequestStore;

public class SimpleExecutionScheduler<R extends BackgroundRequest>
extends AbstractExecutionScheduler<R> {
    private SingleRequestExecutorJob job;
    private boolean eager = true;

    public SimpleExecutionScheduler(String name, RequestStore<R> store, BatchProcessor.BackgroundOperation operation, BatchProcessor<R> processor, int batchSize, int quietPeriod, boolean eager, ExecutionScheduler.JobConfigurer jobConfigurer, long delay) {
        super(name, store, operation, processor, batchSize, quietPeriod, jobConfigurer);
        this.job = new SingleRequestExecutorJob(name);
        this.configureJob(this.job);
        this.delay = delay;
    }

    @Override
    protected Job getDispatcherJob() {
        return this.job;
    }

    @Override
    public void cancel() {
        this.job.cancel();
    }

    @Override
    public void stop() throws InterruptedException {
        this.cancel();
        this.job.join(ExecutionSchedulerConfiguration.STOP_TIME_OUT_IN_MILLIS, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean await(long timeout) throws InterruptedException {
        return this.job.join(timeout, null);
    }

    static class CancelableIterable<T>
    implements Iterable<T> {
        private final Iterable<T> base;
        private Supplier<Boolean> canceled;

        CancelableIterable(Iterable<T> base, Supplier<Boolean> canceled) {
            this.base = base;
            this.canceled = canceled;
        }

        @Override
        public Iterator<T> iterator() {
            return new CancelableIterator<T>(this.base.iterator());
        }

        class CancelableIterator<T>
        implements Iterator<T> {
            private final Iterator<T> base;

            CancelableIterator(Iterator<T> base) {
                this.base = base;
            }

            @Override
            public boolean hasNext() {
                return CancelableIterable.this.canceled.get() == false && this.base.hasNext();
            }

            @Override
            public T next() {
                if (CancelableIterable.this.canceled.get().booleanValue()) {
                    throw new OperationCanceledException();
                }
                return this.base.next();
            }
        }
    }

    private class SingleRequestExecutorJob
    extends Job {
        public SingleRequestExecutorJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (SimpleExecutionScheduler.this.postponeIfNeeded(this)) {
                return Status.CANCEL_STATUS;
            }
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName(threadName + " - " + this.getName());
            try {
                BatchSupplier storeDrainer = SimpleExecutionScheduler.this.store.supply(SimpleExecutionScheduler.this.batchSize);
                SimpleExecutionScheduler.this.processRequests(monitor, storeDrainer.cancelable(() -> ((IProgressMonitor)monitor).isCanceled()).cancelable(() -> this.breakOrYield(monitor)));
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                SimpleExecutionScheduler.this.resetName();
                Thread.currentThread().setName(threadName);
            }
        }

        private boolean breakOrYield(IProgressMonitor monitor) {
            if (!SimpleExecutionScheduler.this.eager) {
                SimpleExecutionScheduler.this.doScheduleJob(this);
                return true;
            }
            this.yieldRule(monitor);
            return false;
        }
    }
}

