/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.background.ExecutableRequest;
import org.mule.tooling.core.background.SimpleRequestProcessor;

public class SimpleExecutableRequestProcessor<ER extends ExecutableRequest>
extends SimpleRequestProcessor<ER> {
    public SimpleExecutableRequestProcessor() {
        super(SimpleExecutableRequestProcessor::handleExecutableRequest);
    }

    private static void handleExecutableRequest(IProgressMonitor monitor, ExecutableRequest request) {
        monitor.subTask(request.getDescription());
        try {
            try {
                ExecutableRequest.Action<? extends ExecutableRequest> action = request.getAction();
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                action.perform(monitor, request);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Problem performing action: " + request.getDescription(), e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

