/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.RequestStore;

public class QueueStore<R extends BackgroundRequest>
implements RequestStore<R> {
    private BlockingDeque<R> requests = new LinkedBlockingDeque<R>();

    @Override
    public synchronized void addRequest(R request) {
        this.requests.add(request);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.requests.isEmpty();
    }

    @Override
    public synchronized List<BackgroundRequest.Batch<R>> collectRequests(int limit, int _unusedMaxBatches) {
        if (this.requests.isEmpty()) {
            return Collections.emptyList();
        }
        int toTake = Math.min(limit, this.requests.size());
        ArrayList requestSnapshot = new ArrayList(toTake);
        this.requests.drainTo(requestSnapshot, toTake);
        return Collections.singletonList(BackgroundRequest.Batch.from(requestSnapshot));
    }

    @Override
    public synchronized void clear() {
        this.requests.clear();
    }
}

