/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.mule.tooling.core.background.AbstractExecutionScheduler;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BatchProcessor;
import org.mule.tooling.core.background.BatchSupplier;
import org.mule.tooling.core.background.ExecutionScheduler;
import org.mule.tooling.core.background.ExecutionSchedulerConfiguration;
import org.mule.tooling.core.background.RequestStore;
import org.mule.tooling.core.utils.JobUtils;

class ParallelExecutionScheduler<R extends BackgroundRequest>
extends AbstractExecutionScheduler<R> {
    private DispatcherJob dispatcherJob;
    private JobGroup jobGroup;

    ParallelExecutionScheduler(String name, RequestStore<R> store, BatchProcessor.BackgroundOperation operation, BatchProcessor<R> processor, int batchSize, int quietPeriod, int jobCount, ExecutionScheduler.JobConfigurer jobConfigurer) {
        super(name, store, operation, processor, batchSize, quietPeriod, jobConfigurer);
        this.dispatcherJob = new DispatcherJob(name);
        this.jobGroup = JobUtils.createJobGroup(name, jobCount == 0 ? 1 : jobCount);
    }

    @Override
    protected Job getDispatcherJob() {
        return this.dispatcherJob;
    }

    @Override
    public void cancel() {
        this.dispatcherJob.cancel();
        this.jobGroup.cancel();
    }

    @Override
    public void stop() throws InterruptedException {
        this.cancel();
        this.dispatcherJob.join();
        this.jobGroup.join((long)ExecutionSchedulerConfiguration.STOP_TIME_OUT_IN_MILLIS, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean await(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        if (!this.dispatcherJob.join(timeout, null)) {
            return false;
        }
        long stop = System.currentTimeMillis();
        long left = timeout - (stop - start);
        return left > 0L && this.jobGroup.join(left, null);
    }

    private class DispatcherJob
    extends Job {
        public DispatcherJob(String name) {
            super(name);
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (!ParallelExecutionScheduler.this.postponeIfNeeded(this)) ** GOTO lbl4
            return Status.CANCEL_STATUS;
lbl-1000:
            // 1 sources

            {
                this.createExecutorJob(requestSnapshot).schedule();
lbl4:
                // 2 sources

                ** while (!(requestSnapshot = ParallelExecutionScheduler.this.store.collectRequests((int)ParallelExecutionScheduler.this.batchSize)).isEmpty())
            }
lbl5:
            // 1 sources

            return Status.OK_STATUS;
        }

        private Job createExecutorJob(List<BackgroundRequest.Batch<R>> requestSnapshot) {
            ExecutorJob requestExecutorJob = new ExecutorJob(ParallelExecutionScheduler.this.name, requestSnapshot);
            requestExecutorJob.setJobGroup(ParallelExecutionScheduler.this.jobGroup);
            ParallelExecutionScheduler.this.configureJob(requestExecutorJob);
            return requestExecutorJob;
        }
    }

    private class ExecutorJob
    extends Job {
        private List<BackgroundRequest.Batch<R>> requestSnapshot;

        public ExecutorJob(String name, List<BackgroundRequest.Batch<R>> requestSnapshot) {
            super(name);
            this.requestSnapshot = requestSnapshot;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String threadName = Thread.currentThread().getName();
            try {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.requestSnapshot.size());
                ParallelExecutionScheduler.this.processRequests((IProgressMonitor)subMonitor, BatchSupplier.drain(new ArrayList(this.requestSnapshot)));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                ParallelExecutionScheduler.this.resetName();
                Thread.currentThread().setName(threadName);
            }
        }
    }
}

