/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.RequestStore;

public class KeyedStore<K, R extends BackgroundRequest>
implements RequestStore<R> {
    private Map<K, R> requests = new LinkedHashMap<K, R>();
    private Function<R, K> keyExtractor;

    public KeyedStore(Function<R, K> keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    @Override
    public synchronized void addRequest(R request) {
        K key = this.keyExtractor.apply(request);
        this.requests.remove(key);
        this.requests.put(key, request);
    }

    @Override
    public synchronized List<BackgroundRequest.Batch<R>> collectRequests(int limit, int batches) {
        ArrayList collected = new ArrayList();
        List<Map.Entry> selected = this.requests.entrySet().stream().limit(limit).collect(Collectors.toList());
        selected.forEach(entry -> {
            this.requests.remove(entry.getKey());
            collected.add((BackgroundRequest)entry.getValue());
        });
        return collected.isEmpty() ? Collections.emptyList() : Collections.singletonList(BackgroundRequest.Batch.from(collected));
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.requests.isEmpty();
    }

    @Override
    public void clear() {
        this.requests.clear();
    }
}

