/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableObject;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BatchSupplier;
import org.mule.tooling.core.background.RequestStore;

public class GroupingStore<K, R extends BackgroundRequest>
implements RequestStore<R> {
    private Map<K, List<R>> requests;
    private Function<R, K> groupSelector;
    private boolean oneGroupPerBatch;

    public GroupingStore(boolean oneGroupPerBatch, Function<R, K> groupSelector, Comparator<K> keyComparator) {
        this.groupSelector = groupSelector;
        this.oneGroupPerBatch = oneGroupPerBatch;
        this.requests = Collections.synchronizedMap(keyComparator == null ? new LinkedHashMap() : new TreeMap(keyComparator));
    }

    public GroupingStore(boolean oneGroupPerBatch, Function<R, K> groupSelector) {
        this(oneGroupPerBatch, groupSelector, null);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.requests.isEmpty();
    }

    @Override
    public synchronized void addRequest(R request) {
        K group = this.groupSelector.apply(request);
        this.requests.computeIfAbsent(group, k -> Collections.synchronizedList(new LinkedList())).add(request);
    }

    @Override
    public BatchSupplier<R> supply(final int cutoff) {
        return new BatchSupplier<R>(){

            @Override
            public Optional<BackgroundRequest.Batch<R>> takeNext() {
                MutableObject next = new MutableObject();
                GroupingStore.this.collectRequests(cutoff, arg_0 -> ((MutableObject)next).setValue(arg_0), 1);
                return Optional.ofNullable((BackgroundRequest.Batch)next.getValue());
            }
        };
    }

    @Override
    public List<BackgroundRequest.Batch<R>> collectRequests(int limit, int maxBatches) {
        LinkedList<BackgroundRequest.Batch<R>> requestSnapshot = new LinkedList<BackgroundRequest.Batch<R>>();
        this.collectRequests(limit, requestSnapshot::add, this.oneGroupPerBatch ? 1 : maxBatches);
        return requestSnapshot;
    }

    private synchronized void collectRequests(int maxRequests, Consumer<BackgroundRequest.Batch<R>> consumer, int maxBatches) {
        int total = 0;
        int batches = 0;
        Iterator<Map.Entry<K, List<R>>> iterator = this.requests.entrySet().iterator();
        while (total < maxRequests && batches < maxBatches && iterator.hasNext()) {
            boolean noRequestLeftInGroup;
            List<R> batchRequests;
            int limit = maxRequests - total;
            Map.Entry<K, List<R>> nextEntry = iterator.next();
            List<R> groupRequests = nextEntry.getValue();
            if (limit < groupRequests.size()) {
                batchRequests = new ArrayList<R>(groupRequests.subList(0, limit));
                nextEntry.setValue(groupRequests.subList(limit, groupRequests.size()));
            } else {
                batchRequests = groupRequests;
                iterator.remove();
            }
            boolean bl = noRequestLeftInGroup = batchRequests.size() == nextEntry.getValue().size();
            if (batchRequests.isEmpty()) continue;
            consumer.accept(BackgroundRequest.Batch.from(batchRequests));
            total += batchRequests.size();
            ++batches;
        }
    }

    private List<R> consumeFromGroup(int limit, List<R> groupRequests) {
        return limit < groupRequests.size() ? groupRequests.subList(0, limit) : groupRequests;
    }

    @Override
    public synchronized void clear() {
        this.requests.clear();
    }
}

