/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.tooling.core.background.BackgroundRequest;

public interface BatchSupplier<R extends BackgroundRequest> {
    public Optional<BackgroundRequest.Batch<R>> takeNext();

    default public BatchSupplier<R> cancelable(Supplier<Boolean> canceled) {
        return () -> (Boolean)canceled.get() != false ? Optional.empty() : this.takeNext();
    }

    public static <R extends BackgroundRequest> BatchSupplier<R> drain(final Iterable<BackgroundRequest.Batch<R>> source) {
        return new BatchSupplier<R>(){

            @Override
            public Optional<BackgroundRequest.Batch<R>> takeNext() {
                Iterator sourceIterator = source.iterator();
                if (!sourceIterator.hasNext()) {
                    return Optional.empty();
                }
                BackgroundRequest.Batch next = (BackgroundRequest.Batch)sourceIterator.next();
                sourceIterator.remove();
                return Optional.of(next);
            }
        };
    }

    default public Iterable<BackgroundRequest.Batch<R>> iterable() {
        return new Iterable<BackgroundRequest.Batch<R>>(){

            @Override
            public Iterator<BackgroundRequest.Batch<R>> iterator() {
                return new Iterator<BackgroundRequest.Batch<R>>(){
                    private Optional<BackgroundRequest.Batch<R>> next;

                    @Override
                    public boolean hasNext() {
                        this.takeNextIfNeeded();
                        return this.next.isPresent();
                    }

                    private void takeNextIfNeeded() {
                        if (this.next == null) {
                            this.next = BatchSupplier.this.takeNext();
                        }
                    }

                    @Override
                    public BackgroundRequest.Batch<R> next() {
                        this.takeNextIfNeeded();
                        BackgroundRequest.Batch result = this.next.orElseThrow(NoSuchElementException::new);
                        this.next = null;
                        return result;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    default public Stream<R> requests() {
        return this.batches().flatMap(BackgroundRequest.Batch::stream);
    }

    default public Stream<BackgroundRequest.Batch<R>> batches() {
        return StreamSupport.stream(this.iterable().spliterator(), false);
    }
}

