/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Assert;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BatchProcessor;
import org.mule.tooling.core.background.ExecutionScheduler;
import org.mule.tooling.core.background.ParallelExecutionScheduler;
import org.mule.tooling.core.background.QueueStore;
import org.mule.tooling.core.background.RequestStore;
import org.mule.tooling.core.background.SimpleExecutionScheduler;

public class BackgroundRequestExecutor<R extends BackgroundRequest> {
    private static final int DEFAULT_BATCH_SIZE = 200;
    private RequestStore<R> backlog;
    private AtomicBoolean suspended = new AtomicBoolean(false);
    private ExecutionScheduler<R> executionScheduler;

    public static <R extends BackgroundRequest> Builder<R> builder(String name, BatchProcessor<R> batchProcessor) {
        return new Builder<R>(batchProcessor).name(name);
    }

    private BackgroundRequestExecutor(RequestStore<R> backlog, ExecutionScheduler<R> executionScheduler) {
        this.backlog = backlog;
        this.executionScheduler = executionScheduler;
    }

    public void submit(R request) {
        this.internalSubmit(request);
        if (!this.suspended.get()) {
            this.scheduleJob();
        }
    }

    private void internalSubmit(R request) {
        this.traceRequest(request);
        this.backlog.addRequest(request);
    }

    private void traceRequest(R request) {
    }

    public void submitAll(List<R> requests) {
        requests.forEach(this::internalSubmit);
        if (!this.suspended.get()) {
            this.scheduleJob();
        }
    }

    private void scheduleJob() {
        this.executionScheduler.schedule();
    }

    public void suspend() {
        this.suspended.set(true);
    }

    public void resume() {
        this.suspended.set(false);
        this.scheduleJob();
    }

    public void cancel() {
        this.executionScheduler.cancel();
    }

    public void stop() throws InterruptedException {
        this.suspend();
        this.backlog.clear();
        this.cancel();
        this.executionScheduler.stop();
    }

    public boolean await(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start > timeout || this.backlog.isEmpty() && this.executionScheduler.await(Long.max(1L, timeout - (System.currentTimeMillis() - start))))) {
            Thread.sleep(10L);
        }
        return this.backlog.isEmpty() && this.executionScheduler.await(0L);
    }

    public static class Builder<BR extends BackgroundRequest> {
        private String name;
        private BatchProcessor<BR> batchProcessor;
        private BatchProcessor.BackgroundOperation operation = Consumer::accept;
        private RequestStore<BR> store;
        private ExecutionScheduler<BR> executionScheduler;
        private int jobCount = 1;
        private boolean drainQueue = false;
        private ExecutionScheduler.JobConfigurer jobConfigurer;
        private int quietPeriod;
        private int batchSize = 200;

        private Builder(BatchProcessor<BR> batchProcessor) {
            this.batchProcessor = batchProcessor;
            Objects.requireNonNull(batchProcessor);
        }

        public Builder<BR> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<BR> store(RequestStore<BR> backlog) {
            this.store = backlog;
            return this;
        }

        public Builder<BR> jobConfigurer(ExecutionScheduler.JobConfigurer jobConfigurer) {
            Assert.isLegal((this.executionScheduler == null ? 1 : 0) != 0, (String)"Must be set after execution scheduler");
            this.jobConfigurer = jobConfigurer;
            return this;
        }

        public Builder<BR> batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder<BR> quietPeriod(int quietPeriod) {
            this.quietPeriod = quietPeriod;
            return this;
        }

        public Builder<BR> jobCount(int jobCount) {
            Assert.isLegal((this.executionScheduler == null ? 1 : 0) != 0, (String)"Must be set after execution scheduler");
            this.jobCount = jobCount;
            return this;
        }

        public Builder<BR> drainQueue(boolean drainQueue) {
            Assert.isLegal((this.executionScheduler == null ? 1 : 0) != 0, (String)"Must be set after execution scheduler");
            this.drainQueue = drainQueue;
            return this;
        }

        public Builder<BR> operation(BatchProcessor.BackgroundOperation operation) {
            Objects.requireNonNull(operation);
            this.operation = operation;
            return this;
        }

        public ExecutionScheduler<BR> simpleScheduler(long delay) {
            return new SimpleExecutionScheduler<BR>(this.name, this.store, this.operation, this.batchProcessor, this.batchSize, this.quietPeriod, this.drainQueue, this.jobConfigurer, delay);
        }

        private ExecutionScheduler<BR> parallelScheduler() {
            return new ParallelExecutionScheduler<BR>(this.name, this.store, this.operation, this.batchProcessor, this.batchSize, this.quietPeriod, this.jobCount, this.jobConfigurer);
        }

        public BackgroundRequestExecutor<BR> build(Supplier<ExecutionScheduler<BR>> executionScheduler) {
            if (this.store == null) {
                this.store = new QueueStore<BR>();
            }
            assert (this.batchSize > 0);
            Objects.requireNonNull(this.name, () -> "name");
            Objects.requireNonNull(this.operation, () -> "transaction");
            Objects.requireNonNull(this.store, () -> "store");
            return new BackgroundRequestExecutor<BR>(this.store, executionScheduler.get());
        }

        public BackgroundRequestExecutor<BR> buildParallel(int jobCount) {
            return this.jobCount(jobCount).build(this::parallelScheduler);
        }

        public BackgroundRequestExecutor<BR> buildSimple(boolean drainQueue, long delay) {
            this.drainQueue(drainQueue);
            return this.build(() -> this.simpleScheduler(delay));
        }

        public BackgroundRequestExecutor<BR> build() {
            return this.buildSimple(true, 0L);
        }

        public BackgroundRequestExecutor<BR> build(String name) {
            return this.name(name).buildSimple(true, 0L);
        }
    }
}

