/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.util.List;
import java.util.stream.Stream;

public interface BackgroundRequest {
    public String getDescription();

    public static interface Batch<R extends BackgroundRequest> {
        public List<R> getRequests();

        default public int size() {
            return this.getRequests().size();
        }

        default public Stream<R> stream() {
            return this.getRequests().stream();
        }

        default public boolean isEmpty() {
            return this.getRequests().isEmpty();
        }

        public static <R extends BackgroundRequest> Batch<R> from(List<R> requests) {
            class SimpleBatch
            implements Batch<R> {
                private final List<R> requests;

                public SimpleBatch(List<R> requests) {
                    this.requests = requests;
                }

                @Override
                public List<R> getRequests() {
                    return this.requests;
                }
            }
            return new SimpleBatch(requests);
        }
    }
}

