/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.background;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BatchProcessor;
import org.mule.tooling.core.background.BatchSupplier;
import org.mule.tooling.core.background.ExecutionScheduler;
import org.mule.tooling.core.background.RequestStore;

public abstract class AbstractExecutionScheduler<R extends BackgroundRequest>
implements ExecutionScheduler<R> {
    protected RequestStore<R> store;
    private BatchProcessor.BackgroundOperation operation;
    protected BatchProcessor<R> batchProcessor;
    protected String name;
    protected int batchSize;
    private ExecutionScheduler.JobConfigurer jobConfigurer;
    protected long quietPeriod;
    protected long delay;
    private Instant lastSubmission = Instant.now();

    public AbstractExecutionScheduler(String name, RequestStore<R> store, BatchProcessor.BackgroundOperation operation, BatchProcessor<R> processor, int batchSize, int quietPeriod, ExecutionScheduler.JobConfigurer jobConfigurer) {
        this.name = name;
        this.store = store;
        this.operation = operation;
        this.batchProcessor = processor;
        this.batchSize = batchSize;
        this.quietPeriod = quietPeriod;
        this.jobConfigurer = jobConfigurer == null ? it -> {} : jobConfigurer;
    }

    protected AbstractExecutionScheduler() {
    }

    protected abstract Job getDispatcherJob();

    @Override
    public void schedule() {
        this.doScheduleJob(this.getDispatcherJob());
    }

    public long computeTimeLeft() {
        long timeElapsed = this.lastSubmission.until(Instant.now(), ChronoUnit.MILLIS);
        long requiredWait = Math.max(this.delay, this.quietPeriod);
        return Math.max(0L, requiredWait - timeElapsed);
    }

    protected void doScheduleJob(Job schedulerJob) {
        long max = this.computeDelayForNextScheduling();
        this.scheduleJobUsingDelay(schedulerJob, max);
    }

    protected void scheduleJobUsingDelay(Job schedulerJob, long delay) {
        schedulerJob.schedule(delay);
    }

    public long computeDelayForNextScheduling() {
        this.lastSubmission = Instant.now();
        long max = Math.max(this.delay, this.quietPeriod);
        return max;
    }

    protected boolean postponeIfNeeded(Job dispatcherJob) {
        long timeLeft = this.computeTimeLeft();
        if (timeLeft > 0L) {
            this.scheduleJobUsingDelay(dispatcherJob, timeLeft);
            return true;
        }
        return false;
    }

    protected void resetName() {
        this.getCurrentJob().setName(this.name);
    }

    protected Job getCurrentJob() {
        return Job.getJobManager().currentJob();
    }

    protected void processRequests(IProgressMonitor monitor, BatchSupplier<R> batches) {
        this.getCurrentJob().setName(this.name);
        monitor.setTaskName(this.name);
        this.operation.run(operationMonitor -> {
            Optional batch = batches.takeNext();
            while (batch.isPresent()) {
                BackgroundRequest.Batch tempBatch = batch.get();
                this.batchProcessor.processBatch(monitor, tempBatch.getRequests());
                batch = batches.takeNext();
            }
        }, monitor);
    }

    protected void configureJob(Job toConfigure) {
        this.jobConfigurer.accept(toConfigure);
    }
}

