/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.auth;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.auth.PlatformRegion;

public class RegionUrlResolver {
    private static RegionUrlResolver instance;
    private Map<String, PlatformRegion> regions = Maps.newHashMap();
    private IEclipsePreferences prefStore;

    private RegionUrlResolver() {
        this(LoginManager.getPreferences());
    }

    public RegionUrlResolver(IEclipsePreferences preferences) {
        this.prefStore = preferences;
        this.regions.put(PlatformRegion.EU.getName(), PlatformRegion.EU);
        this.regions.put(PlatformRegion.US.getName(), PlatformRegion.US);
        this.regions.put(PlatformRegion.GOV.getName(), PlatformRegion.GOV);
    }

    public static RegionUrlResolver getInstance() {
        if (instance == null) {
            instance = new RegionUrlResolver();
        }
        return instance;
    }

    public PlatformRegion getPlatformRegion() {
        String selectedRegion = this.prefStore.get("org.mule.tooling.core.region", PlatformRegion.US.getName());
        if ("Other".equals(selectedRegion)) {
            String masterOrg = this.prefStore.get("org.mule.tooling.core.custom.master.org", "");
            selectedRegion = this.prefStore.get("org.mule.tooling.core.custom.region", "");
            return new PlatformRegion("Other", selectedRegion, masterOrg);
        }
        return this.regions.get(selectedRegion);
    }
}

