/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.auth;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.regex.Matcher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.CloudServiceUrlBuilder;
import org.mule.tooling.core.auth.IServiceUrlBuilder;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.auth.PceServiceUrlBuilder;
import org.mule.tooling.core.auth.PlatformUrl;
import org.mule.tooling.core.auth.RegionUrlResolver;
import org.mule.tooling.exchange.preferences.ExchangePreferences;

public class PlatformUrls {
    private static final String PROJECT = "project";
    private static final String STUDIO_CLIENT_SECRET = "studio123";
    private static final String STUDIO_CLIENT_ID = "studio";
    private static final String ANYPOINT_ENV = "anypoint.env";
    private static final String ANYPOINT_BASEURL = "anypoint.baseurl";
    public static final String BASE_PLATFORM_PROTOCOL = "https";
    public static final String BASE_PLATFORM_HOST = "anypoint.mulesoft.com";
    public static final String BASE_PLATFORM_URL = "https://anypoint.mulesoft.com/";
    public static final String HYPERFORCE_PLATFORM_HOST = "platform.mulesoft.com";
    public static final String HYPERFORCE_PLATFORM_URL = "https://platform.mulesoft.com/";
    private static final String CLOUDHUB_DEBUGGING = "cloudhub.debugging";
    private static final String CLOUDHUB_STUDIO = "cloudhub/#/studio";
    public static final String MOCKING_SERVICE_LINKS_PATH = "mocking/api/v1/links/";
    public static final String MOCKING_SERVICE_PATH = "mocking/api/v1/sources/vcs/projects/";
    public static final String EXCHANGE_PATH = "exchange/";
    private static final String STUDIO_CS_REDIRECT = "https://studio-redirect/";
    public static final String DEFAULT_LOGIN_URL = "DEFAULT_LOGIN_URL";
    public static final String ORG_MULE_TOOLING_ONPREM_URL = "org.mule.tooling.onprem.url";
    public static final String ORG_MULE_TOOLING_ONPREM_ENABLED = "org.mule.tooling.onprem.enabled";
    public static final String ORG_MULE_TOOLING_HYPERFORCE_ENABLED = "org.mule.tooling.hyperforce.enabled";
    public static final String ORG_MULE_TOOLING_HYPERFORCE_URL = "org.mule.tooling.hyperforce.url";
    public static final String COMBO_REGION_ID = "org.mule.tooling.core.region";
    public static final String CUSTOM_REGION_ID = "org.mule.tooling.core.custom.region";
    public static final String CUSTOM_MASTER_ORG_REGION_ID = "org.mule.tooling.core.custom.master.org";
    public static final String OTHER = "Other";
    public static final String EXCHANGE_OVERRIDE_URL = "url.override";

    private static Optional<String> getEnvironmentProperty() {
        return Optional.ofNullable(System.getProperty(ANYPOINT_ENV));
    }

    public static Optional<URL> getBaseUrl() {
        String baseUrlProperty = System.getProperty(ANYPOINT_BASEURL);
        URL baseUrl = null;
        try {
            boolean hyperforceEnabled;
            boolean onpremEnabled;
            if (baseUrlProperty != null) {
                baseUrl = new URL(baseUrlProperty);
            }
            if (onpremEnabled = LoginManager.getPreferences().getBoolean(ORG_MULE_TOOLING_ONPREM_ENABLED, false)) {
                baseUrl = new URL(LoginManager.getPreferences().get(ORG_MULE_TOOLING_ONPREM_URL, BASE_PLATFORM_URL));
            }
            if (hyperforceEnabled = LoginManager.getPreferences().getBoolean(ORG_MULE_TOOLING_HYPERFORCE_ENABLED, false)) {
                baseUrl = new URL(LoginManager.getPreferences().get(ORG_MULE_TOOLING_HYPERFORCE_URL, HYPERFORCE_PLATFORM_URL));
            }
            return Optional.ofNullable(baseUrl);
        }
        catch (MalformedURLException wrongUrlException) {
            MuleCorePlugin.logError("The base URL you specified is not a correct url, using normal platform URL instead", wrongUrlException);
            return Optional.empty();
        }
    }

    public static String getActivePlatformUrl() {
        return PlatformUrls.getActivePlatformBuilder().build().getUrl();
    }

    public static String getApiDesignerProjectUrl(String projectId) {
        return PlatformUrl.designCenterBuilder(PlatformUrls.getServiceUrlBuilder()).append(PROJECT).append(projectId).build().getUrl();
    }

    public static String getExchangeAssetUrl(String groupId, String artifactId, Optional<String> version) {
        PlatformUrl.PlatformUrlBuilder exchangeAssetBuilder = PlatformUrl.exchangeAssetBuilder(PlatformUrls.getServiceUrlBuilder()).append(groupId).append(artifactId);
        version.ifPresent(v -> {
            PlatformUrl.PlatformUrlBuilder platformUrlBuilder2 = exchangeAssetBuilder.append((String)v);
        });
        exchangeAssetBuilder.append("/");
        return exchangeAssetBuilder.build().getUrl();
    }

    public static PlatformUrl.PlatformUrlBuilder getActivePlatformBuilder() {
        PlatformUrl.PlatformUrlBuilder platformUrlBuilder = PlatformUrl.builder();
        return PlatformUrls.createBaseUrlBuilder(platformUrlBuilder);
    }

    public static String getActiveExchangeUrl() {
        String defaultUrl = PlatformUrls.getActivePlatformBuilder().append(EXCHANGE_PATH).build().getUrl();
        boolean isExchangePreferenceUrlMandatory = ExchangePreferences.getExchangePreferences().getBoolean(EXCHANGE_OVERRIDE_URL, false);
        if (isExchangePreferenceUrlMandatory) {
            return ExchangePreferences.getExchangePreferences().get("url", defaultUrl);
        }
        return defaultUrl;
    }

    public static String getMavenFacadeUrl() {
        return PlatformUrls.getBaseMavenFacadeBuilder().build().getUrl();
    }

    public static String getOldMavenFacadeUrl() {
        return PlatformUrls.getOldBaseMavenFacadeBuilder().build().getUrl();
    }

    public static String getApiDesignerUrl() {
        return PlatformUrls.getApiDesignerBuilder().build().getUrl();
    }

    private static PlatformUrl.PlatformUrlBuilder getApiDesignerBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.apiDesignerBuilder(serviceUrlBuilder);
    }

    private static PlatformUrl.PlatformUrlBuilder getBaseMavenFacadeBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.mavenServiceBuilder(serviceUrlBuilder);
    }

    private static PlatformUrl.PlatformUrlBuilder getOldBaseMavenFacadeBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.oldMavenServiceBuilder(serviceUrlBuilder);
    }

    private static IServiceUrlBuilder getServiceUrlBuilder() {
        boolean onpremEnabled = LoginManager.getPreferences().getBoolean(ORG_MULE_TOOLING_ONPREM_ENABLED, false);
        if (onpremEnabled) {
            return new PceServiceUrlBuilder(PlatformUrls.getActivePlatformBuilder());
        }
        return new CloudServiceUrlBuilder(PlatformUrls.getActivePlatformBuilder());
    }

    public static String getOrganizationBasedMavenFacadeUrl(String orgId) {
        return PlatformUrls.getBaseMavenFacadeBuilder().withOrganizationId(orgId).build().getUrl();
    }

    public static String getActiveGraphServiceUrl() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        PlatformUrl.PlatformUrlBuilder platformUrlBuilder = PlatformUrl.graphServiceBuilder(serviceUrlBuilder);
        return platformUrlBuilder.build().getUrl();
    }

    public static String getActiveExchangeXAPIUrl() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        PlatformUrl.PlatformUrlBuilder platformUrlBuilder = PlatformUrl.exchangeXAPIBuilder(serviceUrlBuilder);
        return platformUrlBuilder.build().getUrl();
    }

    public static String getActiveCloudhubUrl() {
        String cloudhubDebugging = PlatformUrls.getCloudhubDebuggingUrl();
        return cloudhubDebugging == null ? PlatformUrls.getActivePlatformBuilder().append(CLOUDHUB_STUDIO).build().getUrl() : cloudhubDebugging;
    }

    private static PlatformUrl.PlatformUrlBuilder createBaseUrlBuilder(PlatformUrl.PlatformUrlBuilder platformUrlBuilder) {
        PlatformUrls.getBaseUrl().ifPresent(platformUrlBuilder::withBaseUrl);
        boolean onpremEnabled = LoginManager.getPreferences().getBoolean(ORG_MULE_TOOLING_ONPREM_ENABLED, false);
        boolean hyperforceEnabled = LoginManager.getPreferences().getBoolean(ORG_MULE_TOOLING_HYPERFORCE_ENABLED, false);
        if (!onpremEnabled && !hyperforceEnabled) {
            PlatformUrls.getEnvironmentProperty().ifPresent(platformUrlBuilder::withEnvironment);
            platformUrlBuilder.withRegion(RegionUrlResolver.getInstance().getPlatformRegion());
        }
        return platformUrlBuilder;
    }

    public static String getCloudhubDebuggingUrl() {
        return System.getProperty(CLOUDHUB_DEBUGGING);
    }

    public static String getCsRedirectPattern() {
        return Matcher.quoteReplacement(PlatformUrls.getRedirectCsUrl());
    }

    public static String getRedirectCsUrl() {
        return STUDIO_CS_REDIRECT;
    }

    public static String getStudioClientId() {
        return STUDIO_CLIENT_ID;
    }

    public static String getStudioClientSecret() {
        return STUDIO_CLIENT_SECRET;
    }

    public static String getDesignCenterGitEndpoint() {
        return PlatformUrls.gitEndpointBuilder().build().getUrl();
    }

    public static String getActiveGatewayAnalyticsUrl() {
        return PlatformUrls.getActivePlatformBuilder().withPrefix("analytics-ingest").build().getUrl();
    }

    public static String getActiveGatewayPlatformUrl() {
        return PlatformUrls.getActivePlatformBuilder().build().getUrl();
    }

    public static PlatformUrl.PlatformUrlBuilder mavenServiceBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.mavenServiceBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder oldMavenServiceBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.oldMavenServiceBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder graphServiceBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.graphServiceBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder exchangeXAPIBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.exchangeXAPIBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder gitEndpointBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.gitEndpointBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder acbCentralUrlBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.acbCentralUrlBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder asyncKitUrlBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.asyncKitUrlBuilder(serviceUrlBuilder);
    }

    public static PlatformUrl.PlatformUrlBuilder anypointProfileUrlBuilder() {
        IServiceUrlBuilder serviceUrlBuilder = PlatformUrls.getServiceUrlBuilder();
        return PlatformUrl.anypointProfileUrlBuilder(serviceUrlBuilder);
    }

    public static String getMockingServiceUrl() {
        return PlatformUrls.getServiceUrlBuilder().cloudhubUrlBuilder().build().getUrl();
    }
}

