/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.auth;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.auth.IServiceUrlBuilder;
import org.mule.tooling.core.auth.PlatformRegion;

public class PlatformUrl {
    private String suffix;
    private String prefix;
    private PlatformRegion region;
    private String baseUrl;
    private int port;
    private String protocol;
    private String organizationId;
    private String environment;
    private String apiVersion;
    private String ending;
    private static final String STG_ENV = "stg";
    private static final String QA_ENV = "qa";
    private static final String DEV_ENV = "dev";
    public static final String SLASH = "/";
    private static final String API = "api";
    private static final String DOT = ".";
    private static final String URL_PROTOCOL_SEPARATOR = "://";
    private static final String PROD_ENV = "prod";
    private static final Set<String> X_ENVIRONMENTS = Sets.newHashSet((Object[])new String[]{"dev", "qa", "stg"});

    private PlatformUrl(PlatformUrlBuilder builder) {
        this.suffix = builder.suffix;
        this.prefix = builder.prefix;
        this.region = builder.region;
        this.baseUrl = builder.baseUrl;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.organizationId = builder.organizationId;
        this.environment = builder.environment;
        this.apiVersion = builder.apiVersion;
        this.ending = builder.ending;
    }

    private static String getEnvironment(String environment) {
        return X_ENVIRONMENTS.contains(environment) ? environment + "x" : environment;
    }

    public String getUrl() {
        String transformedEnvironment;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.protocol).append(URL_PROTOCOL_SEPARATOR);
        if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
            stringBuilder.append(this.prefix).append(DOT);
        }
        if (!PROD_ENV.equals(transformedEnvironment = PlatformUrl.getEnvironment(this.environment)) && StringUtils.isNotEmpty((CharSequence)transformedEnvironment)) {
            stringBuilder.append(transformedEnvironment).append(DOT);
        }
        if (this.region != null && StringUtils.isNotEmpty((CharSequence)this.region.getPrefix())) {
            stringBuilder.append(this.region.getPrefix()).append(DOT);
        }
        stringBuilder.append(this.baseUrl);
        if (this.port != 80 && this.port != 443 && this.port != -1) {
            stringBuilder.append(":").append(this.port);
        }
        stringBuilder.append(SLASH);
        if (StringUtils.isNotEmpty((CharSequence)this.suffix)) {
            stringBuilder.append(this.suffix).append(SLASH);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.apiVersion)) {
            stringBuilder.append("api/" + this.apiVersion + SLASH);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.organizationId)) {
            stringBuilder.append("organizations/" + this.organizationId + SLASH);
        }
        stringBuilder.append(this.ending);
        return stringBuilder.toString();
    }

    public static PlatformUrlBuilder builder() {
        return new PlatformUrlBuilder();
    }

    public static PlatformUrlBuilder exchangeAssetBuilder(IServiceUrlBuilder builder) {
        return builder.exchangeAssetBuilder();
    }

    public static PlatformUrlBuilder mavenServiceBuilder(IServiceUrlBuilder builder) {
        return builder.mavenServiceBuilder();
    }

    public static PlatformUrlBuilder oldMavenServiceBuilder(IServiceUrlBuilder builder) {
        return builder.oldMavenServiceBuilder();
    }

    public static PlatformUrlBuilder graphServiceBuilder(IServiceUrlBuilder builder) {
        return builder.graphServiceBuilder();
    }

    public static PlatformUrlBuilder exchangeXAPIBuilder(IServiceUrlBuilder builder) {
        return builder.exchangeXAPIBuilder();
    }

    public static PlatformUrlBuilder designCenterBuilder(IServiceUrlBuilder builder) {
        return builder.designCenterBuilder();
    }

    public static PlatformUrlBuilder apiDesignerBuilder(IServiceUrlBuilder builder) {
        return builder.apiDesignerBuilder();
    }

    public static PlatformUrlBuilder gitEndpointBuilder(IServiceUrlBuilder builder) {
        return builder.gitEndpointBuilder();
    }

    public static PlatformUrlBuilder acbCentralUrlBuilder(IServiceUrlBuilder builder) {
        return builder.acbCentralUrlBuilder();
    }

    public static PlatformUrlBuilder asyncKitUrlBuilder(IServiceUrlBuilder builder) {
        return builder.asyncKitUrlBuilder();
    }

    public static PlatformUrlBuilder anypointProfileUrlBuilder(IServiceUrlBuilder builder) {
        return builder.anypointProfileUrlBuilder();
    }

    public static final class PlatformUrlBuilder {
        private String ending = "";
        private String suffix = "";
        private String prefix = "";
        private PlatformRegion region;
        private String baseUrl = "anypoint.mulesoft.com";
        private int port = -1;
        private String protocol = "https";
        private String organizationId = "";
        private String environment = "";
        private String apiVersion = "";

        private PlatformUrlBuilder() {
        }

        public PlatformUrlBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public PlatformUrlBuilder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public PlatformUrlBuilder withRegion(PlatformRegion region) {
            this.region = region;
            return this;
        }

        public PlatformUrlBuilder withBaseUrl(URL baseUrl) {
            this.baseUrl = baseUrl.getHost();
            this.port = baseUrl.getPort();
            this.protocol = baseUrl.getProtocol();
            return this;
        }

        public PlatformUrlBuilder withOrganizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public PlatformUrlBuilder withEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public PlatformUrlBuilder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public PlatformUrlBuilder append(String ending) {
            if (!(this.ending.isEmpty() || this.ending.endsWith(PlatformUrl.SLASH) || ((String)ending).startsWith(PlatformUrl.SLASH))) {
                ending = PlatformUrl.SLASH + (String)ending;
            } else if (!this.ending.isEmpty() && this.ending.endsWith(PlatformUrl.SLASH) && ((String)ending).startsWith(PlatformUrl.SLASH)) {
                ending = ((String)ending).substring(1);
            }
            this.ending = String.valueOf(this.ending) + (String)ending;
            return this;
        }

        public PlatformUrl build() {
            return new PlatformUrl(this);
        }
    }
}

