/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.auth;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.Authentication;
import org.mule.tooling.core.auth.Environment;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.auth.UnauthorizedException;
import org.mule.tooling.core.auth.User;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.utils.CoreUtils;

public class PlatformAuthenticator {
    private static final int readTimeout = 10000;
    private static final int connectTimeout = 10000;
    private String anypointLoginUrl = "";
    private static final String AUTH_RESOURCE = "/oauth2/token";
    private static final String ANYPOINT_ME = "/api/profile";
    private static final String ANYPOINT_ACCESS_TOKENS = "/api/access_tokens/";
    private static final int HTTP_STATUS_SUCCESS = 200;
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    private static final boolean TESTING_CONTEXT = Boolean.valueOf(System.getProperty("studio.testingMode", "false"));
    private Client restClient;
    private Gson gson;
    private int tokenExpiration;

    public PlatformAuthenticator(ConnectionManager connectionManager) {
        this(connectionManager, -1);
    }

    public PlatformAuthenticator(ConnectionManager connectionManager, int tokenExp) {
        this.tokenExpiration = tokenExp;
        this.gson = new Gson();
        this.initUrl(PlatformUrls.getActivePlatformUrl());
        this.restClient = connectionManager.createJerseyClientForUri(URI.create(this.anypointLoginUrl));
        this.restClient.property("jersey.config.client.readTimeout", (Object)10000);
        this.restClient.property("jersey.config.client.connectTimeout", (Object)10000);
    }

    private void initUrl(String overrideUrl) {
        this.anypointLoginUrl = overrideUrl != null ? overrideUrl + "accounts/" : LoginManager.getPreferences().get("DEFAULT_LOGIN_URL", "");
    }

    public AuthUser exchangeCodeForAuthorizationCode(String code) {
        return this.exchangeCodeForAuthorizationCode(code, PlatformUrls.getStudioClientId(), PlatformUrls.getStudioClientSecret(), PlatformUrls.getRedirectCsUrl());
    }

    protected AuthUser exchangeCodeForAuthorizationCode(String code, String clientId, String clientSecret, String redirectUri) {
        String path = "oauth2/token";
        Form formData = new Form();
        formData.param("grant_type", "authorization_code");
        formData.param("redirect_uri", redirectUri);
        formData.param("client_id", clientId);
        formData.param("client_secret", clientSecret);
        formData.param("code", code);
        Response clientResponse = this.restClient.target(this.anypointLoginUrl).path(path).request().post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (Response.Status.OK.equals((Object)clientResponse.getStatusInfo().toEnum())) {
            Authentication exchangeCodeResponse = (Authentication)this.gson.fromJson((String)clientResponse.readEntity(String.class), Authentication.class);
            User currentUser = this.getCurrentUser(exchangeCodeResponse);
            exchangeCodeResponse = this.longAuthToken(exchangeCodeResponse);
            return this.authUserFromAuthentication(exchangeCodeResponse, currentUser);
        }
        throw new UnauthorizedException("Could not retrieve persistent token", (String)clientResponse.readEntity(String.class));
    }

    private Authentication longAuthToken(Authentication auth) {
        Form data2 = this.createLongTermToken(auth);
        Response response = this.restClient.target(this.anypointLoginUrl).path(AUTH_RESOURCE).request().post(Entity.form((Form)data2));
        if (response.getStatus() != 200) {
            throw new UnauthorizedException("Could not retrieve persistent token", (String)response.readEntity(String.class));
        }
        Authentication resultAuth = (Authentication)this.gson.fromJson((String)response.readEntity(String.class), Authentication.class);
        return resultAuth;
    }

    private Form createLongTermToken(Authentication auth) {
        Form data2 = new Form();
        data2.param("grant_type", "urn:ietf:params:oauth:grant-type:persistent_token");
        data2.param("token", auth.getAccessToken());
        data2.param("client_id", PlatformUrls.getStudioClientId());
        data2.param("client_secret", PlatformUrls.getStudioClientSecret());
        data2.param("maxAge", Long.toString(TimeUnit.SECONDS.convert(this.tokenExpiration, TimeUnit.DAYS)));
        return data2;
    }

    protected AuthUser authUserFromAuthentication(Authentication auth, User user) {
        AuthUser authUser = new AuthUser();
        authUser.setToken(auth.getAccessToken());
        authUser.setUserId(user.getUsername());
        authUser.setEmail(user.getEmail());
        authUser.setId(user.getId());
        authUser.setBaseUrl(PlatformUrls.getActivePlatformUrl());
        authUser.setOrganization(user.getOrganization());
        return authUser;
    }

    public List<Environment> getEnvironments() {
        List<Environment> environmentList = new ArrayList<Environment>();
        AuthUser activeAuthUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        if (activeAuthUser == null || activeAuthUser.getToken().length() == 0) {
            return environmentList;
        }
        Response response = this.restClient.target(this.anypointLoginUrl).path(ANYPOINT_ME).request().header("Authorization", (Object)("Bearer " + activeAuthUser.getToken())).get();
        Type listType = new TypeToken<List<Environment>>(){}.getType();
        if (response.getStatus() == 200) {
            environmentList = this.parseResponseToEnvironments(response, listType);
        }
        return environmentList;
    }

    public List<Organization> getOrganizations(AuthUser activeAuthUser) {
        List<Organization> organizationList = new ArrayList<Organization>();
        if (activeAuthUser == null || activeAuthUser.getToken().length() == 0) {
            return organizationList;
        }
        Response response = this.restClient.target(this.anypointLoginUrl).path("api/me").request().header("Authorization", (Object)("Bearer " + activeAuthUser.getToken())).get();
        Type listType = new TypeToken<List<Organization>>(){}.getType();
        if (response.getStatus() == 200) {
            organizationList = this.parseResponseToOrganizations(response, listType);
        }
        return organizationList;
    }

    private List<Organization> parseResponseToOrganizations(Response response, Type listType) {
        String jsonToParse = (String)response.readEntity(String.class);
        JsonElement jsonObject = (JsonElement)this.gson.fromJson(jsonToParse, JsonElement.class);
        return (List)this.gson.fromJson((JsonElement)jsonObject.getAsJsonObject().getAsJsonObject("user").getAsJsonArray("memberOfOrganizations"), listType);
    }

    private List<Environment> parseResponseToEnvironments(Response response, Type listType) {
        String jsonToParse = (String)response.readEntity(String.class);
        JsonElement jsonObject = (JsonElement)this.gson.fromJson(jsonToParse, JsonElement.class);
        return (List)this.gson.fromJson((JsonElement)jsonObject.getAsJsonObject().getAsJsonObject("organization").getAsJsonArray("environments"), listType);
    }

    protected User getCurrentUser(Authentication exchangeCodeResponse) {
        Response clientResponse = this.restClient.target(this.anypointLoginUrl).path(ANYPOINT_ME).request().header("Authorization", (Object)("Bearer " + exchangeCodeResponse.getAccessToken())).header("Content-type", (Object)MediaType.APPLICATION_JSON_TYPE).get();
        if (Response.Status.OK.equals((Object)clientResponse.getStatusInfo().toEnum())) {
            User userResponse = (User)this.gson.fromJson((String)clientResponse.readEntity(String.class), User.class);
            return userResponse;
        }
        throw new UnauthorizedException("Could not retrieve persistent token", (String)clientResponse.readEntity(String.class));
    }

    public void invalidate(List<AuthUser> authUsers) {
        for (AuthUser authUser : authUsers) {
            Response clientResponse = this.restClient.target(this.anypointLoginUrl).path(ANYPOINT_ACCESS_TOKENS + authUser.getToken()).request().delete();
            Response.Status responseStatus = clientResponse.getStatusInfo().toEnum();
            if (Response.Status.OK.equals((Object)responseStatus)) continue;
            String response = responseStatus.getStatusCode() + " " + responseStatus.getReasonPhrase();
            MuleCorePlugin.logWarning("Couldn't invalidate token for user: " + authUser.getUserId() + ". Response: " + response);
        }
    }

    public boolean isValidToken(AuthUser user) {
        if (user == null || user.getToken().length() == 0) {
            return false;
        }
        if (!TESTING_CONTEXT) {
            Response response = this.restClient.target(this.anypointLoginUrl).path(ANYPOINT_ME).request().header("Authorization", (Object)("Bearer " + user.getToken())).get();
            return response.getStatus() == 200;
        }
        int retry = 0;
        while (retry < 3) {
            Response response = this.restClient.target(this.anypointLoginUrl).path(ANYPOINT_ME).request().header("Authorization", (Object)("Bearer " + user.getToken())).get();
            int status = response.getStatus();
            switch (status) {
                case 200: {
                    return true;
                }
                case 429: {
                    this.waitForAPINewRateWindow(Long.valueOf(response.getHeaderString("X-RateLimit-Reset")), retry);
                    ++retry;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private void waitForAPINewRateWindow(long epochTimeUTC, int retry) {
        Instant instant = Instant.now();
        long timeStampSeconds = instant.getEpochSecond();
        long diff = timeStampSeconds - epochTimeUTC;
        long diffMilis = diff * 1000L;
        long result = diffMilis > 0L ? diffMilis : 0L;
        try {
            System.out.println("Thread will sleep " + result + " milliseconds because the API rate limit was reached. This is retry: " + retry);
            Thread.sleep(result);
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logError("Api call waiting due to X-RateLimit has been interrupted.", e);
            Thread.currentThread().interrupt();
        }
    }
}

