/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.print.attribute.standard.Severity;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthResult;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.CurrentUserChangedEvent;
import org.mule.tooling.core.auth.DeleteUsersChangeEvent;
import org.mule.tooling.core.auth.IAuthResult;
import org.mule.tooling.core.auth.PlatformAuthenticator;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.osgi.service.prefs.BackingStoreException;

public class LoginManager {
    private static final String GENERIC_MESSAGE = "Error while checking if your session is valid";
    private static final String URL_MESSAGE = "The url you are trying to hit doesn't exist, url: " + PlatformUrls.getActivePlatformUrl();
    private static final String SSL_CERT_MESSAGE = "There was a problem with the SSL handshake, please check your certificate installation.";
    private static final int DEFAULT_TOKEN_EXP_DAYS = 7;
    private static final int SECURE_STORAGE_ERROR_STATUS_CODE = 100;
    private final ConnectionManager connectionManager;
    private LoadingCache<AuthUser, IAuthResult<Boolean>> tokenValidResultsCache = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.MINUTES).build(VALID_TOKEN_LOADER);
    private static final CacheLoader<AuthUser, IAuthResult<Boolean>> VALID_TOKEN_LOADER = new CacheLoader<AuthUser, IAuthResult<Boolean>>(){

        public IAuthResult<Boolean> load(AuthUser user) {
            return CoreUtils.getLoginManager().isTokenValid(user);
        }
    };

    @Inject
    public LoginManager(ConnectionManager connectionManager, EventBus eventBus) {
        this.connectionManager = connectionManager;
        this.migrateToSecureStorage();
        this.registerListener(eventBus);
        this.scheduleCheckTokens();
    }

    private void registerListener(EventBus eventBus) {
        eventBus.registerListener(CoreEventTypes.ON_PROXY_CONFIGURATION_CHANGED, () -> this.tokenValidResultsCache.invalidateAll());
    }

    public IAuthResult<AuthUser> login(String code) {
        IAuthResult<AuthUser> result;
        PlatformAuthenticator platAuth = new PlatformAuthenticator(this.connectionManager, this.getTokenExpiration());
        try {
            AuthUser user = platAuth.exchangeCodeForAuthorizationCode(code);
            result = new AuthResult<AuthUser>(user);
        }
        catch (WebApplicationException exception) {
            result = this.getErrorResult(exception);
        }
        return result;
    }

    public void invalidateTokens(List<AuthUser> authUsers) {
        PlatformAuthenticator platformAuthenticator = new PlatformAuthenticator(this.connectionManager);
        platformAuthenticator.invalidate(authUsers);
        this.tokenValidResultsCache.invalidateAll(authUsers);
    }

    public int getTokenExpiration() {
        IEclipsePreferences preferences = LoginManager.getPreferences();
        int tokenExpiration = preferences.getInt("expiration.time", -1);
        if (tokenExpiration == -1) {
            tokenExpiration = 7;
        }
        return tokenExpiration;
    }

    public synchronized List<AuthUser> retrieveAuthUsers() {
        try {
            ISecurePreferences preferences = this.getSecurePreferences();
            String authUsersList = preferences.get("authenticated.users", "authenticated.users");
            if (authUsersList != null && !authUsersList.equals("authenticated.users")) {
                List<AuthUser> authUsers = this.deserialize(authUsersList);
                return authUsers;
            }
        }
        catch (StorageException e) {
            MuleCorePlugin.logError(100, "Failed to retrieve the authenticated users from Secure Storage", e);
        }
        return new ArrayList<AuthUser>();
    }

    public void saveTokenExpirationTime(int tokenExpiration) {
        try {
            IEclipsePreferences preferences = LoginManager.getPreferences();
            preferences.putInt("expiration.time", tokenExpiration);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            MuleCorePlugin.logError("Failed to save the active user to the configuration preference", e);
        }
    }

    public synchronized void saveAuthUsers(List<? extends AuthUser> authUsers) {
        String authUsersAsString = this.serialize(authUsers);
        ISecurePreferences securePreferences = this.getSecurePreferences();
        try {
            securePreferences.put("authenticated.users", authUsersAsString, true);
            securePreferences.flush();
        }
        catch (IOException | StorageException e) {
            MuleCorePlugin.logError(100, "Failed to save authenticated users into the Secure Storage", e);
        }
    }

    public IAuthResult<Boolean> isTokenValid() {
        IAuthResult<Boolean> result;
        PlatformAuthenticator platAuth = new PlatformAuthenticator(this.connectionManager);
        boolean tokenValid = false;
        try {
            AuthUser user = this.retrieveActiveAuthUser();
            tokenValid = platAuth.isValidToken(user);
            result = new AuthResult<Boolean>(tokenValid);
        }
        catch (WebApplicationException exception) {
            result = this.getErrorResult(exception);
        }
        return result;
    }

    private <T> IAuthResult<T> getErrorResult(Throwable exception) {
        Status status = exception.getCause() instanceof SSLHandshakeException ? new Status(Severity.ERROR.getValue(), "org.mule.tooling.core", SSL_CERT_MESSAGE, exception) : (exception.getCause() instanceof UnknownHostException ? new Status(Severity.ERROR.getValue(), "org.mule.tooling.core", URL_MESSAGE, exception) : new Status(Severity.ERROR.getValue(), "org.mule.tooling.core", GENERIC_MESSAGE, exception));
        return new AuthResult((IStatus)status);
    }

    public IAuthResult<Boolean> isTokenValid(AuthUser user, boolean force) {
        if (force) {
            this.tokenValidResultsCache.invalidate((Object)user);
        }
        return (IAuthResult)this.tokenValidResultsCache.getUnchecked((Object)user);
    }

    public IAuthResult<Boolean> isTokenValid(AuthUser user) {
        IAuthResult<Boolean> result;
        if (user != null) {
            PlatformAuthenticator platAuth = new PlatformAuthenticator(this.connectionManager);
            boolean tokenValid = false;
            try {
                tokenValid = platAuth.isValidToken(user);
                result = new AuthResult<Boolean>(tokenValid);
            }
            catch (WebApplicationException exception) {
                result = this.getErrorResult(exception);
            }
            this.tokenValidResultsCache.put((Object)user, result);
        } else {
            result = this.getErrorResult(new NullPointerException("null user").fillInStackTrace());
        }
        return result;
    }

    public synchronized AuthUser retrieveActiveAuthUser() {
        try {
            ISecurePreferences preferences = this.getSecurePreferences();
            String defaultAuthUserName = preferences.get("current.user", "");
            List<AuthUser> authUsers = this.retrieveAuthUsers();
            for (AuthUser authUser : authUsers) {
                if (!authUser.getUserId().equals(defaultAuthUserName)) continue;
                return authUser;
            }
        }
        catch (StorageException e) {
            MuleCorePlugin.logError(100, "Failed to retrieve the current authenticated user from Secure Storage", e);
        }
        return null;
    }

    public synchronized void saveActiveAuthUser(AuthUser authUser) {
        ISecurePreferences preferences = this.getSecurePreferences();
        try {
            this.saveActiveAuthUser(authUser, preferences);
        }
        catch (IOException | StorageException e) {
            MuleCorePlugin.logError(100, "Failed to save the active user into the Secure Storage", e);
        }
    }

    public synchronized void removeAllUsers() {
        AuthUser[] authUsers = this.retrieveAuthUsers().toArray(new AuthUser[this.retrieveAuthUsers().size()]);
        this.getEventBus().fireEvent((IEvent)new DeleteUsersChangeEvent(authUsers));
        ISecurePreferences securePreferences = this.getSecurePreferences();
        securePreferences.remove("authenticated.users");
        securePreferences.remove("current.user");
        securePreferences.remove("current.token");
        try {
            securePreferences.flush();
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Couldn't remove all the authenticated users", e);
        }
    }

    private boolean shouldMigrateToSecureStorage() {
        try {
            IEclipsePreferences preferences = LoginManager.getPreferences();
            List<String> keys = Arrays.asList(preferences.keys());
            return keys.contains("authenticated.users") || keys.contains("current.user") || keys.contains("current.token");
        }
        catch (BackingStoreException e) {
            MuleCorePlugin.logWarning("Couldn't read authenticated users preferences to migrate them to Secure Storage", e);
            return false;
        }
    }

    private synchronized void migrateToSecureStorage() {
        if (!this.shouldMigrateToSecureStorage()) {
            return;
        }
        IEclipsePreferences preferences = LoginManager.getPreferences();
        String authUsers = preferences.get("authenticated.users", null);
        String currentUser = preferences.get("current.user", null);
        String currentToken = preferences.get("current.token", null);
        ISecurePreferences securePreferences = this.getSecurePreferences();
        try {
            if (authUsers != null) {
                securePreferences.put("authenticated.users", authUsers, true);
            }
            if (currentUser != null) {
                securePreferences.put("current.user", currentUser, false);
            }
            if (currentToken != null) {
                securePreferences.put("current.token", currentToken, true);
            }
            preferences.remove("authenticated.users");
            preferences.remove("current.user");
            preferences.remove("current.token");
            securePreferences.flush();
            preferences.flush();
        }
        catch (IOException | StorageException | BackingStoreException e) {
            MuleCorePlugin.logError("Failed to migrate authenticated users to Secure Storage", e);
        }
    }

    private void saveActiveAuthUser(AuthUser currentActiveUser, ISecurePreferences securePreferences) throws IOException, StorageException {
        String lastCurrentUser = null;
        try {
            lastCurrentUser = securePreferences.get("current.user", null);
        }
        catch (StorageException storageException) {}
        if (currentActiveUser != null) {
            securePreferences.put("current.user", currentActiveUser.getUserId(), false);
            securePreferences.put("current.token", currentActiveUser.getToken(), true);
            List<AuthUser> authUsers = this.retrieveAuthUsers();
            Optional<AuthUser> anyUser = this.findUser(currentActiveUser, authUsers);
            if (anyUser.isPresent()) {
                AuthUser currentUser = anyUser.get();
                currentUser.setToken(currentActiveUser.getToken());
                currentUser.setBaseUrl(currentActiveUser.getBaseUrl());
            } else {
                authUsers.add(currentActiveUser);
            }
            this.saveAuthUsers(authUsers);
        } else {
            securePreferences.remove("current.user");
            securePreferences.remove("current.token");
        }
        if (currentActiveUser != null) {
            if (!StringUtils.equals((CharSequence)currentActiveUser.getUserId(), (CharSequence)lastCurrentUser)) {
                this.getEventBus().fireEvent((IEvent)new CurrentUserChangedEvent(currentActiveUser));
            }
        } else if (lastCurrentUser != null) {
            this.getEventBus().fireEvent((IEvent)new CurrentUserChangedEvent(currentActiveUser));
        }
        securePreferences.flush();
    }

    protected EventBus getEventBus() {
        return MuleCorePlugin.getEventBus();
    }

    public Optional<AuthUser> findUser(AuthUser currentActiveUser, List<AuthUser> authUsers) {
        return authUsers.stream().filter(other -> currentActiveUser != null && other.getUserId().equals(currentActiveUser.getUserId())).findFirst();
    }

    public boolean noCredentials() {
        return this.retrieveActiveAuthUser() == null;
    }

    private String serialize(List<? extends AuthUser> authUsers) {
        Gson gson = new Gson();
        Type listOfAuthUsers = new TypeToken<List<AuthUser>>(){}.getType();
        List<? extends AuthUser> syncListOfAuthUsers = Collections.synchronizedList(authUsers);
        return gson.toJson(syncListOfAuthUsers, listOfAuthUsers);
    }

    private List<AuthUser> deserialize(String usersAsString) {
        Gson gson = new Gson();
        Type listOfAuthUsers = new TypeToken<List<? extends AuthUser>>(){}.getType();
        return (List)gson.fromJson(usersAsString, listOfAuthUsers);
    }

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.authentication");
    }

    protected synchronized ISecurePreferences getSecurePreferences() {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences studioNode = securePreferences.node("Anypoint Studio");
        return studioNode.node("Anypoint Platform");
    }

    public synchronized URI getSecureStorageFileLocation() {
        ISecurePreferences securePreferences = this.getSecurePreferences();
        URL location = ((SecurePreferencesWrapper)securePreferences).getContainer().getLocation();
        try {
            return location.toURI();
        }
        catch (URISyntaxException e) {
            MuleCorePlugin.logError("Couldn't determine Secure Storage location", e);
            return null;
        }
    }

    private void scheduleCheckTokens() {
        Job checkTokenJob = new Job("Checking stored tokens status"){

            protected synchronized IStatus run(IProgressMonitor monitor) {
                if (LoginManager.this.getSecurePreferences() == null) {
                    this.schedule(250L);
                    return Status.OK_STATUS;
                }
                LoginManager.this.retrieveAuthUsers().parallelStream().forEach(arg_0 -> LoginManager.this.tokenValidResultsCache.getUnchecked(arg_0));
                return Status.OK_STATUS;
            }
        };
        checkTokenJob.setSystem(true);
        checkTokenJob.schedule();
    }
}

