/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.auth;

import org.mule.tooling.core.auth.IServiceUrlBuilder;
import org.mule.tooling.core.auth.PlatformUrl;
import org.mule.tooling.core.m2.ExchangeMavenFacade;

public class CloudServiceUrlBuilder
implements IServiceUrlBuilder {
    private static final String EXCHANGE = "exchange";
    private static final String MAVEN = "maven";
    private static final String DESIGNER = "designer";
    private static final String API_DESIGNER = "api-designer";
    private static final String MULESOFT_VCS = "designcenter";
    private PlatformUrl.PlatformUrlBuilder activePlatformBuilder;

    public CloudServiceUrlBuilder(PlatformUrl.PlatformUrlBuilder activePlatformBuilder) {
        this.activePlatformBuilder = activePlatformBuilder;
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder mavenServiceBuilder() {
        return this.mavenService().withApiVersion(ExchangeMavenFacade.getCurrentAPIVersion());
    }

    private PlatformUrl.PlatformUrlBuilder mavenService() {
        return this.activePlatformBuilder.withPrefix(MAVEN).append(MAVEN);
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder graphServiceBuilder() {
        return this.activePlatformBuilder.withSuffix("graph").append("graphql").withApiVersion("v2");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder exchangeXAPIBuilder() {
        return this.exchangeAssetBuilder().withApiVersion("v1");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder exchangeAssetBuilder() {
        return this.activePlatformBuilder.withSuffix(EXCHANGE);
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder designCenterBuilder() {
        return this.activePlatformBuilder.append(MULESOFT_VCS).append(DESIGNER).append("#");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder oldMavenServiceBuilder() {
        return this.mavenService().withApiVersion("v1");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder apiDesignerBuilder() {
        return this.activePlatformBuilder.append(MULESOFT_VCS).append(API_DESIGNER);
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder gitEndpointBuilder() {
        return this.activePlatformBuilder.append("git");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder cloudhubUrlBuilder() {
        return this.activePlatformBuilder;
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder acbCentralUrlBuilder() {
        return this.activePlatformBuilder.withSuffix("codebuilder");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder asyncKitUrlBuilder() {
        return this.activePlatformBuilder.withSuffix("codebuilder/webide").withApiVersion("v1");
    }

    @Override
    public PlatformUrl.PlatformUrlBuilder anypointProfileUrlBuilder() {
        return this.activePlatformBuilder.append("accounts").append("api").append("profile");
    }
}

