/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.analytics;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.DefaultSingleRecord;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.auth.RegionUrlResolver;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.osgi.services.analytics.IAnalyticsRecord;
import org.mule.tooling.osgi.services.analytics.IAnalyticsService;

public class AnalyticsRecordsFactory {
    public static final String ADDITIONAL_METADATA_ARG = "org.mule.tooling.additionalTelemetryMetadata";
    private static final String ADDITIONAL_ARGS_DELIMITER = ",";
    private static final String EQUALS_SPLITTER = "=";
    private static final String CORE_NAMESPACE_KEY = "/ee/";
    public static final String CORE_EE_ARTIFACT_ID = "mule-ee-core";
    public static final String CORE_CE_ARTIFACT_ID = "mule-core";
    public static final String CORE_GROUP_ID = "org.mule.runtime";
    private static final String ENVIRONMENT_US = "us";
    private static final String ENVIRONMENT_PCE = "pce";
    private static final String ENVIRONMENT_NOT_AVAILABLE = "n/a";
    private static final String maxMemory = AnalyticsRecordsFactory.getMaxMemory();
    private DefaultSingleRecord record;

    private AnalyticsRecordsFactory(String metricId) {
        this.record = new DefaultSingleRecord(metricId);
        this.addEnvironmentMetadata();
        this.addMemoryUsage();
        this.addAdditionalMetadata();
    }

    public static AnalyticsRecordsFactory single(String metricId) {
        if (StringUtils.isBlank((String)metricId)) {
            throw new IllegalArgumentException("Invalid arguments to create Single Record: Metric ID cannot be null");
        }
        return new AnalyticsRecordsFactory(metricId);
    }

    public static AnalyticsRecordsFactory withCurrentMuleProject(String metricId) {
        return AnalyticsRecordsFactory.single(metricId, MuleCorePlugin.getDesignContext().getMuleProject());
    }

    public static AnalyticsRecordsFactory single(String metricId, Optional<IMuleProject> muleProject) {
        if (StringUtils.isBlank((String)metricId)) {
            throw new IllegalArgumentException("Invalid arguments to create Single Record: Metric ID cannot be null ");
        }
        AnalyticsRecordsFactory singleRecordsFactory = new AnalyticsRecordsFactory(metricId);
        muleProject.ifPresent(project -> AnalyticsRecordsFactory.addMuleProjectMetadata(singleRecordsFactory, project));
        return singleRecordsFactory;
    }

    public static AnalyticsRecordsFactory single(String metricId, IMuleProject muleProject) {
        if (StringUtils.isBlank((String)metricId)) {
            throw new IllegalArgumentException("Invalid arguments to create Single Record: Metric ID cannot be null ");
        }
        if (muleProject == null) {
            throw new IllegalArgumentException("Invalid arguments to create Single Record: Mule Project cannot be null");
        }
        AnalyticsRecordsFactory singleRecordsFactory = new AnalyticsRecordsFactory(metricId);
        AnalyticsRecordsFactory.addMuleProjectMetadata(singleRecordsFactory, muleProject);
        return singleRecordsFactory;
    }

    private static void addMuleProjectMetadata(AnalyticsRecordsFactory singleRecordsFactory, IMuleProject muleProject) {
        try {
            MavenDependency projectDependency = muleProject.getProjectDependency();
            singleRecordsFactory.addMetadata("groupId", projectDependency.getGroupId());
            singleRecordsFactory.addMetadata("artifactId", projectDependency.getArtifactId());
            singleRecordsFactory.addMetadata("artifactVersion", projectDependency.getVersion());
            IServerDefinition serverDefinition = muleProject.getServerDefinition();
            if (serverDefinition != null) {
                singleRecordsFactory.addMetadata("runtimeVersion", serverDefinition.getLabel());
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logWarning("Failed building metric with mule project", e);
        }
    }

    public static AnalyticsRecordsFactory single(String metricId, String ... metadata) {
        if (metadata.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid arguments to create Single Record: Metadata parameters should be even");
        }
        if (StringUtils.isBlank((String)metricId)) {
            throw new IllegalArgumentException("Invalid arguments to create Single Record: Metric ID cannot be null");
        }
        AnalyticsRecordsFactory singleRecordsFactory = new AnalyticsRecordsFactory(metricId);
        int i = 0;
        while (i < metadata.length) {
            singleRecordsFactory.addMetadata(metadata[i], metadata[i + 1]);
            i += 2;
        }
        return singleRecordsFactory;
    }

    public AnalyticsRecordsFactory addMetadata(String key, String value) {
        this.record.addData(key, value);
        return this;
    }

    private String resolveEnvironmentId() {
        boolean pceEnabled = LoginManager.getPreferences().getBoolean("org.mule.tooling.onprem.enabled", false);
        if (pceEnabled) {
            return ENVIRONMENT_PCE;
        }
        String region = RegionUrlResolver.getInstance().getPlatformRegion().getPrefix();
        if (region == null) {
            return ENVIRONMENT_NOT_AVAILABLE;
        }
        if (region == "") {
            region = ENVIRONMENT_US;
        }
        return region;
    }

    private void addEnvironmentMetadata() {
        this.addMetadata("environment", this.resolveEnvironmentId());
    }

    private void addMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long afterUsedMem = totalMemory - runtime.freeMemory();
        this.addMetadata("maxMemory", String.valueOf(maxMemory));
        this.addMetadata("totalMemoryInBytes", String.valueOf(totalMemory));
        this.addMetadata("javaMemoryUsageInBytes", String.valueOf(afterUsedMem));
    }

    public AnalyticsRecordsFactory withOptionalConnectorProperty(Optional<MessageFlowEntity> component, IMuleProject project) {
        return component.map(c -> this.withConnectorProperty((MessageFlowEntity)c, project)).orElse(this);
    }

    public AnalyticsRecordsFactory withConnectorProperty(MessageFlowEntity component, IMuleProject project) {
        try {
            IElementWrapper element = component.getElement();
            if (element != null) {
                MuleModuleCoordinates moduleCoordinates = this.resolveModuleMavenCoordinates(element, project);
                this.withMuleConnectorModuleCoordinates(moduleCoordinates);
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError("Failed adding module information to metrics", e);
        }
        return this;
    }

    private MuleModuleCoordinates resolveModuleMavenCoordinates(IElementWrapper element, IMuleProject project) {
        MuleModuleCoordinates muleMavenCoordinates;
        String namespaceURI = element.getNamespaceURI();
        List module = project.getModuleManager().getExternalModules().stream().filter(extension -> StringUtils.equals((String)extension.getContributionNamespace(), (String)namespaceURI)).collect(Collectors.toList());
        if (!module.isEmpty()) {
            muleMavenCoordinates = MuleModuleCoordinates.buildMuleModuleCoordinates((ExternalContributionMuleModule)module.get(0), element);
        } else {
            String version = project.getServerDefinition().getVersion();
            muleMavenCoordinates = MuleModuleCoordinates.buildMuleCoreCoordinates(version, element);
        }
        return muleMavenCoordinates;
    }

    public AnalyticsRecordsFactory withModuleProperty(List<ExternalContributionMuleModule> modules) {
        modules.stream().forEach(m -> this.withMuleModuleCoordinates((ExternalContributionMuleModule)m));
        return this;
    }

    public AnalyticsRecordsFactory withMuleModuleCoordinates(ExternalContributionMuleModule m) {
        this.withMuleModuleCoordinates(MuleModuleCoordinates.buildMuleModuleMavenCoordinates(m));
        return this;
    }

    public AnalyticsRecordsFactory withDependencyProperty(List<MavenDependency> dependencies) {
        dependencies.stream().forEach(dependency2 -> this.addMetadata("dependency", MavenUtils.getGAVCT(dependency2)));
        return this;
    }

    public AnalyticsRecordsFactory withDesignCenterProjectID(String designcenterProjectID) {
        this.addMetadata("designCenterProjectId", designcenterProjectID);
        return this;
    }

    public Map<String, String> getAdditionalMetadataForEvents() {
        HashMap<String, String> additionalProps = new HashMap<String, String>();
        List<String> additionalMetadata = Arrays.asList(System.getProperty(ADDITIONAL_METADATA_ARG, "").split(ADDITIONAL_ARGS_DELIMITER));
        additionalMetadata.forEach(metadataArg -> {
            String[] splittedKeyValue = metadataArg.split(EQUALS_SPLITTER);
            if (splittedKeyValue.length == 2) {
                additionalProps.put(splittedKeyValue[0], splittedKeyValue[1]);
            }
        });
        return additionalProps;
    }

    public void addAdditionalMetadata() {
        this.getAdditionalMetadataForEvents().forEach(this::addMetadata);
    }

    public void track() {
        IAnalyticsService analyticsService = this.getAnalyticsService();
        if (analyticsService != null) {
            analyticsService.track((IAnalyticsRecord)this.record);
        }
    }

    public IAnalyticsService getAnalyticsService() {
        return MuleCorePlugin.getAnalyticsService();
    }

    private static String getMaxMemory() {
        String memory = "";
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        String maxMemoryPrefix = "-Xmx";
        for (String arg : inputArguments) {
            if (!StringUtils.startsWith((String)arg, (String)maxMemoryPrefix)) continue;
            memory = StringUtils.substringAfter((String)arg, (String)maxMemoryPrefix);
        }
        return memory;
    }

    private AnalyticsRecordsFactory withMuleModuleCoordinates(MuleModuleCoordinates m) {
        this.addMetadata("moduleId", m.getId());
        this.addMetadata("moduleArtifactId", m.getArtifactId());
        this.addMetadata("moduleGroupId", m.getGroupId());
        this.addMetadata("moduleVersion", m.getVersion());
        return this;
    }

    private AnalyticsRecordsFactory withMuleConnectorModuleCoordinates(MuleModuleCoordinates m) {
        this.withMuleModuleCoordinates(m);
        this.addMetadata("schema", m.getSchema());
        this.addMetadata("name", m.getModuleName());
        return this;
    }

    private static class MuleModuleCoordinates {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String moduleName;
        private final String schema;
        private final String id;

        private MuleModuleCoordinates(String groupId, String artifactId, String version, String moduleName, String namespace, String id) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.moduleName = moduleName;
            this.schema = namespace + "/" + moduleName;
            this.id = id;
        }

        private MuleModuleCoordinates(String groupId, String artifactId, String version, String moduleName, String schema) {
            this(groupId, artifactId, version, moduleName, schema, null);
        }

        private MuleModuleCoordinates(String groupId, String artifactId, String version, String id) {
            this(groupId, artifactId, version, null, null, id);
        }

        public static MuleModuleCoordinates buildMuleCoreCoordinates(String version, IElementWrapper element) {
            if (StringUtils.contains((String)element.getNamespaceURI(), (String)AnalyticsRecordsFactory.CORE_NAMESPACE_KEY)) {
                return new MuleModuleCoordinates(AnalyticsRecordsFactory.CORE_GROUP_ID, AnalyticsRecordsFactory.CORE_EE_ARTIFACT_ID, version, element.getName(), element.getNamespaceURI());
            }
            return new MuleModuleCoordinates(AnalyticsRecordsFactory.CORE_GROUP_ID, AnalyticsRecordsFactory.CORE_CE_ARTIFACT_ID, version, element.getName(), element.getNamespaceURI());
        }

        public static MuleModuleCoordinates buildMuleModuleCoordinates(ExternalContributionMuleModule externalContributionMuleModule, IElementWrapper element) {
            MavenCoordinates mavenCoordinates = externalContributionMuleModule.getCoordinates();
            return new MuleModuleCoordinates(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), element.getName(), element.getNamespaceURI(), externalContributionMuleModule.getId());
        }

        public static MuleModuleCoordinates buildMuleModuleMavenCoordinates(ExternalContributionMuleModule externalContributionMuleModule) {
            MavenCoordinates mavenCoordinates = externalContributionMuleModule.getCoordinates();
            return new MuleModuleCoordinates(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), externalContributionMuleModule.getId());
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getId() {
            return this.id;
        }
    }
}

