/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.mule.tooling.core.MuleCorePlugin;

public class WindowsDefenderChecker {
    private static final String ANYPOINT_STUDIO_EXE = "\"AnypointStudio.exe\"";
    private static final String PROPERTY_EXCLUSION_PROCESS = "ExclusionProcess";
    private static final String PROPERTY_EXCLUSION_PATH = "ExclusionPath";
    private static final String ECLIPSE_HOME_LOCATION = "eclipse.home.location";
    private static final String P2 = ".p2";
    private static final String USER_HOME = "user.home";
    public static final String REAL_TIME_PROTECTION_ENABLED = "RealTimeProtectionEnabled\\s+:\\s+(\\w+)";
    public static final String COMMAND_GET_MP_COMPUTER_STATUS = "Get-MpComputerStatus";
    public static final String COMMAND_GET_MP_PREFERENCE = "Get-MpPreference";
    public static final String COMMAND_ADD_MP_PREFERENCE = "Add-MpPreference";
    private static final String POWERSHELL_EXECUTALBE = "powershell.exe ";
    private static final String POWERSHELL_EXECUTALBE_AS_ADMIN = "powershell.exe -Command Start-Process powershell.exe -Verb RunAs -ArgumentList ";

    private WindowsDefenderChecker() {
    }

    public static Boolean isWindowsDefenderActive() throws IOException {
        List<String> lines = WindowsDefenderChecker.executePowerShellCommand(COMMAND_GET_MP_COMPUTER_STATUS);
        Pattern pattern = Pattern.compile(REAL_TIME_PROTECTION_ENABLED);
        for (String line : lines) {
            String value;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find() || !"True".equals(value = matcher.group(1))) continue;
            return true;
        }
        return false;
    }

    private static List<String> executePowerShellCommandAsAdministrator(String command) {
        String commandPowerShell = POWERSHELL_EXECUTALBE_AS_ADMIN + command;
        return WindowsDefenderChecker.executeCommandAndProcessOutput(commandPowerShell);
    }

    public static List<String> executePowerShellCommand(String command) {
        String commandPowerShell = POWERSHELL_EXECUTALBE + command;
        return WindowsDefenderChecker.executeCommandAndProcessOutput(commandPowerShell);
    }

    private static List<String> executeCommandAndProcessOutput(String commnad) {
        try {
            Process powerShellProcess = Runtime.getRuntime().exec(commnad);
            powerShellProcess.getOutputStream().close();
            int exit = powerShellProcess.waitFor();
            if (exit == 0) {
                return WindowsDefenderChecker.processInputStream(powerShellProcess.getInputStream());
            }
            if (exit == 1) {
                List<String> result = WindowsDefenderChecker.processInputStream(powerShellProcess.getErrorStream());
                String joinedString = String.join((CharSequence)" ", result);
                MuleCorePlugin.logError(joinedString);
            }
        }
        catch (IOException | InterruptedException exception) {
            MuleCorePlugin.logError(commnad + " command couldn't be execute");
        }
        return Collections.emptyList();
    }

    private static List<String> processInputStream(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static List<String> getWindowsDefenderValueForProperty(String command_let, String property) {
        String command = command_let + "| select -ExpandProperty " + property;
        return WindowsDefenderChecker.executePowerShellCommandAsAdministrator(command);
    }

    public static List<String> getExcludedPatterns() {
        return WindowsDefenderChecker.getWindowsDefenderValueForProperty(COMMAND_GET_MP_PREFERENCE, PROPERTY_EXCLUSION_PATH);
    }

    public static List<String> getExcludedProcesses() {
        return WindowsDefenderChecker.getWindowsDefenderValueForProperty(COMMAND_GET_MP_PREFERENCE, PROPERTY_EXCLUSION_PROCESS);
    }

    protected static List<Path> getStudioImportanPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(Paths.get(System.getProperty(USER_HOME), P2));
        paths.add(Paths.get(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString(), new String[0]));
        String eclipseHome = System.getProperty(ECLIPSE_HOME_LOCATION);
        paths.add(Paths.get(eclipseHome.substring(6), new String[0]));
        return paths;
    }

    public static boolean runExcludePathsCommand() {
        StringBuilder commadPaths = new StringBuilder();
        List<Path> paths = WindowsDefenderChecker.getStudioImportanPaths();
        int i = 0;
        while (i < paths.size()) {
            commadPaths.append(paths.get(i).toString());
            if (i <= paths.size() - 2) {
                commadPaths.append(',');
            }
            ++i;
        }
        String command = "'Add-MpPreference -ExclusionPath \"" + commadPaths.toString() + "\"'";
        WindowsDefenderChecker.executePowerShellCommandAsAdministrator(command);
        return true;
    }

    public static boolean runExcludeProcessCommand() {
        String command = "'Add-MpPreference -ExclusionProcess \"AnypointStudio.exe\"'";
        WindowsDefenderChecker.executePowerShellCommandAsAdministrator(command);
        return true;
    }
}

