/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContext;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.utils.SilentRunner;

public class StudioDesignContextRunner {
    public static <T> T runSilentWithMuleProject(Callable<T> call, IMuleProject muleProject, T defaultReturn) {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(muleProject, localThreadContext);
        try {
            Object object = SilentRunner.run(call, defaultReturn);
            return (T)object;
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }

    private static void postRunWithMuleProject(StudioDesignContext localThreadContext, StudioDesignContext context) {
        context.dispose();
        if (localThreadContext != null) {
            MuleCorePlugin.getContextProvider().setLocalThreadContext(localThreadContext);
        }
    }

    private static StudioDesignContext preRunWithMuleProject(IMuleProject muleProject, StudioDesignContext localThreadContext) {
        return StudioDesignContextRunner.preRunWithMuleProject(muleProject, Optional.ofNullable(localThreadContext).orElse(MuleCorePlugin.getContextProvider().getDefaultContext()).getEditingScope(), localThreadContext);
    }

    private static StudioDesignContext preRunWithMuleProject(IMuleProject muleProject, EditingScope editingScope, StudioDesignContext localThreadContext) {
        MuleCorePlugin.getContextProvider().remove(localThreadContext);
        StudioDesignContext context = MuleCorePlugin.createLocalThreadDesignContext(muleProject, editingScope);
        return context;
    }

    public static void runSilentWithMuleProject(SilentRunner.VoidCallable call, IMuleProject muleProject) {
        StudioDesignContextRunner.runSilentWithMuleProject(() -> {
            call.call();
            return null;
        }, muleProject);
    }

    public static void runSilentWithMuleProject(Callable<Void> call, IMuleProject muleProject) {
        StudioDesignContextRunner.runSilentWithMuleProject(call, muleProject, null);
    }

    public static void runSilentWithMuleProjectInUI(Callable<Void> call, IMuleProject muleProject) {
        StudioDesignContextRunner.syncExecSilentWithMuleProjectInUI(call, muleProject);
    }

    public static void syncExecSilentWithMuleProjectInUI(Callable<Void> call, IMuleProject muleProject) {
        Display.getDefault().syncExec(() -> {
            Object v0 = StudioDesignContextRunner.runSilentWithMuleProject(call, muleProject, null);
        });
    }

    public static void asyncExecSilentWithMuleProjectInUI(Callable<Void> call, IMuleProject muleProject) {
        Display.getDefault().asyncExec(() -> {
            Object v0 = StudioDesignContextRunner.runSilentWithMuleProject(call, muleProject, null);
        });
    }

    public static void runSilentWithProject(Callable<Void> call, IProject project) {
        SilentRunner.run(() -> {
            Object muleProject = MuleRuntime.create(project);
            StudioDesignContextRunner.runSilentWithMuleProject(call, muleProject, null);
            return null;
        }, null);
    }

    public static <T> T runWithMuleProject(Callable<T> call, IMuleProject muleProject) throws Exception {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(muleProject, localThreadContext);
        try {
            T t = call.call();
            return t;
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }

    public static <T> T runWithContext(Callable<T> call, IMuleProject muleProject, EditingScope editingScope) throws Exception {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(muleProject, editingScope, localThreadContext);
        try {
            T t = call.call();
            return t;
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }

    public static void runSilentWithContext(Callable<Void> call, IMuleProject muleProject, EditingScope editingScope) {
        SilentRunner.run(() -> {
            StudioDesignContextRunner.runWithContext(call, muleProject, editingScope);
            return null;
        }, null);
    }

    @Deprecated
    public static void runSilentWithContextInUI(Callable<Void> call, IMuleProject muleProject, EditingScope editingScope) {
        StudioDesignContextRunner.syncExecSilentWithContextInUI(call, muleProject, editingScope);
    }

    public static void syncExecSilentWithContextInUI(Callable<Void> call, IMuleProject muleProject, EditingScope editingScope) {
        Display.getDefault().syncExec(() -> StudioDesignContextRunner.runSilentWithContext(call, muleProject, editingScope));
    }

    public static void asyncExecSilentWithContextInUI(Callable<Void> call, IMuleProject muleProject, EditingScope editingScope) {
        Display.getDefault().asyncExec(() -> StudioDesignContextRunner.runSilentWithContext(call, muleProject, editingScope));
    }

    public static <T> T runWithProjectThrowingCoreException(Callable<T> call, IProject project) throws CoreException {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(MuleRuntime.create(project), localThreadContext);
        try {
            T t = call.call();
            return t;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }

    public static <T> T runWithContextThrowingCoreException(Callable<T> call, IMuleProject project, EditingScope scope) throws CoreException {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(project, scope, localThreadContext);
        try {
            T t = call.call();
            return t;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }

    public static void runWithMuleProjectThrowingCoreException(SilentRunner.VoidCallable call, IMuleProject muleProject) throws CoreException {
        StudioDesignContextRunner.runWithMuleProjectThrowingCoreException(() -> {
            call.call();
            return null;
        }, muleProject);
    }

    public static <T> T runWithMuleProjectThrowingCoreException(Callable<T> call, IMuleProject muleProject) throws CoreException {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(muleProject, localThreadContext);
        try {
            T t = call.call();
            return t;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }

    public static <T> T runSilentWithContext(Callable<T> callable, IMuleProject muleProject, EditingScope editingScope, T defaultReturn) {
        StudioDesignContext localThreadContext = MuleCorePlugin.getContextProvider().getLocalThreadContext();
        StudioDesignContext context = StudioDesignContextRunner.preRunWithMuleProject(muleProject, editingScope, localThreadContext);
        try {
            Object object = SilentRunner.run(callable, defaultReturn);
            return (T)object;
        }
        finally {
            StudioDesignContextRunner.postRunWithMuleProject(localThreadContext, context);
        }
    }
}

