/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import org.mule.tooling.core.StudioDesignContext;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;

public class StudioDesignContextProvider {
    private StudioDesignContext defaultContext = new StudioDesignContext(this);
    private ThreadLocal<StudioDesignContext> localContext = new ThreadLocal();

    public synchronized StudioDesignContext getContext() {
        StudioDesignContext studioDesignContext = this.getLocalThreadContext();
        if (studioDesignContext == null) {
            return this.defaultContext;
        }
        return studioDesignContext;
    }

    public StudioDesignContext getDefaultContext() {
        return this.defaultContext;
    }

    public synchronized StudioDesignContext createLocalThread(IMuleProject muleProject, EditingScope editingScope) {
        StudioDesignContext studioDesignContext = this.getLocalThreadContext();
        if (studioDesignContext != null) {
            throw new IllegalStateException("A context for the given thread already existed");
        }
        studioDesignContext = new StudioDesignContext(this);
        this.setLocalThreadContext(studioDesignContext);
        studioDesignContext.updateContext(muleProject, editingScope);
        return studioDesignContext;
    }

    void setLocalThreadContext(StudioDesignContext studioDesignContext) {
        this.localContext.set(studioDesignContext);
    }

    StudioDesignContext getLocalThreadContext() {
        return this.localContext.get();
    }

    void remove(StudioDesignContext studioDesignContext) {
        this.localContext.remove();
    }
}

