/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import java.lang.ref.WeakReference;
import org.mule.tooling.core.StudioDesignContextProvider;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;

public class StudioDesignContext {
    protected WeakReference<IMuleProject> muleProjectRef;
    private StudioDesignContextProvider studioDesignContextProvider;
    private EditingScope editingScope = EditingScope.APP;

    public StudioDesignContext(StudioDesignContextProvider studioDesignContextProvider) {
        this.studioDesignContextProvider = studioDesignContextProvider;
    }

    public synchronized void updateContext(IMuleProject muleProject, EditingScope editingContext) {
        this.clear();
        this.setMuleProject(muleProject);
        this.setEditingScope(editingContext);
    }

    private void setMuleProject(IMuleProject currentMuleProject) {
        if (this.muleProjectRef != null && this.muleProjectRef.get() != null) {
            throw new RuntimeException("muleProject was already set");
        }
        this.muleProjectRef = new WeakReference<IMuleProject>(currentMuleProject);
    }

    private void setEditingScope(EditingScope editionContext) {
        this.editingScope = editionContext;
    }

    public synchronized IMuleProject getMuleProject() {
        if (this.muleProjectRef != null) {
            return (IMuleProject)this.muleProjectRef.get();
        }
        return null;
    }

    public synchronized EditingScope getEditingScope() {
        return this.editingScope;
    }

    public synchronized void dispose() {
        this.studioDesignContextProvider.remove(this);
        this.clear();
    }

    private void clear() {
        if (this.muleProjectRef != null) {
            this.muleProjectRef.clear();
        }
        this.editingScope = EditingScope.APP;
    }
}

