/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.action.ProjectLifecycleAction;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.dependencymanagement.EclipseDependencyManager;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.impl.model.MuleAppRootImpl;
import org.mule.tooling.core.impl.model.MuleDomainProject;
import org.mule.tooling.core.impl.model.MuleProject;
import org.mule.tooling.core.impl.model.MuleRootImpl;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.jvm.CompatibilityResult;
import org.mule.tooling.core.jvm.JVMHelper;
import org.mule.tooling.core.jvm.JdtJavaRuntimeResolver;
import org.mule.tooling.core.jvm.MuleRuntimeJavaCompatibilityComputer;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleConnectorProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleRoot;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ProjectLifecycleContributionManager;
import org.mule.tooling.utils.lang.ConvertibleReadWriteLock;
import org.mule.tooling.utils.lang.SafeCloseable;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class MuleRuntime {
    protected static final Map<IProject, IMuleProject> projects = new HashMap<IProject, IMuleProject>();
    protected static final Set<String> initializingProjectNames = Collections.synchronizedSet(new HashSet());
    protected static final ConvertibleReadWriteLock projectsLock = ConvertibleReadWriteLock.create();
    protected static final int JVM_NAME_SEGMENT_INDEX = 2;

    public static <T extends IMuleProject> T create(IProject project) {
        return (T)((IMuleProject)project.getAdapter(MuleRuntime.getAdapterClass(project)));
    }

    private static Class<? extends IMuleProject> getAdapterClass(IProject project) {
        try {
            if (CoreUtils.hasSDKNature(project)) {
                return IMuleConnectorProject.class;
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while determining the nature of the project " + project.getName(), e);
        }
        return IMuleProject.class;
    }

    public static IMuleProject adapt(IProject project) throws CoreException {
        if (MuleRuntime.isInitializing(project)) {
            return null;
        }
        return MuleRuntime.internalCreate(project, null, null);
    }

    static IMuleProject adapt(IJavaProject javaProject) throws CoreException {
        IProject project = javaProject.getProject();
        if (MuleRuntime.isInitializing(project)) {
            return null;
        }
        return MuleRuntime.internalCreate(project, javaProject, null);
    }

    private static boolean isInitializing(IProject project) {
        return initializingProjectNames.contains(project.getName());
    }

    private static BaseMuleProject internalCreate(IProject project, IJavaProject javaProject, ProjectInitializationData params) throws CoreException {
        BaseMuleProject muleProject;
        boolean hasMuleNature = CoreUtils.hasMuleNature(project);
        if (!hasMuleNature) {
            return null;
        }
        boolean hasDomainNature = CoreUtils.hasMuleDomainNature(project);
        javaProject = javaProject != null ? javaProject : JavaCore.create((IProject)project);
        boolean initializing = false;
        Throwable throwable = null;
        Object var8_8 = null;
        try (ConvertibleReadWriteLock.UpgradingLock readLock = projectsLock.lockForReadLevel();){
            muleProject = (BaseMuleProject)projects.get(project);
            if (muleProject == null) {
                readLock.upgradeLockToWriteLevel();
                muleProject = (BaseMuleProject)projects.get(project);
                if (muleProject == null) {
                    muleProject = hasDomainNature ? new MuleDomainProject(javaProject) : new MuleProject(javaProject);
                    projects.put(project, muleProject);
                    initializing = true;
                    muleProject.initialize(params);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (initializing) {
            muleProject.postInitialize();
        }
        return muleProject;
    }

    public static IMuleProject createMuleProject(IJavaProject javaProject, ProjectInitializationData initData) throws CoreException {
        BaseMuleProject baseMuleProject = MuleRuntime.internalCreate(javaProject.getProject(), javaProject, initData);
        if (baseMuleProject != null) {
            CoreUtils.createDocumentationStructure(baseMuleProject);
        }
        return baseMuleProject;
    }

    public static void configureMuleProjectClasspath(IMuleProject muleProject, IServerDefinition runtimeServer) throws CoreException {
        MuleRuntime.configureMuleProjectClasspath(muleProject, runtimeServer, new JVMHelper());
    }

    public static void configureMuleProjectClasspath(IMuleProject muleProject, IServerDefinition runtimeServer, JVMHelper jvmHelper) throws CoreException {
        IJavaProject javaProject = muleProject.getJavaProject();
        IPath defaultOutputFolder = javaProject.getPath().append((IPath)IMuleResources.OUTPUT_DIRECTORY_FOLDER_PATH);
        javaProject.setOutputLocation(defaultOutputFolder, (IProgressMonitor)new NullProgressMonitor());
        Consumer<List<IClasspathEntry>> modifyClasspathFunction = MuleRuntime.getModifyClasspathFuncion(muleProject, runtimeServer, jvmHelper);
        muleProject.modifyClasspath(modifyClasspathFunction, (IProgressMonitor)new NullProgressMonitor());
        new EclipseDependencyManager().updateDependencies(javaProject);
    }

    public static Consumer<List<IClasspathEntry>> getModifyClasspathFuncion(IMuleProject muleProject, IServerDefinition runtimeServer) {
        return MuleRuntime.getModifyClasspathFuncion(muleProject, runtimeServer, new JVMHelper());
    }

    public static Consumer<List<IClasspathEntry>> getModifyClasspathFuncion(IMuleProject muleProject, IServerDefinition runtimeServer, JVMHelper jvmHelper) {
        return entries -> {
            IJavaProject javaProject = muleProject.getJavaProject();
            String runtimeId = runtimeServer.getId();
            ArrayList entriesToRemove = Lists.newArrayList();
            entries.forEach(entry -> {
                if (entry.getEntryKind() == 3 || MuleClasspathContainer.isMuleRuntime(entry) && !MuleClasspathContainer.isExactMuleRuntime(entry, runtimeId)) {
                    entriesToRemove.add(entry);
                }
            });
            if (!entriesToRemove.isEmpty()) {
                entries.removeAll(entriesToRemove);
            }
            try {
                Optional<IClasspathEntry> optionalJREContainerEntry;
                if (!MuleClasspathContainer.hasMuleClasspathContainer(javaProject, runtimeId) && !MuleClasspathContainer.hasAnyMuleClasspathContainer(entries)) {
                    IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)MuleClasspathContainer.buildContainerPath(runtimeId), (boolean)true);
                    entries.add(newContainerEntry);
                }
                if (!ProjectClasspathUtils.hasAJavaRuntimeClasspathContainer(javaProject, (IProgressMonitor)new NullProgressMonitor())) {
                    IClasspathEntry defaultJREContainerEntry = JavaRuntime.getDefaultJREContainerEntry();
                    entries.add(defaultJREContainerEntry);
                }
                if ((optionalJREContainerEntry = ProjectClasspathUtils.getJavaRuntimeClasspathContainer(javaProject, (IProgressMonitor)new NullProgressMonitor())).isPresent()) {
                    IClasspathEntry jreEntry = optionalJREContainerEntry.get();
                    String jvmName = jreEntry.getPath().segment(2);
                    if (jvmName == null) {
                        MuleRuntime.validateJVM(entries, jreEntry, JavaRuntime.getDefaultVMInstall(), runtimeServer, jvmHelper);
                    } else {
                        Optional<IVMInstall> optJvm = jvmHelper.getVMInstallByName(jvmName);
                        if (optJvm.isPresent()) {
                            MuleRuntime.validateJVM(entries, jreEntry, optJvm.get(), runtimeServer, jvmHelper);
                        } else {
                            MuleRuntime.selectValidJVM(entries, jreEntry, runtimeServer, jvmHelper);
                        }
                    }
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error configuring project classpath for project " + muleProject.getName(), e);
                throw new IllegalStateException(e);
            }
            if (muleProject instanceof BaseMuleProject) {
                BaseMuleProject baseMuleProject = (BaseMuleProject)muleProject;
                List<IClasspathEntry> sourceFolders = baseMuleProject.getSourceFolderEntries();
                entries.addAll(sourceFolders);
            }
        };
    }

    private static void selectValidJVM(List<IClasspathEntry> entries, IClasspathEntry jreEntry, IServerDefinition runtimeServer, JVMHelper jvmHelper) throws CoreException {
        MuleRuntimeJavaCompatibilityComputer compatibilityComputer = MuleRuntimeJavaCompatibilityComputer.createReadingExtensions();
        VersionRange compatibleVersionRange = compatibilityComputer.getCompatibleVersionRange(runtimeServer);
        MuleRuntime.changeJVMVersion(entries, jreEntry, compatibleVersionRange, jvmHelper);
    }

    private static void validateJVM(List<IClasspathEntry> entries, IClasspathEntry jreEntry, IVMInstall vmInstall, IServerDefinition runtimeServer, JVMHelper jvmHelper) throws CoreException {
        JdtJavaRuntimeResolver javaRuntimeResolver = new JdtJavaRuntimeResolver();
        Version configuredJavaVersion = Version.parseVersion((String)javaRuntimeResolver.getVersion(vmInstall));
        MuleRuntimeJavaCompatibilityComputer compatibilityComputer = MuleRuntimeJavaCompatibilityComputer.createReadingExtensions();
        CompatibilityResult compatibilityResult = compatibilityComputer.isJavaVersionCompatible(runtimeServer, configuredJavaVersion);
        if (!compatibilityResult.isCompatible()) {
            MuleRuntime.changeJVMVersion(entries, jreEntry, compatibilityResult.getCompatibleRange(), jvmHelper);
        }
    }

    private static void changeJVMVersion(List<IClasspathEntry> entries, IClasspathEntry jreEntry, VersionRange supportedJVMRange, JVMHelper jvmHelper) throws CoreException {
        entries.remove(jreEntry);
        Optional<IVMInstall> vmInstall = jvmHelper.getLatestCompatibleVMInstall(supportedJVMRange);
        if (!vmInstall.isPresent()) {
            throw new CoreException(Status.error((String)"No JVM compatible with the selected Mule Runtime found"));
        }
        IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IVMInstall)vmInstall.get()), null, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"module", (String)"true")}, (boolean)false);
        entries.add(newContainerEntry);
    }

    public static void removeCached(IProject project) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (SafeCloseable readLock = projectsLock.lockForWriteLevel();){
            projects.remove(project);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void removeCached(String projectName) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ConvertibleReadWriteLock.UpgradingLock readLock = projectsLock.lockForReadLevel();){
            Optional<IProject> projectToRemove = projects.keySet().stream().filter(x -> x.getName().equals(projectName)).findFirst();
            projectToRemove.ifPresent(project -> {
                readLock.upgradeLockToWriteLevel();
                projects.remove(project);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<IProject> getAllProjectsInWorkspace() {
        return MuleRuntime.getProjectsThatMatchAndTransform(x -> true, Function.identity());
    }

    public static IMuleProject[] getMuleProjects() {
        List<IMuleProject> muleProjects = MuleRuntime.getProjectsThatMatchAndTransform(MuleRuntime::isProjectAccessibleAndHasMuleOrPolicyNature, MuleRuntime::create);
        return muleProjects.toArray(new IMuleProject[muleProjects.size()]);
    }

    public static List<IProject> getAllProjectsWithName(String name) {
        return MuleRuntime.getProjectsThatMatchAndTransform(project -> project.getName().equalsIgnoreCase(name), Function.identity());
    }

    private static boolean isProjectAccessibleAndHasMuleOrPolicyNature(IProject project) {
        boolean result = false;
        try {
            result = project.isAccessible() && project.hasNature("org.mule.tooling.core.muleStudioNature");
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem accessing a project" + project.getName() + " in " + project.getFullPath().toString(), e);
        }
        return result;
    }

    public static <U> List<U> getProjectsThatMatchAndTransform(Predicate<IProject> predicate, Function<IProject, U> function) {
        return Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()).stream().filter(predicate).map(function).collect(Collectors.toList());
    }

    public static <T extends IMuleProject> List<T> getMuleProjects(MuleProjectKind<T> kind) throws CoreException {
        return MuleRuntime.getMuleProjects(kind, Collections.emptyList());
    }

    private static <T extends IMuleProject> List<T> getMuleProjects(MuleProjectKind<T> kind, Collection<IProject> excluded) throws CoreException {
        IProject[] projects;
        ArrayList<T> results = new ArrayList<T>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            T muleProject;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && !excluded.contains(project) && kind.classifies(project) && (muleProject = MuleRuntime.create(project)) != null) {
                results.add(muleProject);
            }
            ++n2;
        }
        return results;
    }

    public static List<IMuleApplicationProject> getMuleApplicationProjects() throws CoreException {
        return MuleRuntime.getMuleProjects(MuleProjectKind.APPLICATION, Collections.emptyList());
    }

    public static List<IMuleApplicationProject> getMuleApplicationProjectsExcluding(IProject project) throws CoreException {
        return MuleRuntime.getMuleProjects(MuleProjectKind.APPLICATION, Collections.singleton(project));
    }

    public static boolean isInCache(IProject project) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ConvertibleReadWriteLock.UpgradingLock readLock = projectsLock.lockForReadLevel();){
            return projects.containsKey(project);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <V> V runLockingProjectsRegistry(Callable<V> callable, String projectName) throws Exception {
        initializingProjectNames.add(projectName);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            initializingProjectNames.remove(projectName);
        }
    }

    public static void addMuleNature(IProject project) throws CoreException {
        if (CoreUtils.hasMuleNature(project)) {
            return;
        }
        IProjectDescription description = project.getDescription();
        CoreUtils.addNaturesToProjectDescription(description, "org.mule.tooling.core.muleStudioNature");
        project.setDescription(description, null);
    }

    public static void initializeMuleAndDomainNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        CoreUtils.addNaturesToProjectDescription(description, "org.mule.tooling.core.muleStudioNature", "org.mule.tooling.core.muleStudioDomainNature");
        project.setDescription(description, null);
    }

    public static void runPostImportActions(IMuleProject muleProject, IProgressMonitor monitor) {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            ProjectLifecycleContributionManager lifecycleManager = ProjectLifecycleContributionManager.getInstance();
            List<ProjectLifecycleAction> postImportActions = lifecycleManager.getPostImportActions();
            submonitor.beginTask("Executing post import actions", -1);
            for (ProjectLifecycleAction postImportAction : postImportActions) {
                try {
                    postImportAction.execute(muleProject, (IProgressMonitor)submonitor.split(1000 / postImportActions.size()));
                }
                catch (Throwable t) {
                    MuleCorePlugin.logError("Error while executing ProjectLifecycleAction..." + postImportAction.getClass().toString(), t);
                }
            }
        }
        finally {
            submonitor.done();
        }
    }

    public static IMuleRoot getMuleRoot() throws CoreException {
        return new MuleRootImpl();
    }

    public static IMuleRoot getMuleAppRoot() throws CoreException {
        return new MuleAppRootImpl();
    }
}

