/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.PasswordProviderDescription;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.mule.tooling.core.BuildApplicationsOnWorkspaceChangesListener;
import org.mule.tooling.core.ComponentNotAvailableInContext;
import org.mule.tooling.core.JAXBContextHelper;
import org.mule.tooling.core.MuleCoreImages;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.QuestionDialog;
import org.mule.tooling.core.StudioDesignContext;
import org.mule.tooling.core.StudioDesignContextProvider;
import org.mule.tooling.core.WindowsDefenderChecker;
import org.mule.tooling.core.action.IPostAllProjectsInitializedAction;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.classloader.MuleClassLoaderCache;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.event.ClasspathEventsListener;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IErrorLoggedListener;
import org.mule.tooling.core.event.ThemeChangedEvent;
import org.mule.tooling.core.event.resource.ResourceEventPump;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.PomDefaultsHandlerManager;
import org.mule.tooling.core.m2.internal.GuavaModelCache;
import org.mule.tooling.core.m2.internal.IMavenModelReader;
import org.mule.tooling.core.m2.internal.MavenModelReader;
import org.mule.tooling.core.m2.internal.ServerPomDefaultsHandlerManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectComponentManager;
import org.mule.tooling.core.module.DefaultModuleContributionManagerSupplier;
import org.mule.tooling.core.module.FeaturedModulesInitializer;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.ModuleContributionManager;
import org.mule.tooling.core.module.ModuleContributionManagerSupplier;
import org.mule.tooling.core.module.internal.runner.ArtifactResolvingRunner;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.net.DefaultStudioProxyManager;
import org.mule.tooling.core.net.StudioProxyAuthenticator;
import org.mule.tooling.core.net.StudioProxyAwareConnectionManager;
import org.mule.tooling.core.net.StudioProxyManager;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;
import org.mule.tooling.core.runtime.JavaCoreClasspathContainerConfigurer;
import org.mule.tooling.core.runtime.Scheduler;
import org.mule.tooling.core.runtime.internal.ArtifactResolvingRunnerJobScheduler;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.MuleServerManager;
import org.mule.tooling.core.tooling.ToolingCacheExtension;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.core.tooling.ToolingClientBootstrap;
import org.mule.tooling.core.tooling.ToolingClientHelper;
import org.mule.tooling.core.tooling.ToolingRuntimeClientSupplier;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.core.utils.ExtensionModelLoader;
import org.mule.tooling.core.utils.JobUtils;
import org.mule.tooling.core.utils.ToolingClientExtensionModelLoader;
import org.mule.tooling.icons.IconsGenerator;
import org.mule.tooling.icons.SvgToPngConverter;
import org.mule.tooling.model.messageflow.ComponentIdGenerator;
import org.mule.tooling.model.messageflow.DefaultComponentIdGenerator;
import org.mule.tooling.osgi.services.analytics.IAnalyticsService;
import org.mule.tooling.utils.LazyValue;
import org.mule.tooling.utils.LoggingStatus;
import org.mule.tooling.utils.OsDetect;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.prefs.BackingStoreException;

public class MuleCorePlugin
implements BundleActivator {
    private static final String USE_TOOLING_CLIENT_EXTENSION_MODEL_CACHE = "org.mule.tooling.client.usecache";
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_CACHE_PATH = "tooling.client.ExtensionModelServiceCache.diskStore.path";
    private static final String FILTER_PARAMETERS_RESERVED_NAMES = "tooling.client.configuration.filter.parameters.reserved.names";
    public static final String EXTENSION_ID_POST_IMPORT_ACTION = "org.mule.tooling.core.postImportActions";
    public static final String EXTENSION_ID_POST_INITIALIZE_PROJECT_ACTION = "org.mule.tooling.core.postProjectInitActions";
    public static final String EXTENSION_ID_DEPLOYMENT_STRATEGIES = "org.mule.tooling.core.deploymentStrategies";
    public static final String EXTENSION_ID_CONTAINER_BEHAVIOR = "org.mule.tooling.core.containerBehavior";
    public static final String EXTENSION_ID_BUILDER = "org.mule.tooling.core.builder";
    public static final String EXTENSION_ID_CONTRIBUTION = "org.mule.tooling.core.contribution";
    public static final String EXTENSION_ID_CONTRIBUTION_SET = "org.mule.tooling.core.contributionset";
    public static final String EXTENSION_ID_CATEGORIES = "org.mule.tooling.module";
    public static final String EXTENSION_ID_CONTRIBUTION_HANDLER = "org.mule.tooling.core.contributionhandler";
    public static final String EXTENSION_ID_DOCUMENT_FACTORY = "org.mule.tooling.core.documentFactory";
    public static final String EXTENSION_ID_SERVERS = "org.mule.tooling.runtime";
    public static final String EXTENSION_ID_FEATURED_MODULES_INITIALIZER = "org.mule.tooling.core.featuredModulesInitializer";
    public static final String EXTENSION_ID_EVALUATOR = "org.mule.tooling.core.evaluator";
    private static final String POST_PROJECTS_INITIALIZED_EXTENSION_ID = "org.mule.tooling.core.postAllProjectsInitializedActions";
    private static final String POST_PROJECTS_INITIALIZED_EXTENSION_PROPERTY_NAME = "class";
    private static final String POST_PROJECTS_INITIALIZED_LOADING_CONTRIBUTION_ERROR = "Could not load the Post all projects initialized extension point contribution";
    private static final String PROBLEM_LOG_PREFIX = "There was a problem ";
    private static final String BLOCKLIST_DIRECTORY = "blocklist";
    private static final String BLOCK_LIST_FILENAME = "block.list";
    public static final String PLUGIN_ID = "org.mule.tooling.core";
    public static final String STUDIO_ROOT_CONTEXT = "org.mule.tooling.core.context";
    public static final String DEBUG = "/debug";
    public static final String MAVEN_REPO_POPULATE_ID = "/debug/maven-repo-populate";
    public static final String REPOSITORY_LISTENER_ID = "/debug/repository-listener";
    public static final String CLASSPATH_CONTAINER_ID = "/debug/classpath-container";
    public static final String CLASSPATH_CACHE_ID = "/debug/classpath-cache";
    public static final String MULE_PROJECT_ID = "/debug/mule-project";
    public static final String MULE_PROJECT_TRACE_ID = "/debug/mule-project-trace";
    private static final String EQUINOX_SECURITY_BUNDLE_ID = "org.eclipse.equinox.security";
    private static final String UI_PROMPT_PASSWORD_PROVIDER_ID = "org.eclipse.equinox.security.ui.defaultpasswordprovider";
    public static final String WINDOWS_DEFENDER_CHECK = "org.mule.tooling.core.windowsdefender";
    public static final String INIT_RUNTIMES_JOB_NAME = "Initializing runtimes";
    public static final String INIT_STUDIO_CONTEXT_INSTANCES_JOB_NAME = "Init studio context instances";
    private static final LazyValue<IEclipseContext> studioContext = new LazyValue(MuleCorePlugin::initStudioContext);
    private static MuleCorePlugin instance;
    private static BundleContext context;
    private static IAnalyticsService analyticsService;
    private static MuleCoreImages coreImages;
    private String activeThemeId = "";
    private final Set<String> blocklistedArtifacts = new HashSet<String>();
    private static StudioDesignContextProvider designContextProvider;
    private static boolean runningTests;
    private static AtomicBoolean isShuttingDown;
    private MuleClassLoaderCache muleClassloaderCache;
    private ResourceEventPump resourceEventPump;
    private final List<IPostAllProjectsInitializedAction> postProjectsInitActions = new ArrayList<IPostAllProjectsInitializedAction>();
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private DebugTrace tracer;
    private Job bootstrapInitializationJob;

    static {
        isShuttingDown = new AtomicBoolean(false);
        System.setProperty("mule.studio", "true");
        runningTests = Boolean.parseBoolean(System.getProperties().getProperty("studio.test"));
    }

    public MuleClassLoaderCache getMuleRuntimeClassloaderCache() {
        return this.muleClassloaderCache;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static MuleCorePlugin getInstance() {
        return instance;
    }

    public static ScopedPreferenceStore getScopedPreferenceStore() {
        return ScopedPreferenceStoreHolder.getStore();
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        instance = this;
        this.registerDebugOptionsListener(context);
        if (!MuleCorePlugin.runningTests()) {
            this.checkWindowsDefenderStatus();
        }
        this.initializeJAXBContextHelper();
        this.scheduleInitDependencies();
        this.setM2RepoVariable();
        this.setupToolingClient();
        if (!MuleCorePlugin.runningTests()) {
            this.scheduleInitializeDefaultExtensionsJob();
            this.scheduleToolingBootstrapInitialization();
        }
        this.muleClassloaderCache = new MuleClassLoaderCache();
        this.initializeBlocklistedArtifacts(bundleContext);
        MuleClassLoaderUtils.init();
        MavenResourceUtils.getEmptySettingsFile();
        this.collectPostProjectsInitActions();
        this.initializeMuleProjects();
        this.addThemeChangerListener();
        JavaCore.addElementChangedListener((IElementChangedListener)new ClasspathEventsListener());
        this.resourceEventPump = new ResourceEventPump(MuleCorePlugin.getEventBus());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceEventPump);
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new BuildApplicationsOnWorkspaceChangesListener());
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new DomainUtils.DomainExtensionsValidator());
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.DOMAIN_CHANGED, (IEventHandler)new DomainUtils.DomainResolutionValidator());
    }

    private void checkWindowsDefenderStatus() {
        IEclipsePreferences preferences;
        boolean checked;
        if (OsDetect.isWindows() && !(checked = (preferences = InstanceScope.INSTANCE.getNode(WINDOWS_DEFENDER_CHECK)).getBoolean(WINDOWS_DEFENDER_CHECK, false))) {
            Job checkWD = Job.createSystem((String)"Check Windows Defender Status", monitor -> {
                try {
                    if (WindowsDefenderChecker.isWindowsDefenderActive().booleanValue()) {
                        List<java.nio.file.Path> paths = WindowsDefenderChecker.getStudioImportanPaths();
                        String folders = StringUtils.join(paths, (String)"\n");
                        QuestionDialog dialog = QuestionDialog.show("Windows Defender exclusions", "Your performance could be affected by Windows Defender real time scanning. Do you wish to exclude the following items? \n\nFolders:\n" + folders + "\nProcesses:\nAnypointStudio.exe\n\nNOTE: Administrator privileges are needed.", "Remember my decision", null, null);
                        boolean doit = dialog.getStatus();
                        if (doit) {
                            WindowsDefenderChecker.runExcludePathsCommand();
                            WindowsDefenderChecker.runExcludeProcessCommand();
                        }
                        if (doit || dialog.getToggleState()) {
                            preferences.putBoolean(WINDOWS_DEFENDER_CHECK, true);
                            try {
                                preferences.flush();
                            }
                            catch (BackingStoreException e) {
                                MuleCorePlugin.logError("Failed to save the Windows Defender information to the configuration preference", e);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    MuleCorePlugin.logError("Windows Defender information couldn't be retrieved", e);
                }
            });
            checkWD.setPriority(20);
            checkWD.schedule();
        }
    }

    private void collectPostProjectsInitActions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(POST_PROJECTS_INITIALIZED_EXTENSION_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    IPostAllProjectsInitializedAction behaviorImpl = (IPostAllProjectsInitializedAction)IPostAllProjectsInitializedAction.class.cast(configurationElement.createExecutableExtension(POST_PROJECTS_INITIALIZED_EXTENSION_PROPERTY_NAME));
                    this.postProjectsInitActions.add(behaviorImpl);
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError(POST_PROJECTS_INITIALIZED_LOADING_CONTRIBUTION_ERROR, e);
                }
                ++n2;
            }
        }
    }

    private void initializeMuleProjects() {
        JobGroup jobGroup = JobUtils.createJobGroup("Project initialization", 4);
        Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(IResource::isAccessible).map(project -> Job.create((String)("Initializing project " + project.getName()), monitor -> {
            Object t = MuleRuntime.create(project);
        })).peek(job -> job.setJobGroup(jobGroup)).forEach(Job::schedule);
        if (!this.isUIPromptSecureStoragePasswordProviderBeingUsed()) {
            Job.getJobManager().resume();
        }
        JobUtils.waitUntilJobGroupEnds(jobGroup, 0L, () -> {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
            this.postProjectsInitActions.forEach(IPostAllProjectsInitializedAction::execute);
        });
    }

    private boolean isUIPromptSecureStoragePasswordProviderBeingUsed() {
        Set<String> disabledPasswordProviders = this.getDisabledModules();
        if (disabledPasswordProviders == null) {
            return false;
        }
        List passwordProviders = InternalExchangeUtils.passwordProvidersFind();
        List activePasswordProviders = passwordProviders.stream().filter(provider -> !disabledPasswordProviders.contains(provider.getId())).collect(Collectors.toList());
        return !activePasswordProviders.isEmpty() && UI_PROMPT_PASSWORD_PROVIDER_ID.equals(((PasswordProviderDescription)activePasswordProviders.get(0)).getId());
    }

    private Set<String> getDisabledModules() {
        IScopeContext[] scopes = new IScopeContext[]{ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        IPreferencesService preferencesService = Platform.getPreferencesService();
        String defaultPreferenceValue = "";
        String tmp = preferencesService.getString(EQUINOX_SECURITY_BUNDLE_ID, "org.eclipse.equinox.security.preferences.disabledProviders", defaultPreferenceValue, scopes);
        Set<String> disabledModules = this.splitModuleIds(tmp);
        return disabledModules;
    }

    private Set<String> splitModuleIds(String joinedModuleIds) {
        String[] disabledProviders;
        if (joinedModuleIds == null || joinedModuleIds.isEmpty()) {
            return null;
        }
        HashSet<String> modules = new HashSet<String>();
        String[] stringArray = disabledProviders = joinedModuleIds.split(",");
        int n = disabledProviders.length;
        int n2 = 0;
        while (n2 < n) {
            String disabledProvider = stringArray[n2];
            modules.add(disabledProvider);
            ++n2;
        }
        return modules;
    }

    private void initializeJAXBContextHelper() {
        JobUtils.schedule("Initializing XML/Java binding", monitor -> JAXBContextHelper.getInstance(), 0L, job -> {
            job.setSystem(true);
            job.setPriority(10);
        });
    }

    private void scheduleToolingBootstrapInitialization() {
        this.bootstrapInitializationJob = Job.createSystem((String)"Tooling Bootstrap Initialization", monitor -> {
            IServerDefinition defaultServer = MuleCorePlugin.getServerManager().getServerDefinition(CoreUtils.getDefaultServerRuntimeId());
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ToolingClientBootstrap.buildToolingBootstrap(defaultServer.getVersionWithSuffix());
        });
        this.bootstrapInitializationJob.setPriority(30);
        this.bootstrapInitializationJob.schedule();
    }

    private void setupToolingClient() {
        this.setToolingClientCache();
        this.setToolingClientFiltering();
    }

    private void setToolingClientCache() {
        boolean useToolingClientCache = Boolean.getBoolean(USE_TOOLING_CLIENT_EXTENSION_MODEL_CACHE);
        if (useToolingClientCache) {
            String defaultCachePath = this.getDefaultExtensionModelsCachePath().toFile().getAbsolutePath();
            String extensionModelCachePath = System.getProperties().getProperty(TOOLING_CLIENT_EXTENSION_MODEL_CACHE_PATH, defaultCachePath);
            System.getProperties().put(TOOLING_CLIENT_EXTENSION_MODEL_CACHE_PATH, extensionModelCachePath);
            this.populateToolingClientCache(extensionModelCachePath);
        } else {
            System.getProperties().remove(TOOLING_CLIENT_EXTENSION_MODEL_CACHE_PATH);
        }
    }

    private void setToolingClientFiltering() {
        String filterParametersReserveNames = System.getProperty(FILTER_PARAMETERS_RESERVED_NAMES, "false");
        System.setProperty(FILTER_PARAMETERS_RESERVED_NAMES, filterParametersReserveNames);
    }

    private IPath getDefaultExtensionModelsCachePath() {
        return ToolingCachePathUtils.getCachePath();
    }

    private void populateToolingClientCache(String extensionModelCachePath) {
        try {
            File toolingCache = new File(extensionModelCachePath);
            ToolingCacheExtension.getExtensions().forEach(x -> x.installInto(toolingCache));
        }
        catch (Exception ex) {
            MuleCorePlugin.logWarning("Unexpected error while copying tooling cache. This will not affect studio functionality but it may take longer to start the first time.", ex);
        }
    }

    private void scheduleInitDependencies() {
        Job initDependenciesJob = new Job(INIT_STUDIO_CONTEXT_INSTANCES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                MuleCorePlugin.getStudioContext();
                return Status.OK_STATUS;
            }
        };
        initDependenciesJob.setSystem(true);
        initDependenciesJob.setUser(false);
        initDependenciesJob.setPriority(20);
        initDependenciesJob.schedule();
    }

    public static boolean runningTests() {
        return runningTests;
    }

    private void scheduleInitializeDefaultExtensionsJob() {
        final ArrayList serverDefinitions = new ArrayList();
        Job initRuntimesJob = new Job(INIT_RUNTIMES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                serverDefinitions.addAll(MuleCorePlugin.getServerManager().getServerDefinitions());
                return Status.OK_STATUS;
            }
        };
        initRuntimesJob.setUser(false);
        initRuntimesJob.setPriority(30);
        initRuntimesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IModuleContributionManager contributionManager = ModuleContributionManager.getInstance();
                FeaturedModulesInitializer featuredModulesInitializer = MuleCorePlugin.this.createFeaturedModulesInitializer();
                serverDefinitions.forEach(serverDefinition -> MuleCorePlugin.this.scheduleFeaturedModulesLoad(featuredModulesInitializer, (IServerDefinition)serverDefinition, contributionManager));
            }
        });
        initRuntimesJob.schedule();
    }

    private void scheduleFeaturedModulesLoad(final FeaturedModulesInitializer featuredModulesInitializer, final IServerDefinition serverDefinition, final IModuleContributionManager contributionManager) {
        Job initJob = new Job("Loading modules for " + serverDefinition.getLabel()){

            protected IStatus run(IProgressMonitor monitor) {
                featuredModulesInitializer.loadModulesFor(serverDefinition, contributionManager, monitor);
                return Status.OK_STATUS;
            }
        };
        initJob.setUser(false);
        initJob.setPriority(30);
        initJob.schedule();
    }

    private FeaturedModulesInitializer createFeaturedModulesInitializer() {
        List<FeaturedModulesInitializer> moduleHandlerFactory = CoreUtils.getExtensionPointObjects(EXTENSION_ID_FEATURED_MODULES_INITIALIZER, FeaturedModulesInitializer.class);
        if (moduleHandlerFactory != null && !moduleHandlerFactory.isEmpty()) {
            return moduleHandlerFactory.get(0);
        }
        throw new IllegalStateException(String.format("Couldn't find any [%s] modules to load", EXTENSION_ID_FEATURED_MODULES_INITIALIZER));
    }

    private void addThemeChangerListener() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged");
        context.registerService(EventHandler.class, (Object)new EventHandler(){

            public void handleEvent(Event event) {
                Theme theme = (Theme)event.getProperty("theme");
                AnalyticsRecordsFactory.single(Events.CHANGE_THEME, "themeName", theme.getLabel()).track();
                String currentTheme = theme.getId();
                if (!MuleCorePlugin.this.activeThemeId.equals(currentTheme)) {
                    EventBus eventBus = UtilsPlugin.getEventBus();
                    ThemeChangedEvent themeChangedEvent = new ThemeChangedEvent();
                    eventBus.fireEvent((IEvent)themeChangedEvent);
                    MuleCorePlugin.this.activeThemeId = currentTheme;
                }
            }
        }, properties);
    }

    public void registerDebugOptionsListener(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("listener.symbolic.name", PLUGIN_ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)new DebugOptionsListener(){

            public void optionsChanged(DebugOptions options) {
                MuleCorePlugin.this.tracer = options.newDebugTrace(MuleCorePlugin.PLUGIN_ID);
            }
        }, properties);
    }

    public void unregisterDebugOptionsListener() {
        this.debugRegistration.unregister();
        this.debugRegistration = null;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        isShuttingDown.set(true);
        if (this.bootstrapInitializationJob != null) {
            SafeRunner.run(() -> {
                this.bootstrapInitializationJob.cancel();
                this.bootstrapInitializationJob.join(3000L, (IProgressMonitor)new NullProgressMonitor());
            });
        }
        this.unregisterDebugOptionsListener();
        context = null;
        MuleProjectComponentManager.retrieveIfActive().ifPresent(MuleProjectComponentManager::stop);
        ToolingClientBootstrap.dispose();
    }

    private void setM2RepoVariable() {
        String m2RepoEnvVar = System.getenv("M2_REPO");
        File m2Repo = null;
        IPath m2RepoClasspathVariable = JavaCore.getClasspathVariable((String)"M2_REPO");
        if (m2RepoClasspathVariable != null) {
            return;
        }
        if (m2RepoEnvVar != null) {
            m2Repo = new File(m2RepoEnvVar);
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                MuleCorePlugin.logWarning("'user.home' property is not set. M2_REPO variable won't be set");
                return;
            }
            File possibleM2Repo = new File(userHome, ".m2" + File.separator + "repository");
            if (possibleM2Repo.exists() && possibleM2Repo.isDirectory()) {
                m2Repo = possibleM2Repo;
            } else {
                MuleCorePlugin.logWarning(possibleM2Repo.getPath() + " does not exist or contain a maven repository");
                return;
            }
        }
        try {
            String path = m2Repo.getPath();
            MuleCorePlugin.logInfo("Configuring M2_REPO variable with value: " + path);
            JavaCore.setClasspathVariable((String)"M2_REPO", (IPath)new Path(path), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            MuleCorePlugin.logError("Setting M2_REPO variable in workspace failed.", e);
        }
    }

    public static void logError(String message, Throwable t) {
        MuleCorePlugin.getLog().log(MuleCorePlugin.createLoggingStatus(4, message, t));
    }

    public static void logProblem(String problem, Throwable t) {
        MuleCorePlugin.logError(PROBLEM_LOG_PREFIX + problem, t);
    }

    public static void logErrorAndShowErrorSense(final String message, final Throwable t) {
        MuleCorePlugin.logError(message, t);
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new IEvent<IErrorLoggedListener>(){

            public EventType<IErrorLoggedListener> getAssociatedType() {
                return CoreEventTypes.ON_ERROR_LOGGED;
            }

            public void dispatch(IErrorLoggedListener handler) {
                handler.onErrorLogged(message, t);
            }
        });
    }

    public static void logWarning(String message, Throwable t) {
        MuleCorePlugin.getLog().log(MuleCorePlugin.createLoggingStatus(2, message, t));
    }

    public static void logWarning(String message) {
        MuleCorePlugin.getLog().log(MuleCorePlugin.createLoggingStatus(2, message, null));
    }

    public static void logInfo(String message) {
        MuleCorePlugin.getLog().log(MuleCorePlugin.createLoggingStatus(1, message, null));
    }

    public static void logError(String message) {
        MuleCorePlugin.getLog().log(MuleCorePlugin.createLoggingStatus(4, message, null));
    }

    public static void logError(int code, String message, Throwable throwable) {
        IStatus status = MuleCorePlugin.createLoggingStatus(4, code, message, throwable);
        MuleCorePlugin.getLog().log(status);
        IStatusHandler buildHandler = DebugPlugin.getDefault().getStatusHandler(status);
        try {
            buildHandler.handleStatus(status, null);
        }
        catch (CoreException coreException) {}
    }

    private static IStatus createLoggingStatus(int type, String message, Throwable t) {
        return new LoggingStatus(type, PLUGIN_ID, message, t);
    }

    private static IStatus createLoggingStatus(int type, int code, String message, Throwable throwable) {
        return new LoggingStatus(type, PLUGIN_ID, code, message, throwable);
    }

    public static IStatus createStatus(int type, String message, Throwable throwable) {
        return new LoggingStatus(type, PLUGIN_ID, message, throwable);
    }

    public static void openError(Shell shell, String title, String message) {
        MessageDialog.open((int)1, (Shell)shell, (String)title, (String)message, (int)0);
    }

    public static ILog getLog() {
        return Optional.ofNullable(context).map(ctx -> Platform.getLog((Bundle)ctx.getBundle())).orElseGet(() -> STDLog.logger);
    }

    public static IMuleModuleManager getModuleManager() {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        if (muleProject == null) {
            throw new ComponentNotAvailableInContext("Mule project is null in design context");
        }
        return muleProject.getModuleManager();
    }

    public static MuleServerManager getServerManager() {
        return MuleServerManager.instance();
    }

    public static IEclipseContext getStudioContext() {
        return (IEclipseContext)studioContext.getOrCompute();
    }

    public static <T> Optional<T> getContextValue(Class<T> clazz) {
        if (!isShuttingDown.get()) {
            return Optional.ofNullable(MuleCorePlugin.getStudioContext().get(clazz));
        }
        return Optional.empty();
    }

    public static <T> T requireContextValue(Class<T> clazz) {
        return MuleCorePlugin.getContextValue(clazz).orElseThrow(() -> new IllegalStateException("No instance available for " + clazz.getCanonicalName()));
    }

    private static IEclipseContext initStudioContext() {
        IEclipseContext context = EclipseContextFactory.createServiceContext((BundleContext)MuleCorePlugin.getContext());
        MuleCorePlugin.initializeDependencies(context);
        return context;
    }

    public static File getPersistenceRoot() {
        return MuleCorePlugin.getContext().getDataFile("");
    }

    public static MuleCoreImages getCoreImages() {
        if (coreImages == null) {
            coreImages = new MuleCoreImages(MuleCorePlugin.getContext());
        }
        return coreImages;
    }

    public static EventBus getEventBus() {
        return UtilsPlugin.getEventBus();
    }

    public static StudioDesignContext getDesignContext() {
        return MuleCorePlugin.getContextProvider().getContext();
    }

    public static StudioDesignContext getDefaultDesignContext() {
        return MuleCorePlugin.getContextProvider().getDefaultContext();
    }

    public static StudioDesignContext createLocalThreadDesignContext(IMuleProject muleProject, EditingScope editingScope) {
        return MuleCorePlugin.getContextProvider().createLocalThread(muleProject, editingScope);
    }

    static StudioDesignContextProvider getContextProvider() {
        if (designContextProvider == null) {
            designContextProvider = new StudioDesignContextProvider();
        }
        return designContextProvider;
    }

    private void initializeBlocklistedArtifacts(BundleContext context) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream input = this.getClass().getResourceAsStream("/blocklist/block.list");){
                if (input != null) {
                    List lines = IOUtils.readLines((InputStream)input);
                    for (Object lineObj : lines) {
                        String line = ((String)lineObj).trim();
                        if (!StringUtils.isNotBlank((String)line) || line.startsWith("#")) continue;
                        this.blocklistedArtifacts.add(line);
                    }
                } else {
                    MuleCorePlugin.logWarning("Could not find block list file: /blocklist/block.list", null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            MuleCorePlugin.logError("Cannot access bundle " + (context.getBundle() != null ? context.getBundle().getSymbolicName() : "<not available>") + " to retrieve block list file /blocklist/block.list", t);
        }
    }

    public Set<String> getBlocklistedArtifacts() {
        return this.blocklistedArtifacts;
    }

    public static IAnalyticsService getAnalyticsService() {
        if (analyticsService == null) {
            if (context != null) {
                ServiceReference serviceReference = context.getServiceReference(IAnalyticsService.class.getName());
                if (serviceReference != null) {
                    analyticsService = (IAnalyticsService)context.getService(serviceReference);
                }
            } else {
                throw new IllegalStateException("Cannot request IAnalyticsService before plugin was started or after it was disposed.");
            }
        }
        return analyticsService;
    }

    public static IAnalyticsService setAnalyticsService(IAnalyticsService newService) {
        IAnalyticsService previousValue = analyticsService;
        analyticsService = newService;
        return previousValue;
    }

    private static void initializeDependencies(IEclipseContext context) {
        EclipseContextHelper helper = EclipseContextHelper.createHelper(context);
        helper.configureInstance(EventBus.class, MuleCorePlugin.getEventBus());
        helper.configureInstance(ClasspathContainerConfigurer.class, new JavaCoreClasspathContainerConfigurer());
        helper.configureInstance(StudioProxyManager.class, (StudioProxyManager)helper.create(DefaultStudioProxyManager.class));
        helper.configureInstance(ConnectionManager.class, (ConnectionManager)helper.create(StudioProxyAwareConnectionManager.class));
        helper.configureInstance(Authenticator.class, (Authenticator)helper.create(StudioProxyAuthenticator.class));
        helper.configureInstance(ComponentIdGenerator.class, new DefaultComponentIdGenerator());
        helper.configureInstance(Scheduler.class, ArtifactResolvingRunnerJobScheduler.getInstance());
        helper.configureInstance(IArtifactResolvingRunner.class, ArtifactResolvingRunner.instance());
        helper.configureInstance(IMavenModelReader.class, new MavenModelReader(new GuavaModelCache()));
        helper.configureInstance(PomDefaultsHandlerManager.class, new ServerPomDefaultsHandlerManager());
        helper.configureInstance(ModuleContributionManagerSupplier.class, new DefaultModuleContributionManagerSupplier(ModuleContributionManager::getInstance));
        helper.configureInstance(IconsGenerator.class, SvgToPngConverter.newSvgToPngConverter());
        helper.configureInstance(LoginManager.class, helper.create(LoginManager.class));
        helper.configureInstance(ToolingRuntimeClientSupplier.class, ToolingClientHelper.getInstance());
        helper.configureInstance(ExtensionModelLoader.class, new ToolingClientExtensionModelLoader());
    }

    public static File getDataFile(String path) {
        return context.getDataFile(path);
    }

    public static IModuleContributionManager getModuleContributionManager() {
        return MuleCorePlugin.requireContextValue(ModuleContributionManagerSupplier.class).get();
    }

    public ResourceEventPump getResourceEventPump() {
        return this.resourceEventPump;
    }

    public static DebugTrace debugTracer() {
        return MuleCorePlugin.getInstance().tracer;
    }

    private static class STDLog
    implements ILog {
        private static ILog logger = new STDLog();

        private STDLog() {
        }

        public void addLogListener(ILogListener listener) {
        }

        public Bundle getBundle() {
            return this.getBundle();
        }

        public void log(IStatus status) {
            System.err.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }

        public void removeLogListener(ILogListener listener) {
        }
    }

    private static class ScopedPreferenceStoreHolder {
        private static ScopedPreferenceStore mavenPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.mule.tooling.core");

        static {
            new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.mule.tooling.maven.ui").getPreferenceNodes(true);
        }

        private ScopedPreferenceStoreHolder() {
        }

        private static ScopedPreferenceStore getStore() {
            return mavenPreferences;
        }
    }
}

