/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class ModelUtils {
    public static boolean isFlowOrSubflow(IMessageFlowEntity entity) {
        return ModelUtils.isFlow(entity) || ModelUtils.isSubflow(entity);
    }

    public static boolean isFlow(IMessageFlowEntity entity) {
        if (!(entity instanceof Container)) {
            return false;
        }
        Container container = (Container)entity;
        boolean isFlow = "http://www.mulesoft.org/schema/mule/core/flow".equals(container.getType());
        return isFlow;
    }

    public static boolean isSubflow(IMessageFlowEntity entity) {
        if (!(entity instanceof Container)) {
            return false;
        }
        Container container = (Container)entity;
        return "http://www.mulesoft.org/schema/mule/core/sub-flow".equals(container.getType());
    }

    public static boolean isTest(IMessageFlowEntity entity) {
        if (!(entity instanceof Container)) {
            return false;
        }
        Container container = (Container)entity;
        return "http://www.mulesoft.org/schema/mule/munit/test".equals(container.getType());
    }

    public static boolean isErrorHandler(IMessageFlowEntity entity) {
        if (!(entity instanceof Container)) {
            return false;
        }
        Container container = (Container)entity;
        return "http://www.mulesoft.org/schema/mule/core/default-error-handler".equals(container.getType());
    }

    public static boolean isBatch(IMessageFlowEntity entity) {
        if (!(entity instanceof Container)) {
            return false;
        }
        Container container = (Container)entity;
        return "http://www.mulesoft.org/schema/mule/batch/job".equals(container.getType());
    }

    public static boolean isBatchStep(IMessageFlowEntity entity) {
        if (!(entity instanceof Container)) {
            return false;
        }
        Container container = (Container)entity;
        return "http://www.mulesoft.org/schema/mule/batch/step".equals(container.getType());
    }

    public static boolean isMessageSource(IMessageFlowEntity entity) {
        return MessageSourceChecker.isMessageSource(entity);
    }

    public static boolean isMessageSource(NodeDefinition nodeDefinition) {
        return MessageSourceDefinitionChecker.isMessageSource(nodeDefinition);
    }

    public static boolean isFlowInput(NestedContainer container) {
        return container.getType().equals("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
    }

    public static boolean isAll(IMessageFlowEntity entity) {
        if (entity instanceof SplitterNode) {
            SplitterNode scope = (SplitterNode)entity;
            String type = scope.getType();
            return "http://www.mulesoft.org/schema/mule/core/all".equals(type) || "org.mule.tooling.ui.modules.core.pattern.all".equals(type);
        }
        return false;
    }

    public static boolean isIndboundEndpoint(IMessageFlowEntity entity) {
        return entity instanceof EndpointNode && ((EndpointNode)entity).getDirection() == EndpointDirection.INBOUND;
    }

    public static boolean isAsyncScope(EntityDecorator<?> decorator) {
        Container scope;
        return decorator != null && decorator.getEntity() instanceof Container && (scope = (Container)decorator.getEntity()).getType().equals("http://www.mulesoft.org/schema/mule/core/async");
    }

    public static boolean isUnknownNode(IMessageFlowEntity messageFlowEntity) {
        return messageFlowEntity instanceof UnknownNode;
    }

    public static boolean isComment(IMessageFlowEntity messageFlowEntity) {
        return messageFlowEntity instanceof CommentContainer;
    }

    public static boolean isCommentStandalone(IMessageFlowEntity messageFlowEntity) {
        if (!ModelUtils.isComment(messageFlowEntity)) {
            return false;
        }
        CommentContainer commentContainer = (CommentContainer)messageFlowEntity;
        return commentContainer.isStandalone();
    }

    public static boolean isGlobalUnknown(IMessageFlowEntity messageFlowEntity) {
        return messageFlowEntity instanceof GlobalUnknown;
    }

    public static boolean isGlobalElement(IMessageFlowEntity messageFlowEntity) {
        return messageFlowEntity instanceof GlobalElement;
    }

    public static boolean isTryScope(NodeDefinition definition) {
        return definition.getId().equals("http://www.mulesoft.org/schema/mule/core/try");
    }

    public static boolean isTryScope(IMessageFlowNode node) {
        return "http://www.mulesoft.org/schema/mule/core/try".equals(node.getType());
    }

    public static boolean isFlowRef(IMessageFlowNode node) {
        return "http://www.mulesoft.org/schema/mule/core/flow-ref".equals(node.getType());
    }

    public static boolean isErrorMapping(NodeDefinition definition) {
        return "http://www.mulesoft.org/schema/mule/core/error-mapping".equals(definition.getId());
    }

    public static boolean isOnError(NodeDefinition definition) {
        return "http://www.mulesoft.org/schema/mule/core/abstract-on-error".equals(definition.getExtendsDefinition());
    }

    public static boolean isOnError(IMessageFlowNode node) {
        NodeDefinition definition = node.getDefinition();
        if (definition != null) {
            return "http://www.mulesoft.org/schema/mule/core/abstract-on-error".equals(definition.getExtendsDefinition());
        }
        return false;
    }

    public static boolean isErrorHandler(NodeDefinition definition) {
        return "http://www.mulesoft.org/schema/mule/core/error-handler".equals(definition.getId());
    }

    public static boolean isDefaultErrorHandler(NodeDefinition definition) {
        return "http://www.mulesoft.org/schema/mule/core/default-error-handler".equals(definition.getId());
    }

    public static boolean isDefaultErrorHandler(Container container) {
        return "http://www.mulesoft.org/schema/mule/core/default-error-handler".equals(container.getType());
    }

    public static boolean isScheduler(IMessageFlowEntity entity) {
        if (entity instanceof MessageFlowNode) {
            MessageFlowNode node = (MessageFlowNode)entity;
            return "http://www.mulesoft.org/schema/mule/core/scheduler".equals(node.getType());
        }
        return false;
    }

    public static boolean isRoute(IMessageFlowEntity node) {
        return node instanceof Route;
    }

    public static boolean isMuleConfiguration(IMessageFlowEntity entity) {
        return entity instanceof MuleConfiguration;
    }

    public static class MessageSourceChecker
    extends MessageFlowEntityVisitorAdapter {
        private boolean isMessageSource = false;

        private MessageSourceChecker() {
        }

        @Override
        public void visitEndpointNode(EndpointNode endpointNode) {
            this.isMessageSource = endpointNode.isInbound();
        }

        @Override
        public void visitContainer(Container container) {
            this.isMessageSource = false;
        }

        public static boolean isMessageSource(IMessageFlowEntity entity) {
            MessageSourceChecker checker = new MessageSourceChecker();
            entity.accept(checker);
            return checker.isMessageSource;
        }
    }

    public static class MessageSourceDefinitionChecker
    extends NodeDefinitionVisitorAdapter {
        private boolean isMessageSource = false;

        @Override
        public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
            this.isMessageSource = endpointDefinition.isSupportsInbound();
        }

        @Override
        public void visitContainerDefinition(ContainerDefinition containerDefinition) {
            this.isMessageSource = false;
        }

        public static boolean isMessageSource(NodeDefinition entity) {
            MessageSourceDefinitionChecker checker = new MessageSourceDefinitionChecker();
            entity.accept(checker);
            return checker.isMessageSource;
        }
    }
}

