/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.icons.ImageUtils;
import org.mule.tooling.icons.ImagesManager;

public class IconsLocator {
    private static final String CONNECTOR_PREFIX = "connector:";

    public static URL getImageURL(String iconPath) {
        URL imageURLFrom = ImageUtils.getImageURLFrom((String)iconPath);
        if (imageURLFrom == null && iconPath != null && iconPath.startsWith(CONNECTOR_PREFIX)) {
            Path imagePath = IconsLocator.resolvePath(iconPath);
            try {
                imageURLFrom = imagePath.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return imageURLFrom;
    }

    private static Path resolvePath(String iconPath) {
        String[] parts = iconPath.replace("connector:/", "").split("/");
        String[] gav = parts[0].split(":");
        String repositoryPath = MavenResourceUtils.getRepositoryPath(((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(gav[0])).withArtifactId(gav[1])).withVersion(gav[2])).build(), File.separator);
        Path jarLocation = ToolingCachePathUtils.getEditorsCachePath().toFile().toPath().resolve(repositoryPath);
        Path imagePath = jarLocation.getParent().resolve(parts[1]);
        return imagePath;
    }

    public static ImageDescriptor getDescriptor(String iconPath) {
        if (StringUtils.isBlank((CharSequence)iconPath)) {
            return null;
        }
        if (ImageUtils.hasCustomStudioImage((String)iconPath)) {
            URL imageURLFrom = ImageUtils.getImageURLFrom((String)iconPath);
            ImagesManager.getInstance().register(iconPath, imageURLFrom);
        } else if (iconPath.startsWith(CONNECTOR_PREFIX)) {
            Path imagePath = IconsLocator.resolvePath(iconPath);
            try {
                URL imageURL = imagePath.toUri().toURL();
                if (new File(imageURL.toURI()).exists()) {
                    ImagesManager.getInstance().register(iconPath, imageURL);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return ImagesManager.getInstance().getImageDescriptor(iconPath);
    }

    public static Image getImage(String iconPath) {
        IconsLocator.getDescriptor(iconPath);
        return ImagesManager.getInstance().getImage(iconPath);
    }
}

