/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;

public class BuildApplicationsOnWorkspaceChangesListener
implements IMuleProjectEventListener {
    @Override
    public void onMuleProjectOpened(IProject project) {
        try {
            if (MuleProjectKind.DOMAIN.classifies(project)) {
                IMuleDomainProject domainProject = MuleProjectKind.DOMAIN.adapt(project);
                this.cleanBuildApplications(domainProject.getChildProjects());
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem building projects", e);
        }
    }

    @Override
    public void onMuleProjectClosed(IProject project) {
        try {
            this.cleanBuildApplications(MuleRuntime.getMuleApplicationProjectsExcluding(project));
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem building projects", e);
        }
    }

    private void cleanBuildApplications(final List<? extends IMuleProject> muleProjects) {
        if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
            WorkspaceJob buildWorkspaceJob = new WorkspaceJob("Building workspace"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    BuildApplicationsOnWorkspaceChangesListener.this.doCleanBuildApplications(muleProjects);
                    return Status.OK_STATUS;
                }
            };
            buildWorkspaceJob.schedule();
        } else {
            this.doCleanBuildApplications(muleProjects);
        }
    }

    private void doCleanBuildApplications(List<? extends IMuleProject> muleProjects) {
        try {
            for (IMuleProject iMuleProject : muleProjects) {
                CoreUtils.cleanBuildProject(iMuleProject);
            }
        }
        catch (CoreException coreException) {
            MuleCorePlugin.logError("There was a problem building projects", coreException);
        }
    }
}

