/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.listenable;

import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionList
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionList.class);
    private final Queue<RunnableExecutorPair> runnables = new LinkedBlockingQueue<RunnableExecutorPair>();
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable runnable, Executor executor) {
        if (runnable == null) {
            throw new NullPointerException("Runnable is null");
        }
        if (executor == null) {
            throw new NullPointerException("Executor is null");
        }
        boolean executeImmediate = false;
        Queue<RunnableExecutorPair> queue = this.runnables;
        synchronized (queue) {
            if (!this.executed) {
                this.runnables.add(new RunnableExecutorPair(runnable, executor));
            } else {
                executeImmediate = true;
            }
        }
        if (executeImmediate) {
            executor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Queue<RunnableExecutorPair> queue = this.runnables;
        synchronized (queue) {
            this.executed = true;
        }
        while (!this.runnables.isEmpty()) {
            this.runnables.poll().execute();
        }
    }

    private static class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;

        RunnableExecutorPair(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        void execute() {
            try {
                this.executor.execute(this.runnable);
            }
            catch (RuntimeException e) {
                LOGGER.error("RuntimeException while executing runnable {} with executor {}", new Object[]{this.runnable, this.executor, e});
            }
        }
    }
}

