/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.extension;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.ExtensionService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.extensions.service")
@Singleton
public class MuleAgentExtensionService
extends ConfigurableAgentService
implements ExtensionService,
DeploymentServiceAware {
    private DeploymentService deploymentService;
    private ExtensionModelJsonSerializer jsonSerializer = new ExtensionModelJsonSerializer(true);

    public List<ExtensionModel> getExtensionModels(String appName) {
        return (List)this.withExtensionManager(appName, manager -> ImmutableList.copyOf((Collection)manager.getExtensions()));
    }

    public Optional<ExtensionModel> getExtensionModel(String appName, String extensionName) {
        return (Optional)this.withExtensionManager(appName, manager -> manager.getExtension(extensionName).map(model -> model));
    }

    public String toJson(ExtensionModel extensionModel) {
        return this.jsonSerializer.serialize(extensionModel);
    }

    public String toJson(List<ExtensionModel> extensionModels) {
        return this.jsonSerializer.serializeList(extensionModels);
    }

    private ExtensionManager getExtensionManager(String appName, Application application) {
        try {
            return (ExtensionManager)application.getRegistry().lookupByType(ExtensionManager.class).get();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not obtain extension manager for application '%s'", appName), e);
        }
    }

    private <T> T withExtensionManager(String appName, Function<ExtensionManager, T> closure) {
        Application application = this.findApplication(appName);
        return (T)closure.apply((Object)this.getExtensionManager(appName, application));
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return ImmutableList.of();
    }

    private Application findApplication(String appName) throws NoSuchApplicationException {
        Application application = this.deploymentService.findApplication(appName);
        if (application == null) {
            throw new NoSuchApplicationException(String.format("Application '%s' could not be found", appName));
        }
        return application;
    }
}

