/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.discoverer;

import com.mulesoft.mule.runtime.plugin.discoverer.PluginDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptorFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.deployment.internal.util.zip.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPluginDiscoverer
implements PluginDiscoverer {
    public static final String JAR_FILE_SUFFIX = ".jar";
    private static final Predicate<Path> IS_JAR_FILE = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(p -> p.getFileName().toString().toLowerCase().endsWith(JAR_FILE_SUFFIX));
    protected static final Logger logger = LoggerFactory.getLogger(FileSystemPluginDiscoverer.class);
    private final Path pluginsFolder;
    private ArtifactDescriptorFactory<ServerPluginDescriptor> pluginDescriptorFactory = new ServerPluginDescriptorFactory(new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository(), ArtifactDescriptorValidatorBuilder.builder());

    public FileSystemPluginDiscoverer(Path pluginsFolder) {
        this.pluginsFolder = pluginsFolder;
    }

    @Override
    public List<ServerPluginDescriptor> discover() {
        if (!Files.exists(this.pluginsFolder, new LinkOption[0])) {
            throw new IllegalArgumentException("Plugins folder does not exist: " + String.valueOf(this.pluginsFolder));
        }
        this.unzipNewPluginFiles();
        return this.createPluginsFromFolders();
    }

    private List<ServerPluginDescriptor> createPluginsFromFolders() {
        LinkedList<ServerPluginDescriptor> result = new LinkedList<ServerPluginDescriptor>();
        try (Stream<Path> content = Files.list(this.pluginsFolder).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            content.forEach(file -> {
                try {
                    ServerPluginDescriptor descriptor = (ServerPluginDescriptor)this.pluginDescriptorFactory.create(file.toFile(), Optional.empty());
                    result.add(descriptor);
                }
                catch (Exception e) {
                    logger.warn("Cannot load descriptor for plugin '{}': {} ({})", new Object[]{file.getFileName(), e.getMessage(), e.getClass().getName()});
                }
            });
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read plugins from folder " + String.valueOf(this.pluginsFolder.toAbsolutePath()), e);
        }
        return result;
    }

    private void unzipNewPluginFiles() {
        try (Stream<Path> content = Files.list(this.pluginsFolder).filter(IS_JAR_FILE);){
            content.forEach(file -> {
                try {
                    Path fileName = file.getFileName();
                    logger.info("Unzipping plugin file: {}", (Object)fileName);
                    Path pluginFolder = this.pluginsFolder.resolve(FilenameUtils.getBaseName((String)fileName.toString()));
                    ZipUtils.unzip((File)file.toFile(), (File)pluginFolder.toFile());
                }
                catch (Exception e) {
                    logger.warn("Cannot unzip plugin file '{}'", (Object)file.toAbsolutePath());
                }
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    logger.warn(String.format("Cannot delete plugin file '%s'. Plugin will be overwritten on restart", file.getFileName()));
                }
            });
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read plugins from folder " + String.valueOf(this.pluginsFolder.toAbsolutePath()), e);
        }
    }

    public void setPluginDescriptorFactory(ArtifactDescriptorFactory<ServerPluginDescriptor> pluginDescriptorFactory) {
        this.pluginDescriptorFactory = pluginDescriptorFactory;
    }
}

