/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin;

import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManager;
import com.mulesoft.mule.runtime.plugin.classloader.ServerPluginClassLoaderFactory;
import com.mulesoft.mule.runtime.plugin.discoverer.FileSystemPluginDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.MulePluginConfigurerFactory;
import com.mulesoft.mule.runtime.plugin.factory.MulePluginFactory;
import com.mulesoft.mule.runtime.plugin.factory.MulePluginPropertyDiscovererFactory;
import com.mulesoft.mule.runtime.plugin.factory.PluginFactory;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import com.mulesoft.mule.runtime.plugin.management.internal.MuleContainerWrapperInstanceManager;
import com.mulesoft.mule.runtime.plugin.management.internal.MuleInstanceManagerAwareProcessor;
import com.mulesoft.mule.runtime.plugin.manager.MulePluginManagerFactory;
import com.mulesoft.mule.runtime.plugin.manager.PluginManager;
import com.mulesoft.mule.runtime.plugin.processor.CompositePluginProcessor;
import com.mulesoft.mule.runtime.plugin.processor.PluginProcessor;
import com.mulesoft.mule.runtime.plugin.processor.coreextension.CoreExtensionsAwareProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.DeploymentListenerProviderProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.DeploymentServiceAwareProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.RepositoryServiceAwareProcessor;
import com.mulesoft.mule.runtime.plugin.processor.tooling.ToolingServiceAwareProcessor;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.TrackingArtifactClassLoaderFactory;
import org.mule.runtime.module.deployment.api.DeploymentListenerManager;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.launcher.coreextension.ContainerInjectorBuilder;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingService;

public class ServerPluginCoreExtension
implements MuleCoreExtension {
    public static final String PLUGINS_DIR_PROPERTY = "mule.plugins.dir";
    private PluginManager pluginManager;
    private MuleInstanceManager muleInstanceManager = new MuleContainerWrapperInstanceManager();
    private DeploymentService deploymentService;
    private TroubleshootingService troubleshootingService;
    private List<MuleCoreExtension> coreExtensions;
    private ArtifactClassLoader containerClassLoader;
    private RepositoryService repositoryService;
    private ToolingService toolingService;
    private ArtifactClassLoaderManager artifactClassLoaderManager;
    private EventContextService eventContextService;
    private ServiceRepository serviceRepository;
    private Injector containerInjector;

    public void dispose() {
        if (this.pluginManager != null) {
            this.pluginManager.dispose();
        }
    }

    public void initialise() throws InitialisationException {
        this.containerInjector = this.createContainerInjector();
        this.pluginManager = this.createDefaultPluginManager();
        this.pluginManager.initialise();
    }

    private PluginProcessor createDefaultPluginProcessor() {
        CompositePluginProcessor compositePluginProcessor = new CompositePluginProcessor();
        if (this.muleInstanceManager != null) {
            compositePluginProcessor.addProcessor(new MuleInstanceManagerAwareProcessor(this.muleInstanceManager));
        }
        if (this.deploymentService != null) {
            compositePluginProcessor.addProcessor(new DeploymentListenerProviderProcessor((DeploymentListenerManager)this.deploymentService));
            compositePluginProcessor.addProcessor(new DeploymentServiceAwareProcessor(this.deploymentService));
        }
        if (this.repositoryService != null) {
            compositePluginProcessor.addProcessor(new RepositoryServiceAwareProcessor(this.repositoryService));
        }
        if (this.toolingService != null) {
            compositePluginProcessor.addProcessor(new ToolingServiceAwareProcessor(this.toolingService));
        }
        compositePluginProcessor.addProcessor(new CoreExtensionsAwareProcessor(this.coreExtensions));
        return compositePluginProcessor;
    }

    private Injector createContainerInjector() {
        return ((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)new PluginContainerInjectorBuilder().withDeploymentService(this.deploymentService)).withTroubleshootingService(this.troubleshootingService).withRepositoryService(this.repositoryService)).withServiceRepository(this.serviceRepository)).withCoreExtensions(this.coreExtensions)).withArtifactClassLoaderManager(this.artifactClassLoaderManager)).withEventContextService(this.eventContextService)).withToolingService(this.toolingService).withMuleInstanceManager(this.muleInstanceManager).build();
    }

    private PluginManager createDefaultPluginManager() {
        Path pluginsFolder = this.getPluginsFolder();
        if (!Files.exists(pluginsFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(pluginsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to create server-plugins folder: " + String.valueOf(pluginsFolder));
            }
        }
        FileSystemPluginDiscoverer pluginDiscoverer = new FileSystemPluginDiscoverer(pluginsFolder);
        PluginFactory pluginFactory = this.createDefaultPluginFactory();
        MulePluginManagerFactory pluginManagerFactory = new MulePluginManagerFactory(pluginDiscoverer, pluginFactory);
        PluginProcessor pluginProcessor = this.createDefaultPluginProcessor();
        pluginManagerFactory.setPluginProcessor(pluginProcessor);
        return pluginManagerFactory.create();
    }

    private Path getPluginsFolder() {
        String property = System.getProperty(PLUGINS_DIR_PROPERTY);
        if (StringUtils.isEmpty((CharSequence)property)) {
            return MuleFoldersUtil.getServerPluginsFolderPath();
        }
        return Path.of(property, new String[0]);
    }

    private PluginFactory createDefaultPluginFactory() {
        if (this.containerClassLoader == null) {
            throw new IllegalStateException("ContainerClassLoader was not properly initialized");
        }
        return new MulePluginFactory((ArtifactClassLoaderFactory<ServerPluginDescriptor>)new TrackingArtifactClassLoaderFactory(this.artifactClassLoaderManager, (ArtifactClassLoaderFactory)new ServerPluginClassLoaderFactory()), new MulePluginPropertyDiscovererFactory(), new MulePluginConfigurerFactory(), this.containerClassLoader, this.containerInjector);
    }

    public String getName() {
        return "Mule Plugin Core Extension";
    }

    public void start() throws MuleException {
        this.pluginManager.start();
    }

    public void stop() throws MuleException {
        if (this.pluginManager != null) {
            this.pluginManager.stop();
        }
    }

    @Inject
    public void setMuleInstanceManager(MuleInstanceManager muleInstanceManager) {
        this.muleInstanceManager = muleInstanceManager;
    }

    @Inject
    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Inject
    public void setTroubleshootingService(TroubleshootingService troubleshootingService) {
        this.troubleshootingService = troubleshootingService;
    }

    @Inject
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Inject
    public void setCoreExtensions(List<MuleCoreExtension> coreExtensions) {
        this.coreExtensions = coreExtensions;
    }

    @Inject
    public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
        this.containerClassLoader = containerClassLoader;
    }

    @Inject
    public void setEventContextService(EventContextService eventContextService) {
        this.eventContextService = eventContextService;
    }

    @Inject
    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    @Inject
    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    @Inject
    public void setArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.artifactClassLoaderManager = artifactClassLoaderManager;
    }

    private class PluginContainerInjectorBuilder
    extends ContainerInjectorBuilder<PluginContainerInjectorBuilder> {
        private PluginContainerInjectorBuilder() {
        }

        protected PluginContainerInjectorBuilder getThis() {
            return this;
        }

        public PluginContainerInjectorBuilder withMuleInstanceManager(MuleInstanceManager muleInstanceManager) {
            this.registerObject(MuleInstanceManager.class.getName(), muleInstanceManager);
            return this.getThis();
        }

        public PluginContainerInjectorBuilder withToolingService(ToolingService toolingService) {
            this.registerObject(ToolingService.class.getName(), toolingService);
            return this.getThis();
        }

        public ContainerInjectorBuilder<PluginContainerInjectorBuilder> withTroubleshootingService(TroubleshootingService troubleshootingService) {
            this.registerObject(TroubleshootingService.class.getName(), troubleshootingService);
            return this.getThis();
        }
    }
}

