/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.protocol;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.KryoInstanceFactory;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression.KryoCompressionMode;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression.KryoCompressor;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.mapper.DefaultSerializationMapper;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.mapper.SerializationMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.internal.serialization.AbstractSerializationProtocol;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public final class KryoSerializationProtocol
extends AbstractSerializationProtocol
implements Initialisable {
    private ClassLoaderRepository classLoaderRepository;
    private ClassLoader executionClassLoader;
    private final Injector injector;
    private final KryoInstanceFactory kryoInstanceFactory;
    private LoadingCache<Thread, Kryo> kryoInstances;
    private final KryoCompressor compressor;
    private final SerializationMapper serializationMapper;
    private static ThreadLocal<Boolean> kryoInstanceUsedInThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public KryoSerializationProtocol(KryoInstanceFactory kryoInstanceFactory, KryoCompressionMode compressionMode, ClassLoaderRepository classLoaderRepository, ClassLoader executionClassLoader, Injector injector) {
        this(kryoInstanceFactory, compressionMode, new DefaultSerializationMapper(), classLoaderRepository, executionClassLoader, injector);
    }

    public KryoSerializationProtocol(KryoInstanceFactory kryoInstanceFactory, KryoCompressionMode compressionMode, SerializationMapper serializationMapper, ClassLoaderRepository classLoaderRepository, ClassLoader executionClassLoader, Injector injector) {
        Objects.requireNonNull(kryoInstanceFactory, "Cannot have a null kryoInstanceFactory");
        Objects.requireNonNull(compressionMode, "Cannot have a null compressionMode");
        Objects.requireNonNull(serializationMapper, "Cannot have a null serializationHelper");
        Objects.requireNonNull(classLoaderRepository, "Cannot have a null classLoaderRepository");
        Objects.requireNonNull(executionClassLoader, "Cannot have a null executionClassLoader");
        this.compressor = compressionMode.getCompressor();
        this.kryoInstanceFactory = kryoInstanceFactory;
        this.serializationMapper = serializationMapper;
        this.classLoaderRepository = classLoaderRepository;
        this.executionClassLoader = executionClassLoader;
        this.injector = injector;
    }

    public void initialise() throws InitialisationException {
        this.kryoInstances = Caffeine.newBuilder().weakKeys().build(key -> this.kryoInstanceFactory.getInstance(this.executionClassLoader, Optional.of(this.classLoaderRepository), this.injector));
    }

    public void serialize(Object object, OutputStream out) throws SerializationException {
        this.doSerialize(object, out);
    }

    protected byte[] doSerialize(Object object) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.doSerialize(object, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSerialize(Object object, OutputStream out) throws SerializationException {
        Kryo kryo = this.getKryo();
        boolean kryoInstanceUsedInThreadOldValue = kryoInstanceUsedInThread.get();
        try {
            kryoInstanceUsedInThread.set(true);
            Object mapped = this.serializationMapper.mapBeforeSerialization(object);
            this.onOutput(out, output -> kryo.writeClassAndObject(output, mapped));
        }
        finally {
            kryoInstanceUsedInThread.set(kryoInstanceUsedInThreadOldValue);
        }
    }

    private void onOutput(OutputStream outputStream, Consumer<Output> lambda) {
        Output output;
        try (Output output2 = output = new Output(this.compressor.compress(outputStream));){
            lambda.accept(output);
        }
    }

    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Kryo kryo = this.getKryo();
        kryo.setClassLoader(classLoader);
        Object deserialized = kryo.readClassAndObject(new Input(this.compressor.decompress(inputStream)));
        return (T)this.serializationMapper.mapAfterDeserialization(deserialized);
    }

    private Kryo getKryo() throws SerializationException {
        if (kryoInstanceUsedInThread.get().booleanValue()) {
            try {
                return this.kryoInstanceFactory.getInstance(this.executionClassLoader, Optional.of(this.classLoaderRepository), this.injector);
            }
            catch (Exception e) {
                throw new SerializationException("Unable to create a kryo instance.", (Throwable)e);
            }
        }
        return (Kryo)this.kryoInstances.get((Object)Thread.currentThread());
    }

    protected ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }
}

